/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.pincette.util.Array;
import net.pincette.util.Collections;
import net.pincette.util.Pair;
import net.pincette.util.StreamUtil;
import net.pincette.util.Util;

public class MimeType {
    private static final String OCTET_STREAM = "application/octet-stream";
    private static Map<String, String> extensions;
    private static String[] knownMimeTypes;
    private static Map<String, List<String>> mimeTypes;
    private static Map<String, String> preferredMimeTypes;

    private MimeType() {
    }

    public static String adjustExtension(String filename, String mimeType) {
        int index = filename.lastIndexOf(46);
        if (index != -1 && mimeType.equals(MimeType.getContentTypeFromExtension(filename.substring(index + 1)))) {
            return filename;
        }
        String[] extensions = MimeType.getExtensionsFromMimeType(mimeType);
        if (extensions.length == 0) {
            return filename;
        }
        return (index == -1 ? filename : filename.substring(0, index)) + "." + extensions[0];
    }

    public static String anySubtype(String mimeType) {
        return Optional.of(mimeType.indexOf(47)).filter(index -> index != -1).map(index -> mimeType.substring(0, (int)index) + "/*").orElse(mimeType);
    }

    public static String anyXMLSubtype(String mimeType) {
        return Optional.of(mimeType.indexOf(47)).filter(index -> index != -1).map(index -> mimeType.substring(0, (int)index) + "/*+xml").orElse(mimeType);
    }

    public static String canonical(String mimeType) {
        return MimeType.getParameters(mimeType).entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).sorted().reduce(new StringBuilder(MimeType.stripParameters(mimeType).toLowerCase()), (b, p) -> b.append(';').append((String)p), (b1, b2) -> b1).toString();
    }

    public static String detectType(byte[] b) {
        Supplier<String> pngOr = () -> b.length > 7 && Array.hasPrefix(b, new byte[]{-119, 80, 78, 71, 13, 10, 26, 10}) ? "image/png" : OCTET_STREAM;
        Supplier<String> jpegOr = () -> b.length > 3 && b[0] == 255 && b[1] == 216 && b[b.length - 2] == 255 && b[b.length - 1] == 217 ? "image/jpeg" : (String)pngOr.get();
        return b.length > 5 && Array.hasPrefix(b, new byte[]{71, 73, 70, 56, 57, 97}) ? "image/gif" : jpegOr.get();
    }

    public static String getContentTypeFromExtension(String extension) {
        return Optional.ofNullable(extensions.get(extension)).orElse(OCTET_STREAM);
    }

    public static String getContentTypeFromName(String name) {
        return Optional.of(name.lastIndexOf(46)).filter(index -> index != -1).map(index -> MimeType.getContentTypeFromExtension(name.substring(index + 1))).orElse(OCTET_STREAM);
    }

    public static String[] getExtensionsFromMimeType(String mimeType) {
        return Optional.ofNullable(mimeTypes.get(MimeType.stripParameters(mimeType).toLowerCase())).map(list -> list.toArray(new String[0])).orElse(new String[0]);
    }

    public static String[] getKnownMimeTypes() {
        if (knownMimeTypes == null) {
            knownMimeTypes = MimeType.loadKnownMimeTypes();
        }
        return knownMimeTypes;
    }

    public static String getMediaType(String mimeType) {
        return Optional.of(mimeType.indexOf(47)).filter(index -> index != -1).map(index -> mimeType.substring(0, (int)index).toLowerCase()).orElseGet(mimeType::toLowerCase);
    }

    public static Optional<String> getParameter(String mimeType, String name) {
        return Optional.ofNullable(MimeType.getParameters(mimeType).get(name.toLowerCase()));
    }

    private static Optional<String> getParameterValue(String value) {
        return Optional.of(value.split("[ \"']")).filter(tokens -> ((String[])tokens).length == 1).map(tokens -> tokens[0]);
    }

    public static Map<String, String> getParameters(String mimeType) {
        return Arrays.stream(mimeType.split(";")).map(String::trim).map(s -> Pair.pair(s, s.indexOf(61))).filter(pair -> (Integer)pair.second != -1).map(pair -> Pair.pair(((String)pair.first).substring(0, (Integer)pair.second).trim().toLowerCase(), MimeType.getParameterValue(((String)pair.first).substring((Integer)pair.second + 1)))).filter(pair -> ((Optional)pair.second).isPresent()).collect(Collectors.toMap(pair -> (String)pair.first, pair -> ((Optional)pair.second).orElse(null)));
    }

    public static String getPreferred(String mimeType) {
        if (preferredMimeTypes == null) {
            preferredMimeTypes = MimeType.loadPreferredMimeTypes();
        }
        return Optional.ofNullable(preferredMimeTypes.get(mimeType.toLowerCase())).orElseGet(mimeType::toLowerCase);
    }

    public static String getSubtype(String mimeType) {
        return Optional.of(mimeType.indexOf(47)).filter(index -> index != -1).map(index -> MimeType.stripParameters(mimeType.substring(index + 1)).toLowerCase()).orElse("*");
    }

    public static boolean isGenericXML(String type) {
        return "*/*".equals(type) || "*/*+xml".equals(type) || "text/xml".equals(type) || "application/xml".equals(type) || "application/*+xml".equals(type);
    }

    public static boolean isSubtype(String type, String subtype) {
        return "*/*".equals(type) || MimeType.anySubtype(subtype).equals(type);
    }

    public static boolean isXMLSubtype(String type, String subtype) {
        return net.pincette.xml.Util.isXml(subtype) && MimeType.isGenericXML(type) && !MimeType.isGenericXML(subtype);
    }

    public static String[] loadKnownMimeTypes() {
        return Util.tryToGetRethrow(() -> (String[])Util.readLineConfig(new BufferedReader(new InputStreamReader(MimeType.class.getResourceAsStream("res/mime_types")))).map(String::toLowerCase).toArray(String[]::new)).orElse(new String[0]);
    }

    private static Pair<Map<String, List<String>>, Map<String, String>> loadMimeTypeMap() {
        Pair<Map<String, List<String>>, Map<String, String>> result = Pair.pair(new HashMap(), new HashMap());
        Util.tryToDoRethrow(() -> MimeType.parse(MimeType.class.getResourceAsStream("res/mime_types.map"), (Map)result.first, (Map)result.second));
        return result;
    }

    private static Map<String, String> loadPreferredMimeTypes() {
        Properties properties = new Properties();
        Util.tryToDoRethrow(() -> properties.load(MimeType.class.getResourceAsStream("res/preferred_mime_types.map")));
        return properties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString().toLowerCase(), e -> e.getValue().toString().toLowerCase()));
    }

    private static void mapExtensionsToType(Map<String, String> extensions, String[] tokens) {
        StreamUtil.rangeExclusive(1, tokens.length).forEach(i -> {
            if (!extensions.containsKey(tokens[i])) {
                extensions.put(tokens[i], tokens[0]);
            }
        });
    }

    private static void mapTypeToExtensions(Map<String, List<String>> mimeTypes, String[] tokens) {
        mimeTypes.put(tokens[0], Arrays.asList(Arrays.copyOfRange(tokens, 1, tokens.length)));
    }

    /*
     * Exception decompiling
     */
    private static void parse(InputStream in, Map<String, List<String>> mimeTypes, Map<String, String> extensions) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String setParameter(String mimeType, String name, String value) {
        return MimeType.stripParameters(mimeType) + Collections.put(MimeType.getParameters(mimeType), name.toLowerCase(), value).entrySet().stream().map(e -> ";" + (String)e.getKey() + "=\"" + (String)e.getValue() + "\"").collect(Collectors.joining());
    }

    public static String stripParameters(String mimeType) {
        return Optional.of(mimeType.indexOf(59)).filter(index -> index != -1).map(index -> mimeType.substring(0, (int)index)).orElse(mimeType);
    }

    private static /* synthetic */ void lambda$parse$34(Map extensions, Map mimeTypes, String[] tokens) {
        MimeType.mapExtensionsToType(extensions, tokens);
        MimeType.mapTypeToExtensions(mimeTypes, tokens);
    }

    static {
        Pair<Map<String, List<String>>, Map<String, String>> result = MimeType.loadMimeTypeMap();
        mimeTypes = (Map)result.first;
        extensions = (Map)result.second;
    }
}

