/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.util;

import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;

public class ScheduledCompletionStage {
    private static final Timer TIMER = new Timer("ScheduledCompletionStage");

    private ScheduledCompletionStage() {
    }

    public static <T> CompletionStage<T> composeAsyncAfter(Supplier<CompletionStage<T>> supplier, Duration delay) {
        return ScheduledCompletionStage.runAsyncAfter(supplier, delay);
    }

    private static <T> CompletionStage<T> runAsyncAfter(Supplier<CompletionStage<T>> supplier, Duration delay) {
        final CompletableFuture future = new CompletableFuture();
        TIMER.schedule(new TimerTask(){

            @Override
            public void run() {
                future.complete(true);
            }
        }, delay.toMillis());
        return future.thenComposeAsync(r -> (CompletionStage)supplier.get());
    }

    public static CompletionStage<Void> runAsyncAfter(Runnable runnable, Duration delay) {
        return ScheduledCompletionStage.runAsyncAfter(runnable, delay, ForkJoinPool.commonPool());
    }

    public static CompletionStage<Void> runAsyncAfter(Runnable runnable, Duration delay, Executor executor) {
        return ScheduledCompletionStage.supplyAsyncAfter(() -> {
            runnable.run();
            return null;
        }, delay, executor);
    }

    public static <T> CompletionStage<T> supplyAsyncAfter(Supplier<T> supplier, Duration delay) {
        return ScheduledCompletionStage.supplyAsyncAfter(supplier, delay, ForkJoinPool.commonPool());
    }

    public static <T> CompletionStage<T> supplyAsyncAfter(Supplier<T> supplier, Duration delay, Executor executor) {
        return ScheduledCompletionStage.runAsyncAfter(() -> CompletableFuture.supplyAsync(supplier, executor), delay);
    }
}

