/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.util;

import java.util.stream.Stream;
import net.pincette.util.Pair;
import net.pincette.util.StreamUtil;

public class Shingles {
    private Shingles() {
    }

    public static Stream<String> generate(String word, int minSize, int maxSize) {
        return StreamUtil.rangeInclusive(minSize, Math.min(word.length(), maxSize)).map(i -> Pair.pair(i, word)).flatMap(pair -> Shingles.generate((String)pair.second, (Integer)pair.first));
    }

    public static Stream<String> generate(String word, int size) {
        return size > word.length() ? Stream.empty() : StreamUtil.rangeInclusive(0, Math.max(word.length() - size, 0)).map(i -> word.substring((int)i, i + size));
    }

    public static Stream<String> generate(Stream<String> words, int minSize, int maxSize) {
        return words.flatMap(word -> Shingles.generate(word, minSize, maxSize));
    }
}

