/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.util;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.pincette.util.Collections;
import net.pincette.util.Pair;
import net.pincette.util.State;

public class StreamUtil {
    private StreamUtil() {
    }

    public static <T> CompletionStage<Stream<T>> composeAsyncStream(Stream<CompletionStage<T>> stages) {
        return StreamUtil.composeAsyncStream(stages, ForkJoinPool.commonPool());
    }

    public static <T> CompletionStage<Stream<T>> composeAsyncStream(Stream<CompletionStage<T>> stages, Executor executor) {
        return ((Stream)stages.sequential()).reduce(CompletableFuture.supplyAsync(Stream::builder, executor), (stage, s) -> stage.thenComposeAsync(builder -> s.thenApply(builder::add), executor), (s1, s2) -> s1).thenApply(Stream.Builder::build);
    }

    public static <T> CompletionStage<Stream<T>> composeAsyncSuppliers(Stream<Supplier<CompletionStage<T>>> stages) {
        return StreamUtil.composeAsyncSuppliers(stages, ForkJoinPool.commonPool());
    }

    public static <T> CompletionStage<Stream<T>> composeAsyncSuppliers(Stream<Supplier<CompletionStage<T>>> stages, Executor executor) {
        return ((Stream)stages.sequential()).reduce(CompletableFuture.supplyAsync(Stream::builder, executor), (stage, s) -> stage.thenComposeAsync(arg_0 -> StreamUtil.lambda$composeAsyncSuppliers$3((Supplier)s, arg_0), executor), (s1, s2) -> s1).thenApply(Stream.Builder::build);
    }

    @SafeVarargs
    public static <T> Stream<T> concat(Stream<? extends T> ... streams) {
        return Arrays.stream(streams).reduce(Stream.empty(), Stream::concat, (r1, r2) -> r1);
    }

    public static <T> Iterable<T> iterable(Stream<T> stream) {
        return stream::iterator;
    }

    public static <T> Optional<T> last(Stream<T> stream) {
        return Optional.ofNullable(((Stream)stream.sequential()).reduce(null, (result, element) -> element));
    }

    public static Stream<Long> rangeExclusive(long from, long to) {
        return StreamUtil.rangeExclusive(from, to, 1);
    }

    public static Stream<Long> rangeExclusive(long from, long to, int step) {
        return StreamUtil.stream(new RangeIterator(from, to, step, false)).map(Number::longValue);
    }

    public static Stream<Integer> rangeExclusive(int from, int to) {
        return StreamUtil.rangeExclusive(from, to, 1);
    }

    public static Stream<Integer> rangeExclusive(int from, int to, int step) {
        return StreamUtil.stream(new RangeIterator(from, to, step, false)).map(Number::intValue);
    }

    public static Stream<Long> rangeInclusive(long from, long to) {
        return StreamUtil.rangeInclusive(from, to, 1);
    }

    public static Stream<Long> rangeInclusive(long from, long to, int step) {
        return StreamUtil.stream(new RangeIterator(from, to, step, true)).map(Number::longValue);
    }

    public static Stream<Integer> rangeInclusive(int from, int to) {
        return StreamUtil.rangeInclusive(from, to, 1);
    }

    public static Stream<Integer> rangeInclusive(int from, int to, int step) {
        return StreamUtil.stream(new RangeIterator(from, to, step, true)).map(Number::intValue);
    }

    public static <T> T reduceUntil(T seed, Stream<UnaryOperator<T>> operators, Predicate<T> until) {
        return (T)operators.reduce(seed, (v, o) -> until.test(v) ? v : o.apply(v), (v1, v2) -> v1);
    }

    public static <T> CompletionStage<T> reduceUntilAsync(Supplier<CompletionStage<T>> seed, Stream<Function<T, CompletionStage<T>>> operators, Predicate<T> until) {
        return operators.reduce(seed.get(), (s, o) -> s.thenComposeAsync(v -> until.test(v) ? CompletableFuture.completedFuture(v) : (CompletionStage)o.apply(v)), (s1, s2) -> s1);
    }

    public static <T> Stream<T> repeat(T value, int count) {
        return StreamUtil.rangeExclusive(0, count).map(i -> value);
    }

    public static <T> Stream<List<T>> slide(final Stream<T> stream, final int windowSize) {
        return StreamUtil.stream(new Iterator<List<T>>(){
            final Iterator<T> iterator;
            List<T> window;
            {
                this.iterator = stream.iterator();
            }

            private List<T> initialWindow() {
                return StreamUtil.rangeExclusive(0, windowSize).map(i -> this.iterator.hasNext() ? this.iterator.next() : null).filter(Objects::nonNull).collect(Collectors.toList());
            }

            @Override
            public boolean hasNext() {
                this.window = this.window == null ? this.initialWindow() : this.newWindow();
                return this.window.size() == windowSize;
            }

            private List<T> newWindow() {
                return this.iterator.hasNext() ? Collections.shiftDown(this.window, 1, this.iterator.next()) : java.util.Collections.emptyList();
            }

            @Override
            public List<T> next() {
                if (this.window == null || this.window.size() < windowSize) {
                    throw new NoSuchElementException();
                }
                return this.window;
            }
        });
    }

    public static <T> Stream<T> stream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1296), false);
    }

    public static <T> Stream<T> stream(final Enumeration<T> enumeration) {
        return StreamUtil.stream(new Iterator<T>(){
            private boolean more;

            @Override
            public boolean hasNext() {
                this.more = enumeration.hasMoreElements();
                return this.more;
            }

            @Override
            public T next() {
                if (!this.more) {
                    throw new NoSuchElementException();
                }
                return enumeration.nextElement();
            }
        });
    }

    public static <T> CompletionStage<Stream<T>> supplyAsyncStream(Stream<Supplier<T>> suppliers) {
        return StreamUtil.supplyAsyncStream(suppliers, ForkJoinPool.commonPool());
    }

    public static <T> CompletionStage<Stream<T>> supplyAsyncStream(Stream<Supplier<T>> suppliers, Executor executor) {
        return ((Stream)suppliers.sequential()).reduce(CompletableFuture.supplyAsync(Stream::builder, executor), (stage, s) -> stage.thenApplyAsync(arg_0 -> StreamUtil.lambda$supplyAsyncStream$14((Supplier)s, arg_0), executor), (s1, s2) -> s1).thenApply(Stream.Builder::build);
    }

    public static <T> Stream<T> takeWhile(final T seed, final UnaryOperator<T> f, final Predicate<T> p) {
        return StreamUtil.stream(new Iterator<T>(){
            private T current;
            private boolean ok;
            {
                this.current = seed;
            }

            @Override
            public boolean hasNext() {
                this.ok = p.test(this.current);
                return this.ok;
            }

            @Override
            public T next() {
                if (!this.ok) {
                    throw new NoSuchElementException();
                }
                Object result = this.current;
                this.current = f.apply(this.current);
                return result;
            }
        });
    }

    public static <T, U> Stream<T> takeWhile(final Stream<U> stream, final Function<U, T> seed, final BiFunction<T, U, T> f, final Predicate<T> p) {
        return StreamUtil.stream(new Iterator<T>(){
            private Iterator<U> i;
            private T current;
            private boolean ok;
            {
                this.i = stream.iterator();
                this.current = this.i.hasNext() ? seed.apply(this.i.next()) : null;
            }

            @Override
            public boolean hasNext() {
                this.ok = this.current != null && p.test(this.current);
                return this.ok;
            }

            @Override
            public T next() {
                if (!this.ok) {
                    throw new NoSuchElementException();
                }
                Object result = this.current;
                this.current = this.i.hasNext() ? f.apply(this.current, this.i.next()) : null;
                return result;
            }
        });
    }

    public static <K, V> Map<K, V> toMap(Stream<Pair<K, V>> stream) {
        return stream.collect(Collectors.toMap(pair -> pair.first, pair -> pair.second));
    }

    public static <H, V> Stream<Pair<H, V>> withHeader(Stream<V> stream, Function<V, H> header) {
        State state = new State();
        return StreamUtil.zip(stream, StreamUtil.rangeExclusive(0L, Long.MAX_VALUE)).map(pair -> Pair.pair((Long)pair.second == 0L ? state.set(header.apply(pair.first)) : state.get(), pair.first)).skip(1L);
    }

    public static <T, U> Stream<Pair<T, U>> zip(final Stream<T> s1, final Stream<U> s2) {
        return StreamUtil.stream(new Iterator<Pair<T, U>>(){
            final Iterator<T> i1;
            final Iterator<U> i2;
            private boolean more;
            {
                this.i1 = s1.iterator();
                this.i2 = s2.iterator();
            }

            @Override
            public boolean hasNext() {
                this.more = this.i1.hasNext() && this.i2.hasNext();
                return this.more;
            }

            @Override
            public Pair<T, U> next() {
                if (!this.more) {
                    throw new NoSuchElementException();
                }
                return Pair.pair(this.i1.next(), this.i2.next());
            }
        });
    }

    private static /* synthetic */ Stream.Builder lambda$supplyAsyncStream$14(Supplier s, Stream.Builder builder) {
        return builder.add(s.get());
    }

    private static /* synthetic */ CompletionStage lambda$composeAsyncSuppliers$3(Supplier s, Stream.Builder builder) {
        return ((CompletionStage)s.get()).thenApply(builder::add);
    }

    private static class RangeIterator
    implements Iterator<Number> {
        private final UnaryOperator<Long> doStep;
        private final Predicate<Number> test;
        private long index;

        private RangeIterator(Number from, Number to, int step, boolean inclusive) {
            int realStep = Integer.max(1, step);
            Predicate<Number> less = inclusive ? i -> i.longValue() + (long)realStep <= to.longValue() : i -> i.longValue() + (long)realStep < to.longValue();
            Predicate<Number> more = inclusive ? i -> i.longValue() - (long)realStep >= to.longValue() : i -> i.longValue() - (long)realStep > to.longValue();
            this.test = from.longValue() < to.longValue() ? less : more;
            this.doStep = from.longValue() < to.longValue() ? i -> i + (long)realStep : i -> i - (long)realStep;
            this.index = from.longValue() + (long)(from.longValue() < to.longValue() ? -realStep : realStep);
        }

        @Override
        public boolean hasNext() {
            return this.test.test(this.index);
        }

        @Override
        public Long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.index = (Long)this.doStep.apply(this.index);
            return this.index;
        }
    }
}

