/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.util;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class TimedCache<K, V> {
    private final Map<K, Slot<V>> cache = new ConcurrentHashMap<K, Slot<V>>();
    private final Duration margin;
    private final Duration ttl;
    private Instant lastCleanUp;

    public TimedCache(Duration ttl) {
        this(ttl, Duration.ofMillis(ttl.toMillis() / 5L));
    }

    public TimedCache(Duration ttl, Duration margin) {
        this.ttl = ttl;
        this.margin = margin;
    }

    private void cleanUp() {
        block3: {
            Instant now;
            block2: {
                now = Instant.now();
                if (this.lastCleanUp == null) break block2;
                if (!this.lastCleanUp.isBefore(now.minus(this.margin))) break block3;
            }
            this.cache.entrySet().stream().filter(e -> ((Slot)e.getValue()).timestamp.isBefore(now.minus(this.ttl))).map(Map.Entry::getKey).forEach(this.cache::remove);
            this.lastCleanUp = now;
        }
    }

    public Optional<V> get(K key) {
        this.cleanUp();
        return Optional.ofNullable(this.cache.get(key)).map(s -> s.value);
    }

    public TimedCache<K, V> put(K key, V value) {
        this.cleanUp();
        this.cache.put(key, new Slot<V>(value, Instant.now()));
        return this;
    }

    private static class Slot<T> {
        private final Instant timestamp;
        private final T value;

        private Slot(T value, Instant timestamp) {
            this.value = value;
            this.timestamp = timestamp;
        }
    }
}

