/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.pincette.function.BiFunctionWithException;
import net.pincette.function.ConsumerWithException;
import net.pincette.function.FunctionWithException;
import net.pincette.function.RunnableWithException;
import net.pincette.function.SideEffect;
import net.pincette.function.SupplierWithException;
import net.pincette.io.EscapedUnicodeFilterReader;
import net.pincette.io.StreamConnector;
import net.pincette.util.Expressions;
import net.pincette.util.Pair;
import net.pincette.util.ScheduledCompletionStage;
import net.pincette.util.State;
import net.pincette.util.StreamUtil;

public class Util {
    private static final Pattern EMAIL = Pattern.compile("[\\w.%+\\-]+@[a-zA-Z\\d\\-]+(\\.[a-zA-Z\\d\\-]+)*\\.[a-zA-Z]{2,}");
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final Pattern INSTANT = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|\\+00:00)");

    private Util() {
    }

    public static <T, R> Function<T, R> accumulate(BiFunctionWithException<R, T, R> fn, R initialValue) {
        State state = new State(initialValue);
        return v -> state.set(Util.tryToGetRethrow(() -> fn.apply(state.get(), v)).orElse(null));
    }

    public static Stream<String> allPaths(String path, String delimiter) {
        String leading = path.startsWith(delimiter) ? delimiter : "";
        String[] segments = (String[])Util.getSegments(path, Pattern.quote(delimiter)).toArray(String[]::new);
        return StreamUtil.takeWhile(0, i -> i + 1, i -> i < segments.length).map(i -> leading + Arrays.stream(segments, 0, segments.length - i).collect(Collectors.joining(delimiter)));
    }

    public static <T> AutoCloseWrapper<T> autoClose(SupplierWithException<T> resource, ConsumerWithException<T> close) {
        return new AutoCloseWrapper<T>(resource, close);
    }

    public static String canonicalPath(String path, String delimiter) {
        return delimiter + String.join((CharSequence)delimiter, Util.getSegments(path, delimiter).filter(s -> s.length() > 0 && !s.equals(".")).reduce(new LinkedList(), (l, s) -> {
            if (s.equals("..")) {
                l.removeLast();
            } else {
                l.add(s);
            }
            return l;
        }, (l1, l2) -> l1));
    }

    public static byte[] compress(byte[] b) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Util.tryToDoRethrow(() -> StreamConnector.copy(new ByteArrayInputStream(b), new GZIPOutputStream(out)));
        return out.toByteArray();
    }

    public static Properties copy(Properties properties) {
        Properties result = new Properties();
        properties.stringPropertyNames().forEach(key -> result.setProperty((String)key, properties.getProperty((String)key)));
        return result;
    }

    public static <T> Iterator<Pair<T, Integer>> countingIterator(final Iterator<T> iterator) {
        return new Iterator<Pair<T, Integer>>(){
            private int count = 0;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Pair<T, Integer> next() {
                return Pair.pair(iterator.next(), this.count++);
            }
        };
    }

    public static byte[] decompress(byte[] b) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Util.tryToDoRethrow(() -> StreamConnector.copy(new GZIPInputStream(new ByteArrayInputStream(b)), out));
        return out.toByteArray();
    }

    public static void doForever(RunnableWithException runnable) {
        Util.doForever(runnable, Util::rethrow);
    }

    public static void doForever(RunnableWithException runnable, Consumer<Exception> error) {
        Util.tryToDo(() -> {
            while (true) {
                runnable.run();
            }
        }, error);
    }

    public static boolean equalsOneOf(Object o, Object ... values) {
        return Arrays.asList(values).contains(o);
    }

    private static String flushLines(List<String> buffer) {
        String result = String.join((CharSequence)"", buffer);
        return SideEffect.run(buffer::clear).andThenGet(() -> result);
    }

    public static <T> Consumer<ConsumerWithException<T>> from(T value) {
        return fn -> Util.tryToDoRethrow(() -> fn.accept(value));
    }

    private static Optional<String> getArrayExpression(String name) {
        return Optional.of(name.indexOf(91)).filter(i -> i != -1 && name.charAt(name.length() - 1) == ']').map(i -> name.substring(i + 1, name.length() - 1).trim());
    }

    private static <T> Map<String, Object> getFromList(List<Map<String, Object>> list, String name, Function<T, ?> evaluator) {
        return Util.getArrayExpression(name).map(expr -> {
            int position = Util.getPosition(expr);
            return position >= 0 && position < list.size() ? (Map)list.get(position) : Expressions.parse(expr).flatMap(exp -> list.stream().filter(map -> Boolean.TRUE.equals(exp.evaluate(identifier -> Optional.ofNullable(map.get(identifier)).map(evaluator).orElse(null)))).findFirst()).orElseGet(HashMap::new);
        }).orElseGet(HashMap::new);
    }

    public static Optional<String> getLastSegment(String path, String delimiter) {
        return StreamUtil.last(Util.getSegments(path, delimiter));
    }

    public static String getParent(String path, String delimiter) {
        List segments = Util.getSegments(path, delimiter).collect(Collectors.toList());
        return (path.startsWith(delimiter) ? delimiter : "") + (!segments.isEmpty() ? String.join((CharSequence)delimiter, segments.subList(0, segments.size() - 1)) : "");
    }

    private static int getPosition(String expr) {
        return Util.isInteger(expr) ? Integer.parseInt(expr) : -1;
    }

    public static Stream<String> getSegments(String path, String delimiter) {
        return Arrays.stream(Optional.of(path.split(delimiter)).filter(split2 -> ((String[])split2).length > 0).orElse(new String[]{path})).filter(seg -> seg.length() > 0);
    }

    public static String getStackTrace(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private static <T> Optional<T> handleException(Exception e, Function<Exception, T> error) {
        return error != null ? Optional.ofNullable(error.apply(e)) : SideEffect.run(() -> Util.printStackTrace(e)).andThenGet(Optional::empty);
    }

    private static void handleException(Exception e, Consumer<Exception> error) {
        if (error != null) {
            error.accept(e);
        } else {
            Util.printStackTrace(e);
        }
    }

    public static boolean isDate(String s) {
        return Util.tryToGetSilent(() -> LocalDate.parse(s)).isPresent();
    }

    public static boolean isDouble(String s) {
        return Util.tryToGetSilent(() -> Double.parseDouble(s)).isPresent();
    }

    public static boolean isEmail(String s) {
        return EMAIL.matcher(s).matches();
    }

    public static boolean isFloat(String s) {
        return Util.tryToGetSilent(() -> Float.valueOf(Float.parseFloat(s))).isPresent();
    }

    public static boolean isInstant(String s) {
        return INSTANT.matcher((CharSequence)(!s.endsWith("Z") && !s.endsWith("+00:00") ? s + "Z" : s)).matches();
    }

    public static boolean isInteger(String s) {
        return Util.tryToGetSilent(() -> Integer.parseInt(s)).isPresent();
    }

    public static boolean isLong(String s) {
        return Util.tryToGetSilent(() -> Long.parseLong(s)).isPresent();
    }

    public static boolean isUUID(String s) {
        return Util.tryToGetSilent(() -> UUID.fromString(s)).isPresent();
    }

    public static boolean isUri(String s) {
        return Util.tryToGetSilent(() -> new URI(s)).map(URI::isAbsolute).orElse(false);
    }

    public static Map<String, String> loadProperties(Supplier<InputStream> in) {
        return Util.tryToGet(() -> Util.readLineConfig((InputStream)in.get())).orElse(Stream.empty()).map(line -> line.split("=")).filter(line -> ((String[])line).length == 2).collect(Collectors.toMap(line -> line[0], line -> line[1]));
    }

    public static <T> Iterator<T> matcherIterator(final Matcher matcher, final Function<Matcher, T> generator) {
        return new Iterator<T>(){
            private boolean found;

            @Override
            public boolean hasNext() {
                this.found = matcher.find();
                return this.found;
            }

            @Override
            public T next() {
                if (!this.found) {
                    throw new NoSuchElementException();
                }
                return generator.apply(matcher);
            }
        };
    }

    public static void must(boolean o) {
        if (!o) {
            throw new PredicateException("Unmet predicate");
        }
    }

    public static <T> T must(T o, Predicate<T> predicate) {
        return Util.must(o, predicate, null);
    }

    public static <T> T must(T o, Predicate<T> predicate, ConsumerWithException<T> report) {
        if (!predicate.test(o)) {
            if (report != null) {
                Util.tryToDoRethrow(() -> report.accept(o));
            }
            throw new PredicateException("Unmet predicate");
        }
        return o;
    }

    public static void nop() {
    }

    public static <T> void nop(T arg) {
    }

    public static <T> Optional<T> pathSearch(Map<String, ? extends T> map, String path) {
        return Util.pathSearch(map, path, null);
    }

    public static <T> Optional<T> pathSearch(Map<String, ? extends T> map, String path, Function<T, ?> evaluator) {
        return Util.pathSearch(map, path.split("\\."), evaluator);
    }

    public static <T> Optional<T> pathSearch(Map<String, ? extends T> map, String[] path) {
        return Util.pathSearch(map, path, null);
    }

    public static <T> Optional<T> pathSearch(Map<String, ? extends T> map, String[] path, Function<T, ?> evaluator) {
        return Util.pathSearch(map, Arrays.asList(path), evaluator);
    }

    public static <T> Optional<T> pathSearch(Map<String, ? extends T> map, List<String> path) {
        return Util.pathSearch(map, path, null);
    }

    public static <T> Optional<T> pathSearch(Map<String, ? extends T> map, List<String> path, Function<T, ?> evaluator) {
        Function<Object, Object> eval = evaluator != null ? evaluator : a -> a;
        UnaryOperator evaluateIfList = p -> p.first instanceof List ? Pair.pair(Util.getFromList((List)p.first, (String)path.get((Integer)p.second), eval), (Integer)p.second) : null;
        UnaryOperator evaluateIfMapOr = p -> p.first instanceof Map ? Pair.pair(((Map)p.first).get(Util.stripCondition((String)path.get((Integer)p.second + 1))), (Integer)p.second + 1) : (Pair)evaluateIfList.apply(p);
        UnaryOperator evaluateIfLastOr = p -> (Integer)p.second == path.size() - 1 ? Pair.pair(p.first, Integer.MAX_VALUE) : (Pair)evaluateIfMapOr.apply(p);
        return path.isEmpty() ? Optional.empty() : Stream.iterate(Optional.of(new Pair<T, Integer>(map.get(Util.stripCondition(path.get(0))), 0)), pair -> pair.map(evaluateIfLastOr)).filter(pair -> pair.isEmpty() || pair.map(p -> (Integer)p.second == Integer.MAX_VALUE).orElse(false) != false).map(pair -> pair.map(p -> p.first)).findFirst().orElse(Optional.empty());
    }

    public static void printStackTrace(Throwable e) {
        Logger.getLogger("net.pincette.util.Util").severe(Util.getStackTrace(e));
    }

    public static Stream<String> readLineConfig(InputStream in) throws IOException {
        return Util.readLineConfig(new BufferedReader(new EscapedUnicodeFilterReader(new InputStreamReader(in, StandardCharsets.UTF_8))));
    }

    public static Stream<String> readLineConfig(BufferedReader in) {
        return Util.readLineConfig(in.lines());
    }

    public static Stream<String> readLineConfig(Path path) throws IOException {
        return Util.readLineConfig(Files.lines(path, StandardCharsets.UTF_8));
    }

    public static Stream<String> readLineConfig(Stream<String> lines) {
        ArrayList buffer = new ArrayList();
        return lines.map(line -> (line.indexOf(35) != -1 ? line.substring(0, line.indexOf(35)) : line).trim()).filter(line -> line.length() > 0).map(line -> line.charAt(line.length() - 1) == '\\' ? SideEffect.run(() -> buffer.add(line.substring(0, line.length() - 1))).andThenGet(() -> null) : Util.flushLines(buffer) + line).filter(Objects::nonNull);
    }

    public static char[] repeat(char c, int count) {
        char[] result = new char[count];
        Arrays.fill(result, c);
        return result;
    }

    public static String replaceAll(String s, Pattern pattern, Function<Matcher, String> replacer) {
        StringBuilder builder = new StringBuilder();
        Matcher matcher = pattern.matcher(s);
        int position = 0;
        while (matcher.find()) {
            builder.append(s.substring(position, matcher.start()));
            builder.append(replacer.apply(matcher));
            position = matcher.end();
        }
        builder.append(s.substring(position));
        return builder.toString();
    }

    public static String replaceParameters(String s, Map<String, String> parameters) {
        return Util.replaceParameters(s, parameters, new HashSet<String>());
    }

    public static String replaceParameters(String s, Map<String, String> parameters, Set<String> leave) {
        return Util.replaceParameters(s, parameters, '{', '}', leave);
    }

    public static String replaceParameters(String s, Map<String, String> parameters, char leftBrace, char rightBrace) {
        return Util.replaceParameters(s, parameters, leftBrace, rightBrace, new HashSet<String>());
    }

    public static String replaceParameters(String s, Map<String, String> parameters, char leftBrace, char rightBrace, Set<String> leave) {
        Function<Matcher, String> tryDefault = matcher -> matcher.groupCount() == 3 ? matcher.group(3) : "";
        return Util.replaceAll(s, Pattern.compile("\\$" + (leftBrace == '{' || leftBrace == '(' ? "\\" : "") + leftBrace + "([a-zA-Z0-9_\\-]+)(:([a-zA-Z0-9_\\-]+))?" + rightBrace), matcher -> leave.contains(matcher.group(1)) ? s.substring(matcher.start(), matcher.end()) : Optional.ofNullable((String)parameters.get(matcher.group(1))).orElseGet(() -> (String)tryDefault.apply((Matcher)matcher)));
    }

    public static Optional<File> resolveFile(File baseDirectory, String path) {
        File file = new File(path);
        return !file.isAbsolute() ? Util.tryToGetRethrow(baseDirectory::getCanonicalFile).map(b -> new File((File)b, path)).flatMap(f -> Util.tryToGetRethrow(f::getCanonicalFile)) : Optional.of(file);
    }

    public static void rethrow(Throwable e) {
        throw new GeneralException(e);
    }

    public static Properties set(Properties properties, String key, String value) {
        Properties copy = Util.copy(properties);
        copy.setProperty(key, value);
        return copy;
    }

    private static String stripCondition(String field) {
        return Optional.of(field.indexOf(91)).filter(i -> i != -1).map(i -> field.substring(0, (int)i)).orElse(field);
    }

    public static <T, R> Function<FunctionWithException<T, R>, R> to(T value) {
        return fn -> Util.tryToGetRethrow(() -> fn.apply(value)).orElse(null);
    }

    public static char[] toHex(byte[] bytes) {
        char[] result = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            result[i * 2] = HEX_ARRAY[v >>> 4];
            result[i * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return result;
    }

    public static boolean tryToDo(RunnableWithException run) {
        return Util.tryToDo(run, null);
    }

    public static boolean tryToDo(RunnableWithException run, Consumer<Exception> error) {
        try {
            run.run();
            return true;
        }
        catch (Exception e) {
            Util.handleException(e, error);
            return false;
        }
    }

    public static void tryToDoRethrow(RunnableWithException run) {
        Util.tryToDo(run, Util::rethrow);
    }

    public static boolean tryToDoSilent(RunnableWithException run) {
        return Util.tryToDo(run, Util::nop);
    }

    public static <T> boolean tryToDoWith(SupplierWithException<T> resource, ConsumerWithException<T> fn) {
        return Util.tryToDoWith(resource, fn, null);
    }

    public static <T> boolean tryToDoWith(AutoCloseWrapper<T> resource, ConsumerWithException<T> fn) {
        return Util.tryToDoWith(resource, fn, null);
    }

    public static <T> boolean tryToDoWith(SupplierWithException<T> resource, ConsumerWithException<T> fn, Consumer<Exception> error) {
        boolean bl;
        block8: {
            AutoCloseable r = (AutoCloseable)resource.get();
            try {
                fn.accept(r);
                bl = true;
                if (r == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Util.handleException(e, error);
                    return false;
                }
            }
            r.close();
        }
        return bl;
    }

    public static <T> boolean tryToDoWith(AutoCloseWrapper<T> resource, ConsumerWithException<T> fn, Consumer<Exception> error) {
        boolean bl;
        block8: {
            AutoCloseWrapper<T> r = resource;
            try {
                fn.accept(r.get());
                bl = true;
                if (r == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Util.handleException(e, error);
                    return false;
                }
            }
            r.close();
        }
        return bl;
    }

    public static <T> boolean tryToDoWithRethrow(SupplierWithException<T> resource, ConsumerWithException<T> fn) {
        return Util.tryToDoWith(resource, fn, Util::rethrow);
    }

    public static <T> boolean tryToDoWithRethrow(AutoCloseWrapper<T> resource, ConsumerWithException<T> fn) {
        return Util.tryToDoWith(resource, fn, Util::rethrow);
    }

    public static <T> boolean tryToDoWithSilent(SupplierWithException<T> resource, ConsumerWithException<T> fn) {
        return Util.tryToDoWith(resource, fn, Util::nop);
    }

    public static <T> boolean tryToDoWithSilent(AutoCloseWrapper<T> resource, ConsumerWithException<T> fn) {
        return Util.tryToDoWith(resource, fn, Util::nop);
    }

    public static <T> Optional<T> tryToGet(SupplierWithException<T> run) {
        return Util.tryToGet(run, null);
    }

    public static <T> Optional<T> tryToGet(SupplierWithException<T> run, Function<Exception, T> error) {
        try {
            return Optional.ofNullable(run.get());
        }
        catch (Exception e) {
            return Util.handleException(e, error);
        }
    }

    public static <T> CompletionStage<T> tryToGetForever(SupplierWithException<CompletionStage<T>> run, Duration retryInterval) {
        return Util.tryToGetForever(run, retryInterval, null);
    }

    public static <T> CompletionStage<T> tryToGetForever(SupplierWithException<CompletionStage<T>> run, Duration retryInterval, Consumer<Exception> onException) {
        Supplier<CompletionStage> again = () -> ScheduledCompletionStage.composeAsyncAfter(() -> Util.tryToGetForever(run, retryInterval, onException), retryInterval);
        Consumer<Exception> ex = e -> Optional.ofNullable(onException).ifPresent(on -> on.accept(e));
        return Util.tryToGet(run, e -> (CompletionStage)SideEffect.run(() -> ex.accept((Exception)e)).andThenGet(again)).map(stage -> stage.exceptionally(e -> SideEffect.run(() -> {
            if (e instanceof Exception) {
                ex.accept((Exception)e);
            }
        }).andThenGet(() -> null)).thenComposeAsync(arg_0 -> Util.lambda$tryToGetForever$70((Supplier)again, arg_0))).orElse(null);
    }

    public static <T> Optional<T> tryToGetRethrow(SupplierWithException<T> run) {
        return Util.tryToGet(run, e -> {
            throw new GeneralException((Throwable)e);
        });
    }

    public static <T> Optional<T> tryToGetSilent(SupplierWithException<T> run) {
        return Util.tryToGet(run, e -> null);
    }

    public static <T, R> Optional<R> tryToGetWith(SupplierWithException<T> resource, FunctionWithException<T, R> fn) {
        return Util.tryToGetWith(resource, fn, null);
    }

    public static <T, R> Optional<R> tryToGetWith(AutoCloseWrapper<T> resource, FunctionWithException<T, R> fn) {
        return Util.tryToGetWith(resource, fn, null);
    }

    public static <T, R> Optional<R> tryToGetWith(SupplierWithException<T> resource, FunctionWithException<T, R> fn, Function<Exception, R> error) {
        Optional<R> optional;
        block8: {
            AutoCloseable r = (AutoCloseable)resource.get();
            try {
                optional = Optional.ofNullable(fn.apply(r));
                if (r == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return Util.handleException(e, error);
                }
            }
            r.close();
        }
        return optional;
    }

    public static <T, R> Optional<R> tryToGetWith(AutoCloseWrapper<T> resource, FunctionWithException<T, R> fn, Function<Exception, R> error) {
        Optional<R> optional;
        block8: {
            AutoCloseWrapper<T> r = resource;
            try {
                optional = Optional.ofNullable(fn.apply(r.get()));
                if (r == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return Util.handleException(e, error);
                }
            }
            r.close();
        }
        return optional;
    }

    public static <T, R> Optional<R> tryToGetWithRethrow(SupplierWithException<T> resource, FunctionWithException<T, R> fn) {
        return Util.tryToGetWith(resource, fn, (Exception e) -> {
            throw new GeneralException((Throwable)e);
        });
    }

    public static <T, R> Optional<R> tryToGetWithRethrow(AutoCloseWrapper<T> resource, FunctionWithException<T, R> fn) {
        return Util.tryToGetWith(resource, fn, (Exception e) -> {
            throw new GeneralException((Throwable)e);
        });
    }

    public static <T, R> Optional<R> tryToGetWithSilent(SupplierWithException<T> resource, FunctionWithException<T, R> fn) {
        return Util.tryToGetWith(resource, fn, (Exception e) -> null);
    }

    public static <T, R> Optional<R> tryToGetWithSilent(AutoCloseWrapper<T> resource, FunctionWithException<T, R> fn) {
        return Util.tryToGetWith(resource, fn, (Exception e) -> null);
    }

    private static /* synthetic */ CompletionStage lambda$tryToGetForever$70(Supplier again, Object value) {
        return value != null ? CompletableFuture.completedFuture(value) : (CompletionStage)again.get();
    }

    public static class PredicateException
    extends RuntimeException {
        private PredicateException(String message) {
            super(message);
        }
    }

    public static class GeneralException
    extends RuntimeException {
        public GeneralException(String message) {
            super(message);
        }

        public GeneralException(Throwable cause) {
            super(cause);
        }
    }

    public static class AutoCloseWrapper<T>
    implements AutoCloseable {
        private final ConsumerWithException<T> close;
        private final SupplierWithException<T> resource;
        private T res;

        private AutoCloseWrapper(SupplierWithException<T> resource, ConsumerWithException<T> close) {
            this.resource = resource;
            this.close = close;
        }

        @Override
        public void close() throws Exception {
            if (this.close != null) {
                this.close.accept(this.res);
            }
        }

        private T get() {
            if (this.res == null) {
                this.res = Util.tryToGetRethrow(this.resource::get).orElse(null);
            }
            return this.res;
        }
    }
}

