/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.xml;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.xml.stream.XMLResolver;
import javax.xml.transform.stream.StreamSource;
import net.pincette.io.StreamConnector;
import net.pincette.xml.Util;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class CatalogResolver
implements EntityResolver,
XMLResolver {
    private static final int SINGLE_QUOTE = 0;
    private static final int DOUBLE_QUOTE = 1;
    private static final int OTHER = 2;
    private static final int SPACE = 3;
    private static final int WHITE = 4;
    private static final int EOF = 5;
    private static final int TYP = 0;
    private static final int SQ1 = 1;
    private static final int DQ1 = 2;
    private static final int ID1 = 3;
    private static final int SQ2 = 4;
    private static final int DQ2 = 5;
    private static final int ERR = 6;
    private static final int[][][] FSM = new int[][][]{new int[][]{{1, 1}, {2, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, new int[][]{{3, 1}, {1, 0}, {1, 0}, {1, 0}, {6, 0}, {6, 0}}, new int[][]{{2, 0}, {3, 1}, {2, 0}, {2, 0}, {6, 0}, {6, 0}}, new int[][]{{4, 1}, {5, 1}, {6, 0}, {3, 0}, {3, 0}, {6, 0}}, new int[][]{{0, 1}, {4, 0}, {4, 0}, {4, 0}, {6, 0}, {6, 0}}, new int[][]{{5, 0}, {0, 1}, {5, 0}, {5, 0}, {6, 0}, {6, 0}}};
    private String catalogSystemId;
    private Map<String, String> publicIdentifiers = new HashMap<String, String>();
    private Map<String, String> systemIdentifiers = new HashMap<String, String>();

    public CatalogResolver(URL catalogUrl) throws IOException {
        this(catalogUrl.toString(), null);
    }

    public CatalogResolver(String catalogSystemId) throws IOException {
        this(catalogSystemId, null);
    }

    public CatalogResolver(URL catalogUrl, InputStream in) throws IOException {
        this(catalogUrl.toString(), in);
    }

    public CatalogResolver(String catalogSystemId, InputStream in) throws IOException {
        Supplier<InputStream> tryCatalog = () -> net.pincette.util.Util.tryToGetRethrow(() -> net.pincette.util.Util.isUri(catalogSystemId) ? new URL(catalogSystemId).openStream() : new FileInputStream(catalogSystemId)).orElse(null);
        this.catalogSystemId = catalogSystemId;
        this.load(in != null ? in : tryCatalog.get());
    }

    private static int category(int c) {
        IntSupplier tryWhite = () -> c == 9 || c == 10 || c == 13 ? 4 : 2;
        IntSupplier trySpace = () -> c == 32 ? 3 : tryWhite.getAsInt();
        IntSupplier tryDoubleQuote = () -> c == 34 ? 1 : trySpace.getAsInt();
        return c == 39 ? 0 : tryDoubleQuote.getAsInt();
    }

    private static void error(int in, int line) throws IOException {
        if (in == 5) {
            throw new IOException(CatalogResolver.linePrefix(line) + "premature end of file");
        }
        if (in == 4) {
            throw new IOException(CatalogResolver.linePrefix(line) + "\\t, \\n and \\r are not allowed in an identifier");
        }
        if (in == 2) {
            throw new IOException(CatalogResolver.linePrefix(line) + "white space expected");
        }
    }

    private static String getTypeToken(char[] c, int off, int len, int line) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(new String(c, off, len), " \t\n\r");
        if (!tokenizer.hasMoreTokens()) {
            throw new IOException(CatalogResolver.linePrefix(line) + "PUBLIC or SYSTEM expected");
        }
        String token = tokenizer.nextToken();
        if (!token.equals("PUBLIC") && !token.equals("SYSTEM")) {
            throw new IOException(CatalogResolver.linePrefix(line) + "PUBLIC or SYSTEM expected");
        }
        return token;
    }

    private static String linePrefix(int line) {
        return "Line" + line + ": ";
    }

    public Map<String, String> getPublicIdentifierMappings() {
        return this.publicIdentifiers;
    }

    public Map<String, String> getSystemIdentifierMappings() {
        return this.systemIdentifiers;
    }

    private void load(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamConnector.copy(in, out);
        char[] c = new String(out.toByteArray(), StandardCharsets.US_ASCII).toCharArray();
        String from = null;
        int line = 1;
        int position = 0;
        int state = 0;
        String type = null;
        for (int i = 0; i < c.length; ++i) {
            int[] next = FSM[state][CatalogResolver.category(c[i])];
            if (next[0] == 6) {
                CatalogResolver.error(CatalogResolver.category(c[i]), line);
            }
            if (next[1] == 1) {
                switch (state) {
                    case 0: {
                        type = CatalogResolver.getTypeToken(c, position, i - position, line);
                        break;
                    }
                    case 1: 
                    case 2: {
                        from = new String(c, position, i - position);
                        break;
                    }
                    case 4: 
                    case 5: {
                        ("PUBLIC".equals(type) ? this.publicIdentifiers : this.systemIdentifiers).put(from, Util.resolveSystemId(this.catalogSystemId, new String(c, position, i - position)));
                        break;
                    }
                }
                position = i + 1;
            }
            state = next[0];
            if (c[i] != '\n') continue;
            ++line;
        }
        if (FSM[state][5][0] == 6) {
            CatalogResolver.error(5, line);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        Supplier<String> trySystemId = () -> systemId != null && this.systemIdentifiers.get(systemId) != null ? this.systemIdentifiers.get(systemId) : systemId;
        InputSource result = new InputSource(publicId != null && this.publicIdentifiers.get(publicId) != null ? this.publicIdentifiers.get(publicId) : trySystemId.get());
        result.setPublicId(publicId);
        return result;
    }

    @Override
    public Object resolveEntity(String publicId, String systemId, String baseURI, String namespace) {
        Supplier<String> tryBaseURI = () -> baseURI != null && systemId != null ? Util.resolveSystemId(baseURI, systemId) : systemId;
        Supplier<String> trySystemId = () -> systemId != null && this.systemIdentifiers.get(systemId) != null ? this.systemIdentifiers.get(systemId) : (String)tryBaseURI.get();
        StreamSource result = new StreamSource(publicId != null && this.publicIdentifiers.get(publicId) != null ? this.publicIdentifiers.get(publicId) : trySystemId.get());
        result.setPublicId(publicId);
        return result;
    }
}

