/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.xml;

import java.util.Deque;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import javax.json.stream.JsonParser;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.pincette.xml.Util;

public class JsonEventReader
implements XMLEventReader {
    private final Deque<JsonParser.Event> events = new LinkedList<JsonParser.Event>();
    private final XMLEventFactory factory = XMLEventFactory.newFactory();
    private final Deque<String> keyNames = new LinkedList<String>();
    private final JsonParser parser;
    private final Queue<XMLEvent> queue = new LinkedList<XMLEvent>();
    private boolean endDocument;
    private boolean parserEvent;
    private boolean startDocument;

    public JsonEventReader(JsonParser parser) {
        this.parser = parser;
        this.keyNames.push("doc");
    }

    private static String cleanName(String name) {
        return name.replace("$", "");
    }

    private static String toXmlName(String name) {
        char[] c = name.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            c[i] = Util.isNameChar(c[i]) ? c[i] : 45;
        }
        return (c.length > 0 && Util.isNameStartChar(c[0]) ? "" : "_") + new String(c);
    }

    @Override
    public void close() {
        this.parser.close();
    }

    private XMLEvent createEnd(String name) {
        return this.factory.createEndElement("", "", JsonEventReader.toXmlName(name));
    }

    private XMLEvent createNop() {
        return this.factory.createCharacters("");
    }

    private XMLEvent createStart(String name) {
        return this.factory.createStartElement("", "", JsonEventReader.toXmlName(name));
    }

    private XMLEvent createValue(String value) {
        String name = this.events.peek() == JsonParser.Event.START_ARRAY ? "value" : this.keyNames.peek();
        XMLEvent result = this.createStart(name);
        this.queue.add(this.factory.createCharacters(value));
        this.queue.add(this.createEnd(name));
        return result;
    }

    @Override
    public String getElementText() throws XMLStreamException {
        throw new XMLStreamException("Not supported");
    }

    @Override
    public Object getProperty(String name) {
        throw new IllegalArgumentException("Property " + name + " is not supported");
    }

    private XMLEvent handleEndObject() {
        this.events.pop();
        JsonParser.Event parent = this.events.isEmpty() ? null : this.events.peek();
        return this.createEnd(parent == JsonParser.Event.START_ARRAY ? "object" : this.keyNames.pop());
    }

    private XMLEvent handleEvent(JsonParser.Event event) {
        switch (event) {
            case END_ARRAY: 
            case END_OBJECT: {
                return this.handleEndObject();
            }
            case KEY_NAME: {
                this.keyNames.push(JsonEventReader.cleanName(this.parser.getString()));
                return this.createNop();
            }
            case START_ARRAY: 
            case START_OBJECT: {
                return this.handleStartObject(event);
            }
            case VALUE_FALSE: {
                return this.createValue("false");
            }
            case VALUE_NUMBER: {
                return this.createValue(this.parser.isIntegralNumber() ? String.valueOf(this.parser.getLong()) : this.parser.getBigDecimal().toString());
            }
            case VALUE_TRUE: {
                return this.createValue("true");
            }
            case VALUE_STRING: {
                return this.createValue(this.parser.getString());
            }
        }
        return this.createNop();
    }

    private XMLEvent handleStartObject(JsonParser.Event event) {
        JsonParser.Event parent = this.events.isEmpty() ? null : this.events.peek();
        this.events.push(event);
        return this.createStart(parent == JsonParser.Event.START_ARRAY ? "object" : this.keyNames.peek());
    }

    @Override
    public boolean hasNext() {
        this.parserEvent = false;
        return !this.startDocument || this.queue.peek() != null || this.hasNextParserEvent() || !this.endDocument;
    }

    private boolean hasNextParserEvent() {
        this.parserEvent = this.parser.hasNext();
        return this.parserEvent;
    }

    @Override
    public XMLEvent next() {
        return net.pincette.util.Util.tryToGetRethrow(this::nextEvent).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        if (!this.startDocument) {
            this.startDocument = true;
            return this.factory.createStartDocument();
        }
        if (this.queue.peek() != null) {
            return this.queue.poll();
        }
        if (this.parserEvent) {
            return this.handleEvent(this.parser.next());
        }
        if (!this.endDocument) {
            this.endDocument = true;
            return this.factory.createEndDocument();
        }
        throw new XMLStreamException("No more JSON events");
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        throw new XMLStreamException("Not supported");
    }

    @Override
    public XMLEvent peek() {
        return !this.startDocument ? this.factory.createStartDocument() : this.peekNextAfterStart();
    }

    private XMLEvent peekEnd() {
        return !this.endDocument ? this.factory.createEndDocument() : null;
    }

    private XMLEvent peekNextAfterStart() {
        return this.queue.peek() != null ? this.queue.peek() : this.peekNotQueued();
    }

    private XMLEvent peekNotQueued() {
        return this.parserEvent ? this.peekParserEvent() : this.peekEnd();
    }

    private XMLEvent peekParserEvent() {
        this.parserEvent = false;
        XMLEvent event = this.handleEvent(this.parser.next());
        this.queue.add(event);
        return event;
    }
}

