/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.xml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;

public class NamespacePrefixMap
implements NamespaceContext {
    private final Map<String, Deque<String>> namespaceMap = new HashMap<String, Deque<String>>();
    private final Map<String, Deque<String>> prefixMap = new HashMap<String, Deque<String>>();

    private static void map(Map<String, Deque<String>> mapping, String from, String to) {
        mapping.computeIfAbsent(from, k -> new ArrayDeque()).push(to);
    }

    private static void unmap(Map<String, Deque<String>> mapping, String from) {
        Optional.ofNullable(mapping.get(from)).ifPresent(stack -> {
            stack.pop();
            if (stack.isEmpty()) {
                mapping.remove(from);
            }
        });
    }

    public void endPrefixMapping(String prefix) {
        Optional.ofNullable(this.prefixMap.get(prefix)).ifPresent(stack -> {
            NamespacePrefixMap.unmap(this.namespaceMap, (String)stack.peek());
            NamespacePrefixMap.unmap(this.prefixMap, prefix);
        });
    }

    public Map<String, String> getCurrentPrefixMap() {
        return this.prefixMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Optional.ofNullable((Deque)e.getValue()).map(Deque::peek).orElse("")));
    }

    public String getNamespacePrefix(String uri) {
        if (uri == null || "".equals(uri)) {
            throw new IllegalArgumentException();
        }
        Supplier<String> attrNsOr = () -> "http://www.w3.org/2000/xmlns/".equals(uri) ? "xmlns" : (String)Optional.ofNullable(this.namespaceMap.get(uri)).map(Deque::peek).orElse(null);
        return "http://www.w3.org/XML/1998/namespace".equals(uri) ? "xml" : attrNsOr.get();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        Supplier<String> attrNsOr = () -> "xmlns".equals(prefix) ? "http://www.w3.org/2000/xmlns/" : (String)Optional.ofNullable(this.prefixMap.get(prefix)).map(Deque::peek).orElse(null);
        return "xml".equals(prefix) ? "http://www.w3.org/XML/1998/namespace" : attrNsOr.get();
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.getNamespacePrefix(namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        if (namespaceURI == null || "".equals(namespaceURI)) {
            throw new IllegalArgumentException();
        }
        Supplier<Collection> mapOr = () -> this.namespaceMap.get(namespaceURI) != null ? (Collection)this.namespaceMap.get(namespaceURI) : new ArrayList();
        Supplier<Collection> attrNsOr = () -> "http://www.w3.org/2000/xmlns/".equals(namespaceURI) ? Collections.singletonList("xmlns") : (Collection)mapOr.get();
        return ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI) ? Collections.singletonList("xml") : attrNsOr.get()).iterator();
    }

    public void startPrefixMapping(String prefix, String uri) {
        NamespacePrefixMap.map(this.prefixMap, prefix, uri);
        NamespacePrefixMap.map(this.namespaceMap, uri, prefix);
    }
}

