/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Optional;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.kstream.ValueJoinerWithKey;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.JoinWindowsInternal;
import org.apache.kafka.streams.kstream.internals.KStreamImplJoin;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.KeyAndJoinSide;
import org.apache.kafka.streams.state.internals.LeftOrRightValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KStreamKStreamJoin<K, R, V1, V2>
implements ProcessorSupplier<K, V1> {
    private static final Logger LOG = LoggerFactory.getLogger(KStreamKStreamJoin.class);
    private final String otherWindowName;
    private final long joinBeforeMs;
    private final long joinAfterMs;
    private final long joinGraceMs;
    private final boolean enableSpuriousResultFix;
    private final ValueJoinerWithKey<? super K, ? super V1, ? super V2, ? extends R> joiner;
    private final boolean outer;
    private final Optional<String> outerJoinWindowName;
    private final boolean isLeftSide;
    private final KStreamImplJoin.TimeTracker sharedTimeTracker;

    KStreamKStreamJoin(boolean isLeftSide, String otherWindowName, JoinWindowsInternal windows, ValueJoinerWithKey<? super K, ? super V1, ? super V2, ? extends R> joiner, boolean outer, Optional<String> outerJoinWindowName, KStreamImplJoin.TimeTracker sharedTimeTracker) {
        this.isLeftSide = isLeftSide;
        this.otherWindowName = otherWindowName;
        if (isLeftSide) {
            this.joinBeforeMs = windows.beforeMs;
            this.joinAfterMs = windows.afterMs;
        } else {
            this.joinBeforeMs = windows.afterMs;
            this.joinAfterMs = windows.beforeMs;
        }
        this.joinGraceMs = windows.gracePeriodMs();
        this.enableSpuriousResultFix = windows.spuriousResultFixEnabled();
        this.joiner = joiner;
        this.outer = outer;
        this.outerJoinWindowName = outerJoinWindowName;
        this.sharedTimeTracker = sharedTimeTracker;
    }

    @Override
    public Processor<K, V1> get() {
        return new KStreamKStreamJoinProcessor();
    }

    private class KStreamKStreamJoinProcessor
    extends AbstractProcessor<K, V1> {
        private WindowStore<K, V2> otherWindowStore;
        private Sensor droppedRecordsSensor;
        private Optional<WindowStore<KeyAndJoinSide<K>, LeftOrRightValue>> outerJoinWindowStore = Optional.empty();

        private KStreamKStreamJoinProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            StreamsMetricsImpl metrics = (StreamsMetricsImpl)context.metrics();
            this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(Thread.currentThread().getName(), context.taskId().toString(), metrics);
            this.otherWindowStore = (WindowStore)context.getStateStore(KStreamKStreamJoin.this.otherWindowName);
            if (KStreamKStreamJoin.this.enableSpuriousResultFix) {
                this.outerJoinWindowStore = KStreamKStreamJoin.this.outerJoinWindowName.map(context::getStateStore);
                KStreamKStreamJoin.this.sharedTimeTracker.setEmitInterval(StreamsConfig.InternalConfig.getLong(context.appConfigs(), "__emit.interval.ms.kstreams.outer.join.spurious.results.fix__", 1000L));
            }
        }

        @Override
        public void process(K key, V1 value) {
            if (key == null || value == null) {
                LOG.warn("Skipping record due to null key or value. key=[{}] value=[{}] topic=[{}] partition=[{}] offset=[{}]", key, value, this.context().topic(), this.context().partition(), this.context().offset());
                this.droppedRecordsSensor.record();
                return;
            }
            boolean needOuterJoin = KStreamKStreamJoin.this.outer;
            long inputRecordTimestamp = this.context().timestamp();
            long timeFrom = Math.max(0L, inputRecordTimestamp - KStreamKStreamJoin.this.joinBeforeMs);
            long timeTo = Math.max(0L, inputRecordTimestamp + KStreamKStreamJoin.this.joinAfterMs);
            KStreamKStreamJoin.this.sharedTimeTracker.advanceStreamTime(inputRecordTimestamp);
            if (inputRecordTimestamp == ((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.streamTime) {
                this.outerJoinWindowStore.ifPresent(this::emitNonJoinedOuterRecords);
            }
            try (WindowStoreIterator iter = this.otherWindowStore.fetch(key, timeFrom, timeTo);){
                while (iter.hasNext()) {
                    needOuterJoin = false;
                    KeyValue otherRecord = (KeyValue)iter.next();
                    long otherRecordTimestamp = (Long)otherRecord.key;
                    this.outerJoinWindowStore.ifPresent(store -> store.put(KeyAndJoinSide.make(!KStreamKStreamJoin.this.isLeftSide, key), null, otherRecordTimestamp));
                    this.context().forward(key, KStreamKStreamJoin.this.joiner.apply(key, value, otherRecord.value), To.all().withTimestamp(Math.max(inputRecordTimestamp, otherRecordTimestamp)));
                }
                if (needOuterJoin) {
                    if (!this.outerJoinWindowStore.isPresent() || timeTo < ((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.streamTime) {
                        this.context().forward(key, KStreamKStreamJoin.this.joiner.apply(key, value, null));
                    } else {
                        KStreamKStreamJoin.this.sharedTimeTracker.updatedMinTime(inputRecordTimestamp);
                        this.outerJoinWindowStore.ifPresent(store -> store.put(KeyAndJoinSide.make(KStreamKStreamJoin.this.isLeftSide, key), LeftOrRightValue.make(KStreamKStreamJoin.this.isLeftSide, value), inputRecordTimestamp));
                    }
                }
            }
        }

        private void emitNonJoinedOuterRecords(WindowStore<KeyAndJoinSide<K>, LeftOrRightValue> store) {
            if (((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.minTime >= ((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.streamTime - KStreamKStreamJoin.this.joinAfterMs - KStreamKStreamJoin.this.joinGraceMs) {
                return;
            }
            if (this.context.currentSystemTimeMs() < ((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.nextTimeToEmit) {
                return;
            }
            if (((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.nextTimeToEmit == 0L) {
                ((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.nextTimeToEmit = this.context.currentSystemTimeMs();
            }
            KStreamKStreamJoin.this.sharedTimeTracker.advanceNextTimeToEmit();
            ((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.minTime = Long.MAX_VALUE;
            try (KeyValueIterator it = store.all();){
                while (it.hasNext()) {
                    KeyValue record = (KeyValue)it.next();
                    Windowed windowedKey = (Windowed)record.key;
                    LeftOrRightValue value = (LeftOrRightValue)record.value;
                    ((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.minTime = windowedKey.window().start();
                    if (windowedKey.window().start() + KStreamKStreamJoin.this.joinAfterMs + KStreamKStreamJoin.this.joinGraceMs >= ((KStreamKStreamJoin)KStreamKStreamJoin.this).sharedTimeTracker.streamTime) {
                        break;
                    }
                    Object key = ((KeyAndJoinSide)windowedKey.key()).getKey();
                    long time = windowedKey.window().start();
                    Object nullJoinedValue = KStreamKStreamJoin.this.isLeftSide ? KStreamKStreamJoin.this.joiner.apply(key, value.getLeftValue(), value.getRightValue()) : KStreamKStreamJoin.this.joiner.apply(key, value.getRightValue(), value.getLeftValue());
                    this.context().forward(key, nullJoinedValue, To.all().withTimestamp(time));
                    store.put(((Windowed)record.key).key(), (LeftOrRightValue)null, ((Windowed)record.key).window().start());
                }
            }
        }
    }
}

