/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.SlidingWindows;
import org.apache.kafka.streams.kstream.TimeWindowedCogroupedKStream;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.AbstractStream;
import org.apache.kafka.streams.kstream.internals.CogroupedStreamAggregateBuilder;
import org.apache.kafka.streams.kstream.internals.FullTimeWindowedSerde;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.KGroupedStreamImpl;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.NamedInternal;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;

public class SlidingWindowedCogroupedKStreamImpl<K, V>
extends AbstractStream<K, V>
implements TimeWindowedCogroupedKStream<K, V> {
    private final SlidingWindows windows;
    private final CogroupedStreamAggregateBuilder<K, V> aggregateBuilder;
    private final Map<KGroupedStreamImpl<K, ?>, Aggregator<? super K, ? super Object, V>> groupPatterns;

    SlidingWindowedCogroupedKStreamImpl(SlidingWindows windows, InternalStreamsBuilder builder, Set<String> subTopologySourceNodes, String name, CogroupedStreamAggregateBuilder<K, V> aggregateBuilder, GraphNode graphNode, Map<KGroupedStreamImpl<K, ?>, Aggregator<? super K, ? super Object, V>> groupPatterns) {
        super(name, null, null, subTopologySourceNodes, graphNode, builder);
        this.windows = windows;
        this.aggregateBuilder = aggregateBuilder;
        this.groupPatterns = groupPatterns;
    }

    @Override
    public KTable<Windowed<K>, V> aggregate(Initializer<V> initializer) {
        return this.aggregate(initializer, Materialized.with(null, null));
    }

    @Override
    public KTable<Windowed<K>, V> aggregate(Initializer<V> initializer, Materialized<K, V, WindowStore<Bytes, byte[]>> materialized) {
        return this.aggregate(initializer, NamedInternal.empty(), materialized);
    }

    @Override
    public KTable<Windowed<K>, V> aggregate(Initializer<V> initializer, Named named) {
        return this.aggregate(initializer, named, Materialized.with(null, null));
    }

    @Override
    public KTable<Windowed<K>, V> aggregate(Initializer<V> initializer, Named named, Materialized<K, V, WindowStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(initializer, "initializer can't be null");
        Objects.requireNonNull(named, "named can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, V, WindowStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, V, WindowStore<Bytes, byte[]>>(materialized, this.builder, "COGROUPKSTREAM-AGGREGATE-");
        return this.aggregateBuilder.build(this.groupPatterns, initializer, new NamedInternal(named), this.materialize(materializedInternal), materializedInternal.keySerde() != null ? new FullTimeWindowedSerde<K>(materializedInternal.keySerde(), this.windows.timeDifferenceMs()) : null, materializedInternal.valueSerde(), materializedInternal.queryableStoreName(), this.windows);
    }

    private StoreBuilder<TimestampedWindowStore<K, V>> materialize(MaterializedInternal<K, V, WindowStore<Bytes, byte[]>> materialized) {
        WindowBytesStoreSupplier supplier = (WindowBytesStoreSupplier)materialized.storeSupplier();
        if (supplier == null) {
            long retentionPeriod;
            long l = retentionPeriod = materialized.retention() != null ? materialized.retention().toMillis() : this.windows.gracePeriodMs() + 2L * this.windows.timeDifferenceMs();
            if (this.windows.timeDifferenceMs() * 2L + this.windows.gracePeriodMs() > retentionPeriod) {
                throw new IllegalArgumentException("The retention period of the window store " + this.name + " must be no smaller than 2 * time difference plus the grace period. Got time difference=[" + this.windows.timeDifferenceMs() + "], grace=[" + this.windows.gracePeriodMs() + "], retention=[" + retentionPeriod + "]");
            }
            supplier = Stores.persistentTimestampedWindowStore(materialized.storeName(), Duration.ofMillis(retentionPeriod), Duration.ofMillis(this.windows.timeDifferenceMs()), false);
        }
        StoreBuilder<TimestampedWindowStore<K, V>> builder = Stores.timestampedWindowStoreBuilder(supplier, materialized.keySerde(), materialized.valueSerde());
        if (materialized.loggingEnabled()) {
            builder.withLoggingEnabled(materialized.logConfig());
        } else {
            builder.withLoggingDisabled();
        }
        if (materialized.cachingEnabled()) {
            builder.withCachingEnabled();
        } else {
            builder.withCachingDisabled();
        }
        return builder;
    }
}

