/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableDeserializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableSerde;
import org.apache.kafka.streams.kstream.internals.WrappingNullableSerializer;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.internals.SerdeGetter;

public class WrappingNullableUtils {
    private static <T> Deserializer<T> prepareDeserializer(Deserializer<T> specificDeserializer, ProcessorContext context, boolean isKey, String name) {
        Deserializer<Object> deserializerToUse;
        if (specificDeserializer == null) {
            Deserializer<?> contextKeyDeserializer = context.keySerde().deserializer();
            Deserializer<?> contextValueDeserializer = context.valueSerde().deserializer();
            deserializerToUse = isKey ? contextKeyDeserializer : contextValueDeserializer;
        } else {
            deserializerToUse = specificDeserializer;
            WrappingNullableUtils.initNullableDeserializer(deserializerToUse, new SerdeGetter(context));
        }
        return deserializerToUse;
    }

    private static <T> Serializer<T> prepareSerializer(Serializer<T> specificSerializer, ProcessorContext context, boolean isKey, String name) {
        Serializer<Object> serializerToUse;
        if (specificSerializer == null) {
            Serializer<?> contextKeySerializer = context.keySerde().serializer();
            Serializer<?> contextValueSerializer = context.valueSerde().serializer();
            serializerToUse = isKey ? contextKeySerializer : contextValueSerializer;
        } else {
            serializerToUse = specificSerializer;
            WrappingNullableUtils.initNullableSerializer(serializerToUse, new SerdeGetter(context));
        }
        return serializerToUse;
    }

    private static <T> Serde<T> prepareSerde(Serde<T> specificSerde, SerdeGetter getter, boolean isKey) {
        Serde serdeToUse = specificSerde == null ? (isKey ? getter.keySerde() : getter.valueSerde()) : specificSerde;
        if (serdeToUse instanceof WrappingNullableSerde) {
            ((WrappingNullableSerde)serdeToUse).setIfUnset(getter);
        }
        return serdeToUse;
    }

    public static <K> Deserializer<K> prepareKeyDeserializer(Deserializer<K> specificDeserializer, ProcessorContext context, String name) {
        return WrappingNullableUtils.prepareDeserializer(specificDeserializer, context, true, name);
    }

    public static <V> Deserializer<V> prepareValueDeserializer(Deserializer<V> specificDeserializer, ProcessorContext context, String name) {
        return WrappingNullableUtils.prepareDeserializer(specificDeserializer, context, false, name);
    }

    public static <K> Serializer<K> prepareKeySerializer(Serializer<K> specificSerializer, ProcessorContext context, String name) {
        return WrappingNullableUtils.prepareSerializer(specificSerializer, context, true, name);
    }

    public static <V> Serializer<V> prepareValueSerializer(Serializer<V> specificSerializer, ProcessorContext context, String name) {
        return WrappingNullableUtils.prepareSerializer(specificSerializer, context, false, name);
    }

    public static <K> Serde<K> prepareKeySerde(Serde<K> specificSerde, SerdeGetter getter) {
        return WrappingNullableUtils.prepareSerde(specificSerde, getter, true);
    }

    public static <V> Serde<V> prepareValueSerde(Serde<V> specificSerde, SerdeGetter getter) {
        return WrappingNullableUtils.prepareSerde(specificSerde, getter, false);
    }

    public static <T> void initNullableSerializer(Serializer<T> specificSerializer, SerdeGetter getter) {
        if (specificSerializer instanceof WrappingNullableSerializer) {
            ((WrappingNullableSerializer)specificSerializer).setIfUnset(getter);
        }
    }

    public static <T> void initNullableDeserializer(Deserializer<T> specificDeserializer, SerdeGetter getter) {
        if (specificDeserializer instanceof WrappingNullableDeserializer) {
            ((WrappingNullableDeserializer)specificDeserializer).setIfUnset(getter);
        }
    }
}

