/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.BatchingStateRestoreCallback;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.internals.RecordBatchingStateRestoreCallback;

public final class StateRestoreCallbackAdapter {
    private StateRestoreCallbackAdapter() {
    }

    public static RecordBatchingStateRestoreCallback adapt(StateRestoreCallback restoreCallback) {
        Objects.requireNonNull(restoreCallback, "stateRestoreCallback must not be null");
        if (restoreCallback instanceof RecordBatchingStateRestoreCallback) {
            return (RecordBatchingStateRestoreCallback)restoreCallback;
        }
        if (restoreCallback instanceof BatchingStateRestoreCallback) {
            return records -> {
                ArrayList<KeyValue<byte[], byte[]>> keyValues = new ArrayList<KeyValue<byte[], byte[]>>();
                for (ConsumerRecord record : records) {
                    keyValues.add(new KeyValue(record.key(), record.value()));
                }
                ((BatchingStateRestoreCallback)restoreCallback).restoreAll(keyValues);
            };
        }
        return records -> {
            for (ConsumerRecord record : records) {
                restoreCallback.restore((byte[])record.key(), (byte[])record.value());
            }
        };
    }
}

