/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.streams.errors.TaskAssignmentException;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.assignment.ConsumerProtocolUtils;
import org.apache.kafka.streams.state.HostInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignmentInfo {
    private static final Logger log = LoggerFactory.getLogger(AssignmentInfo.class);
    private final int usedVersion;
    private final int commonlySupportedVersion;
    private List<TaskId> activeTasks;
    private Map<TaskId, Set<TopicPartition>> standbyTasks;
    private Map<HostInfo, Set<TopicPartition>> partitionsByHost;
    private Map<HostInfo, Set<TopicPartition>> standbyPartitionsByHost;
    private int errCode;
    private Long nextRebalanceMs = Long.MAX_VALUE;

    public AssignmentInfo(int version, int commonlySupportedVersion) {
        this(version, commonlySupportedVersion, Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), 0);
    }

    public AssignmentInfo(int version, List<TaskId> activeTasks, Map<TaskId, Set<TopicPartition>> standbyTasks, Map<HostInfo, Set<TopicPartition>> partitionsByHost, Map<HostInfo, Set<TopicPartition>> standbyPartitionsByHost, int errCode) {
        this(version, 10, activeTasks, standbyTasks, partitionsByHost, standbyPartitionsByHost, errCode);
    }

    public AssignmentInfo(int version, int commonlySupportedVersion, List<TaskId> activeTasks, Map<TaskId, Set<TopicPartition>> standbyTasks, Map<HostInfo, Set<TopicPartition>> partitionsByHost, Map<HostInfo, Set<TopicPartition>> standbyPartitionsByHost, int errCode) {
        this.usedVersion = version;
        this.commonlySupportedVersion = commonlySupportedVersion;
        this.activeTasks = activeTasks;
        this.standbyTasks = standbyTasks;
        this.partitionsByHost = partitionsByHost;
        this.standbyPartitionsByHost = standbyPartitionsByHost;
        this.errCode = errCode;
        if (version < 1 || version > 10) {
            throw new IllegalArgumentException("version must be between 1 and 10; was: " + version);
        }
    }

    public void setNextRebalanceTime(long nextRebalanceTimeMs) {
        this.nextRebalanceMs = nextRebalanceTimeMs;
    }

    public int version() {
        return this.usedVersion;
    }

    public int errCode() {
        return this.errCode;
    }

    public int commonlySupportedVersion() {
        return this.commonlySupportedVersion;
    }

    public List<TaskId> activeTasks() {
        return this.activeTasks;
    }

    public Map<TaskId, Set<TopicPartition>> standbyTasks() {
        return this.standbyTasks;
    }

    public Map<HostInfo, Set<TopicPartition>> partitionsByHost() {
        return this.partitionsByHost;
    }

    public Map<HostInfo, Set<TopicPartition>> standbyPartitionByHost() {
        return this.standbyPartitionsByHost;
    }

    public long nextRebalanceMs() {
        return this.nextRebalanceMs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer encode() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(baos);){
            switch (this.usedVersion) {
                case 1: {
                    out.writeInt(this.usedVersion);
                    this.encodeActiveAndStandbyTaskAssignment(out);
                    break;
                }
                case 2: {
                    out.writeInt(this.usedVersion);
                    this.encodeActiveAndStandbyTaskAssignment(out);
                    this.encodePartitionsByHost(out);
                    break;
                }
                case 3: {
                    out.writeInt(this.usedVersion);
                    out.writeInt(this.commonlySupportedVersion);
                    this.encodeActiveAndStandbyTaskAssignment(out);
                    this.encodePartitionsByHost(out);
                    break;
                }
                case 4: {
                    out.writeInt(this.usedVersion);
                    out.writeInt(this.commonlySupportedVersion);
                    this.encodeActiveAndStandbyTaskAssignment(out);
                    this.encodePartitionsByHost(out);
                    out.writeInt(this.errCode);
                    break;
                }
                case 5: {
                    out.writeInt(this.usedVersion);
                    out.writeInt(this.commonlySupportedVersion);
                    this.encodeActiveAndStandbyTaskAssignment(out);
                    this.encodePartitionsByHostAsDictionary(out);
                    out.writeInt(this.errCode);
                    break;
                }
                case 6: {
                    out.writeInt(this.usedVersion);
                    out.writeInt(this.commonlySupportedVersion);
                    this.encodeActiveAndStandbyTaskAssignment(out);
                    this.encodeActiveAndStandbyHostPartitions(out);
                    out.writeInt(this.errCode);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    out.writeInt(this.usedVersion);
                    out.writeInt(this.commonlySupportedVersion);
                    this.encodeActiveAndStandbyTaskAssignment(out);
                    this.encodeActiveAndStandbyHostPartitions(out);
                    out.writeInt(this.errCode);
                    out.writeLong(this.nextRebalanceMs);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown metadata version: " + this.usedVersion + "; latest commonly supported version: " + this.commonlySupportedVersion);
                }
            }
            out.flush();
            out.close();
            ByteBuffer byteBuffer = ByteBuffer.wrap(baos.toByteArray());
            return byteBuffer;
        }
        catch (IOException ex) {
            throw new TaskAssignmentException("Failed to encode AssignmentInfo", ex);
        }
    }

    private void encodeActiveAndStandbyTaskAssignment(DataOutputStream out) throws IOException {
        out.writeInt(this.activeTasks.size());
        for (TaskId taskId : this.activeTasks) {
            ConsumerProtocolUtils.writeTaskIdTo(taskId, out, this.usedVersion);
        }
        out.writeInt(this.standbyTasks.size());
        for (Map.Entry entry : this.standbyTasks.entrySet()) {
            TaskId id = (TaskId)entry.getKey();
            ConsumerProtocolUtils.writeTaskIdTo(id, out, this.usedVersion);
            Set partitions = (Set)entry.getValue();
            this.writeTopicPartitions(out, partitions);
        }
    }

    private void encodePartitionsByHost(DataOutputStream out) throws IOException {
        out.writeInt(this.partitionsByHost.size());
        for (Map.Entry<HostInfo, Set<TopicPartition>> entry : this.partitionsByHost.entrySet()) {
            this.writeHostInfo(out, entry.getKey());
            this.writeTopicPartitions(out, entry.getValue());
        }
    }

    private void encodeHostPartitionMapUsingDictionary(DataOutputStream out, Map<String, Integer> topicNameDict, Map<HostInfo, Set<TopicPartition>> hostPartitionMap) throws IOException {
        out.writeInt(hostPartitionMap.size());
        for (Map.Entry<HostInfo, Set<TopicPartition>> entry : hostPartitionMap.entrySet()) {
            this.writeHostInfo(out, entry.getKey());
            out.writeInt(entry.getValue().size());
            for (TopicPartition partition : entry.getValue()) {
                out.writeInt(topicNameDict.get(partition.topic()));
                out.writeInt(partition.partition());
            }
        }
    }

    private Map<String, Integer> encodeTopicDictionaryAndGet(DataOutputStream out, Set<TopicPartition> topicPartitions) throws IOException {
        int topicIndex = 0;
        HashMap<String, Integer> topicNameDict = new HashMap<String, Integer>();
        for (TopicPartition topicPartition : topicPartitions) {
            if (topicNameDict.containsKey(topicPartition.topic())) continue;
            topicNameDict.put(topicPartition.topic(), topicIndex++);
        }
        out.writeInt(topicNameDict.size());
        for (Map.Entry entry : topicNameDict.entrySet()) {
            out.writeInt((Integer)entry.getValue());
            out.writeUTF((String)entry.getKey());
        }
        return topicNameDict;
    }

    private void encodePartitionsByHostAsDictionary(DataOutputStream out) throws IOException {
        Set<TopicPartition> allTopicPartitions = this.partitionsByHost.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Map<String, Integer> topicNameDict = this.encodeTopicDictionaryAndGet(out, allTopicPartitions);
        this.encodeHostPartitionMapUsingDictionary(out, topicNameDict, this.partitionsByHost);
    }

    private void encodeActiveAndStandbyHostPartitions(DataOutputStream out) throws IOException {
        Set<TopicPartition> allTopicPartitions = Stream.concat(this.partitionsByHost.values().stream(), this.standbyPartitionsByHost.values().stream()).flatMap(Collection::stream).collect(Collectors.toSet());
        Map<String, Integer> topicNameDict = this.encodeTopicDictionaryAndGet(out, allTopicPartitions);
        this.encodeHostPartitionMapUsingDictionary(out, topicNameDict, this.partitionsByHost);
        this.encodeHostPartitionMapUsingDictionary(out, topicNameDict, this.standbyPartitionsByHost);
    }

    private void writeHostInfo(DataOutputStream out, HostInfo hostInfo) throws IOException {
        out.writeUTF(hostInfo.host());
        out.writeInt(hostInfo.port());
    }

    private void writeTopicPartitions(DataOutputStream out, Set<TopicPartition> partitions) throws IOException {
        out.writeInt(partitions.size());
        for (TopicPartition partition : partitions) {
            out.writeUTF(partition.topic());
            out.writeInt(partition.partition());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AssignmentInfo decode(ByteBuffer data) {
        data.rewind();
        try (DataInputStream in = new DataInputStream(new ByteBufferInputStream(data));){
            AssignmentInfo assignmentInfo;
            int usedVersion = in.readInt();
            switch (usedVersion) {
                case 1: {
                    assignmentInfo = new AssignmentInfo(usedVersion, -1);
                    AssignmentInfo.decodeActiveTasks(assignmentInfo, in);
                    AssignmentInfo.decodeStandbyTasks(assignmentInfo, in);
                    assignmentInfo.partitionsByHost = new HashMap<HostInfo, Set<TopicPartition>>();
                    break;
                }
                case 2: {
                    assignmentInfo = new AssignmentInfo(usedVersion, -1);
                    AssignmentInfo.decodeActiveTasks(assignmentInfo, in);
                    AssignmentInfo.decodeStandbyTasks(assignmentInfo, in);
                    AssignmentInfo.decodePartitionsByHost(assignmentInfo, in);
                    break;
                }
                case 3: {
                    int commonlySupportedVersion = in.readInt();
                    assignmentInfo = new AssignmentInfo(usedVersion, commonlySupportedVersion);
                    AssignmentInfo.decodeActiveTasks(assignmentInfo, in);
                    AssignmentInfo.decodeStandbyTasks(assignmentInfo, in);
                    AssignmentInfo.decodePartitionsByHost(assignmentInfo, in);
                    break;
                }
                case 4: {
                    int commonlySupportedVersion = in.readInt();
                    assignmentInfo = new AssignmentInfo(usedVersion, commonlySupportedVersion);
                    AssignmentInfo.decodeActiveTasks(assignmentInfo, in);
                    AssignmentInfo.decodeStandbyTasks(assignmentInfo, in);
                    AssignmentInfo.decodePartitionsByHost(assignmentInfo, in);
                    assignmentInfo.errCode = in.readInt();
                    break;
                }
                case 5: {
                    int commonlySupportedVersion = in.readInt();
                    assignmentInfo = new AssignmentInfo(usedVersion, commonlySupportedVersion);
                    AssignmentInfo.decodeActiveTasks(assignmentInfo, in);
                    AssignmentInfo.decodeStandbyTasks(assignmentInfo, in);
                    AssignmentInfo.decodePartitionsByHostUsingDictionary(assignmentInfo, in);
                    assignmentInfo.errCode = in.readInt();
                    break;
                }
                case 6: {
                    int commonlySupportedVersion = in.readInt();
                    assignmentInfo = new AssignmentInfo(usedVersion, commonlySupportedVersion);
                    AssignmentInfo.decodeActiveTasks(assignmentInfo, in);
                    AssignmentInfo.decodeStandbyTasks(assignmentInfo, in);
                    AssignmentInfo.decodeActiveAndStandbyHostPartitions(assignmentInfo, in);
                    assignmentInfo.errCode = in.readInt();
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    int commonlySupportedVersion = in.readInt();
                    assignmentInfo = new AssignmentInfo(usedVersion, commonlySupportedVersion);
                    AssignmentInfo.decodeActiveTasks(assignmentInfo, in);
                    AssignmentInfo.decodeStandbyTasks(assignmentInfo, in);
                    AssignmentInfo.decodeActiveAndStandbyHostPartitions(assignmentInfo, in);
                    assignmentInfo.errCode = in.readInt();
                    assignmentInfo.nextRebalanceMs = in.readLong();
                    break;
                }
                default: {
                    TaskAssignmentException fatalException = new TaskAssignmentException("Unable to decode assignment data: used version: " + usedVersion + "; latest supported version: " + 10);
                    log.error(fatalException.getMessage(), fatalException);
                    throw fatalException;
                }
            }
            AssignmentInfo assignmentInfo2 = assignmentInfo;
            return assignmentInfo2;
        }
        catch (IOException ex) {
            throw new TaskAssignmentException("Failed to decode AssignmentInfo", ex);
        }
    }

    private static void decodeActiveTasks(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        int count = in.readInt();
        assignmentInfo.activeTasks = new ArrayList<TaskId>(count);
        for (int i = 0; i < count; ++i) {
            assignmentInfo.activeTasks.add(ConsumerProtocolUtils.readTaskIdFrom(in, assignmentInfo.usedVersion));
        }
    }

    private static void decodeStandbyTasks(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        int count = in.readInt();
        assignmentInfo.standbyTasks = new HashMap<TaskId, Set<TopicPartition>>(count);
        for (int i = 0; i < count; ++i) {
            TaskId id = ConsumerProtocolUtils.readTaskIdFrom(in, assignmentInfo.usedVersion);
            assignmentInfo.standbyTasks.put(id, AssignmentInfo.readTopicPartitions(in));
        }
    }

    private static void decodePartitionsByHost(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        assignmentInfo.partitionsByHost = new HashMap<HostInfo, Set<TopicPartition>>();
        int numEntries = in.readInt();
        for (int i = 0; i < numEntries; ++i) {
            HostInfo hostInfo = new HostInfo(in.readUTF(), in.readInt());
            assignmentInfo.partitionsByHost.put(hostInfo, AssignmentInfo.readTopicPartitions(in));
        }
    }

    private static Set<TopicPartition> readTopicPartitions(DataInputStream in) throws IOException {
        int numPartitions = in.readInt();
        HashSet<TopicPartition> partitions = new HashSet<TopicPartition>(numPartitions);
        for (int j = 0; j < numPartitions; ++j) {
            partitions.add(new TopicPartition(in.readUTF(), in.readInt()));
        }
        return partitions;
    }

    private static Map<Integer, String> decodeTopicIndexAndGet(DataInputStream in) throws IOException {
        int dictSize = in.readInt();
        HashMap<Integer, String> topicIndexDict = new HashMap<Integer, String>(dictSize);
        for (int i = 0; i < dictSize; ++i) {
            topicIndexDict.put(in.readInt(), in.readUTF());
        }
        return topicIndexDict;
    }

    private static Map<HostInfo, Set<TopicPartition>> decodeHostPartitionMapUsingDictionary(DataInputStream in, Map<Integer, String> topicIndexDict) throws IOException {
        HashMap<HostInfo, Set<TopicPartition>> hostPartitionMap = new HashMap<HostInfo, Set<TopicPartition>>();
        int numEntries = in.readInt();
        for (int i = 0; i < numEntries; ++i) {
            HostInfo hostInfo = new HostInfo(in.readUTF(), in.readInt());
            hostPartitionMap.put(hostInfo, AssignmentInfo.readTopicPartitions(in, topicIndexDict));
        }
        return hostPartitionMap;
    }

    private static void decodePartitionsByHostUsingDictionary(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        Map<Integer, String> topicIndexDict = AssignmentInfo.decodeTopicIndexAndGet(in);
        assignmentInfo.partitionsByHost = AssignmentInfo.decodeHostPartitionMapUsingDictionary(in, topicIndexDict);
    }

    private static void decodeActiveAndStandbyHostPartitions(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        Map<Integer, String> topicIndexDict = AssignmentInfo.decodeTopicIndexAndGet(in);
        assignmentInfo.partitionsByHost = AssignmentInfo.decodeHostPartitionMapUsingDictionary(in, topicIndexDict);
        assignmentInfo.standbyPartitionsByHost = AssignmentInfo.decodeHostPartitionMapUsingDictionary(in, topicIndexDict);
    }

    private static Set<TopicPartition> readTopicPartitions(DataInputStream in, Map<Integer, String> topicIndexDict) throws IOException {
        int numPartitions = in.readInt();
        HashSet<TopicPartition> partitions = new HashSet<TopicPartition>(numPartitions);
        for (int j = 0; j < numPartitions; ++j) {
            partitions.add(new TopicPartition(topicIndexDict.get(in.readInt()), in.readInt()));
        }
        return partitions;
    }

    public int hashCode() {
        int hostMapHashCode = this.partitionsByHost.hashCode() ^ this.standbyPartitionsByHost.hashCode();
        return this.usedVersion ^ this.commonlySupportedVersion ^ this.activeTasks.hashCode() ^ this.standbyTasks.hashCode() ^ hostMapHashCode ^ this.errCode;
    }

    public boolean equals(Object o) {
        if (o instanceof AssignmentInfo) {
            AssignmentInfo other = (AssignmentInfo)o;
            return this.usedVersion == other.usedVersion && this.commonlySupportedVersion == other.commonlySupportedVersion && this.errCode == other.errCode && this.activeTasks.equals(other.activeTasks) && this.standbyTasks.equals(other.standbyTasks) && this.partitionsByHost.equals(other.partitionsByHost) && this.standbyPartitionsByHost.equals(other.standbyPartitionsByHost);
        }
        return false;
    }

    public String toString() {
        return "[version=" + this.usedVersion + ", supported version=" + this.commonlySupportedVersion + ", active tasks=" + this.activeTasks + ", standby tasks=" + this.standbyTasks + ", partitions by host=" + this.partitionsByHost + ", standbyPartitions by host=" + this.standbyPartitionsByHost + "]";
    }
}

