/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.ReadOnlySessionStore;
import org.apache.kafka.streams.state.internals.CompositeKeyValueIterator;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.NextIteratorFunction;
import org.apache.kafka.streams.state.internals.StateStoreProvider;

public class CompositeReadOnlySessionStore<K, V>
implements ReadOnlySessionStore<K, V> {
    private final StateStoreProvider storeProvider;
    private final QueryableStoreType<ReadOnlySessionStore<K, V>> queryableStoreType;
    private final String storeName;

    public CompositeReadOnlySessionStore(StateStoreProvider storeProvider, QueryableStoreType<ReadOnlySessionStore<K, V>> queryableStoreType, String storeName) {
        this.storeProvider = storeProvider;
        this.queryableStoreType = queryableStoreType;
        this.storeName = storeName;
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> findSessions(K key, long earliestSessionEndTime, long latestSessionStartTime) {
        Objects.requireNonNull(key, "key can't be null");
        List<ReadOnlySessionStore<K, V>> stores = this.storeProvider.stores(this.storeName, this.queryableStoreType);
        for (ReadOnlySessionStore<K, V> store : stores) {
            try {
                KeyValueIterator<Windowed<K>, V> result = store.findSessions(key, earliestSessionEndTime, latestSessionStartTime);
                if (!result.hasNext()) {
                    result.close();
                    continue;
                }
                return result;
            }
            catch (InvalidStateStoreException ise) {
                throw new InvalidStateStoreException("State store  [" + this.storeName + "] is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.", ise);
            }
        }
        return KeyValueIterators.emptyIterator();
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardFindSessions(K key, long earliestSessionEndTime, long latestSessionStartTime) {
        Objects.requireNonNull(key, "key can't be null");
        List<ReadOnlySessionStore<K, V>> stores = this.storeProvider.stores(this.storeName, this.queryableStoreType);
        for (ReadOnlySessionStore<K, V> store : stores) {
            try {
                KeyValueIterator<Windowed<K>, V> result = store.backwardFindSessions(key, earliestSessionEndTime, latestSessionStartTime);
                if (!result.hasNext()) {
                    result.close();
                    continue;
                }
                return result;
            }
            catch (InvalidStateStoreException ise) {
                throw new InvalidStateStoreException("State store  [" + this.storeName + "] is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.", ise);
            }
        }
        return KeyValueIterators.emptyIterator();
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> findSessions(K keyFrom, K keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        Objects.requireNonNull(keyFrom, "from can't be null");
        Objects.requireNonNull(keyTo, "to can't be null");
        List<ReadOnlySessionStore<K, V>> stores = this.storeProvider.stores(this.storeName, this.queryableStoreType);
        for (ReadOnlySessionStore<K, V> store : stores) {
            try {
                KeyValueIterator<Windowed<K>, V> result = store.findSessions(keyFrom, keyTo, earliestSessionEndTime, latestSessionStartTime);
                if (!result.hasNext()) {
                    result.close();
                    continue;
                }
                return result;
            }
            catch (InvalidStateStoreException ise) {
                throw new InvalidStateStoreException("State store  [" + this.storeName + "] is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.", ise);
            }
        }
        return KeyValueIterators.emptyIterator();
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardFindSessions(K keyFrom, K keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        Objects.requireNonNull(keyFrom, "from can't be null");
        Objects.requireNonNull(keyTo, "to can't be null");
        List<ReadOnlySessionStore<K, V>> stores = this.storeProvider.stores(this.storeName, this.queryableStoreType);
        for (ReadOnlySessionStore<K, V> store : stores) {
            try {
                KeyValueIterator<Windowed<K>, V> result = store.backwardFindSessions(keyFrom, keyTo, earliestSessionEndTime, latestSessionStartTime);
                if (!result.hasNext()) {
                    result.close();
                    continue;
                }
                return result;
            }
            catch (InvalidStateStoreException ise) {
                throw new InvalidStateStoreException("State store  [" + this.storeName + "] is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.", ise);
            }
        }
        return KeyValueIterators.emptyIterator();
    }

    @Override
    public V fetchSession(K key, long earliestSessionEndTime, long latestSessionStartTime) {
        Objects.requireNonNull(key, "key can't be null");
        List<ReadOnlySessionStore<K, V>> stores = this.storeProvider.stores(this.storeName, this.queryableStoreType);
        Iterator<ReadOnlySessionStore<K, V>> iterator = stores.iterator();
        if (iterator.hasNext()) {
            ReadOnlySessionStore<K, V> store = iterator.next();
            try {
                return store.fetchSession(key, earliestSessionEndTime, latestSessionStartTime);
            }
            catch (InvalidStateStoreException ise) {
                throw new InvalidStateStoreException("State store  [" + this.storeName + "] is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.", ise);
            }
        }
        return null;
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K key) {
        Objects.requireNonNull(key, "key can't be null");
        List<ReadOnlySessionStore<K, V>> stores = this.storeProvider.stores(this.storeName, this.queryableStoreType);
        for (ReadOnlySessionStore<K, V> store : stores) {
            try {
                KeyValueIterator<Windowed<K>, V> result = store.fetch(key);
                if (!result.hasNext()) {
                    result.close();
                    continue;
                }
                return result;
            }
            catch (InvalidStateStoreException ise) {
                throw new InvalidStateStoreException("State store  [" + this.storeName + "] is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata. Original error message: " + ise.toString());
            }
        }
        return KeyValueIterators.emptyIterator();
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardFetch(K key) {
        Objects.requireNonNull(key, "key can't be null");
        List<ReadOnlySessionStore<K, V>> stores = this.storeProvider.stores(this.storeName, this.queryableStoreType);
        for (ReadOnlySessionStore<K, V> store : stores) {
            try {
                KeyValueIterator<Windowed<K>, V> result = store.backwardFetch(key);
                if (!result.hasNext()) {
                    result.close();
                    continue;
                }
                return result;
            }
            catch (InvalidStateStoreException ise) {
                throw new InvalidStateStoreException("State store  [" + this.storeName + "] is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.", ise);
            }
        }
        return KeyValueIterators.emptyIterator();
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K keyFrom, K keyTo) {
        Objects.requireNonNull(keyFrom, "keyFrom can't be null");
        Objects.requireNonNull(keyTo, "keyTo can't be null");
        NextIteratorFunction nextIteratorFunction = store -> store.fetch(keyFrom, keyTo);
        return new DelegatingPeekingKeyValueIterator(this.storeName, new CompositeKeyValueIterator(this.storeProvider.stores(this.storeName, this.queryableStoreType).iterator(), nextIteratorFunction));
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardFetch(K keyFrom, K keyTo) {
        Objects.requireNonNull(keyFrom, "keyFrom can't be null");
        Objects.requireNonNull(keyTo, "keyTo can't be null");
        NextIteratorFunction nextIteratorFunction = store -> store.backwardFetch(keyFrom, keyTo);
        return new DelegatingPeekingKeyValueIterator(this.storeName, new CompositeKeyValueIterator(this.storeProvider.stores(this.storeName, this.queryableStoreType).iterator(), nextIteratorFunction));
    }
}

