/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableDeserializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.state.internals.KeyAndJoinSide;

public class KeyAndJoinSideDeserializer<K>
implements WrappingNullableDeserializer<KeyAndJoinSide<K>, K, Void> {
    private Deserializer<K> keyDeserializer;

    KeyAndJoinSideDeserializer(Deserializer<K> keyDeserializer) {
        this.keyDeserializer = keyDeserializer;
    }

    @Override
    public void setIfUnset(SerdeGetter getter) {
        if (this.keyDeserializer == null) {
            this.keyDeserializer = getter.keySerde().deserializer();
        }
        WrappingNullableUtils.initNullableDeserializer(this.keyDeserializer, getter);
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        this.keyDeserializer.configure(configs, isKey);
    }

    @Override
    public KeyAndJoinSide<K> deserialize(String topic, byte[] data) {
        boolean bool = data[0] == 1;
        K key = this.keyDeserializer.deserialize(topic, this.rawKey(data));
        return KeyAndJoinSide.make(bool, key);
    }

    private byte[] rawKey(byte[] data) {
        byte[] rawKey = new byte[data.length - 1];
        System.arraycopy(data, 1, rawKey, 0, rawKey.length);
        return rawKey;
    }

    @Override
    public void close() {
        this.keyDeserializer.close();
    }
}

