/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.state.internals.RocksDBStore;
import org.apache.kafka.streams.state.internals.Segment;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;

class KeyValueSegment
extends RocksDBStore
implements Comparable<KeyValueSegment>,
Segment {
    public final long id;

    KeyValueSegment(String segmentName, String windowName, long id, RocksDBMetricsRecorder metricsRecorder) {
        super(segmentName, windowName, metricsRecorder);
        this.id = id;
    }

    @Override
    public void destroy() throws IOException {
        Utils.delete(this.dbDir);
    }

    @Override
    public synchronized void deleteRange(Bytes keyFrom, Bytes keyTo) {
        super.deleteRange(keyFrom, keyTo);
    }

    @Override
    public int compareTo(KeyValueSegment segment) {
        return Long.compare(this.id, segment.id);
    }

    @Override
    public void openDB(Map<String, Object> configs, File stateDir) {
        super.openDB(configs, stateDir);
    }

    public String toString() {
        return "KeyValueSegment(id=" + this.id + ", name=" + this.name() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KeyValueSegment segment = (KeyValueSegment)obj;
        return this.id == segment.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

