/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.MeteredWindowStoreIterator;
import org.apache.kafka.streams.state.internals.MeteredWindowedKeyValueIterator;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.apache.kafka.streams.state.internals.metrics.StateStoreMetrics;

public class MeteredWindowStore<K, V>
extends WrappedStateStore<WindowStore<Bytes, byte[]>, Windowed<K>, V>
implements WindowStore<K, V> {
    private final long windowSizeMs;
    private final String metricsScope;
    private final Time time;
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private StateSerdes<K, V> serdes;
    private StreamsMetricsImpl streamsMetrics;
    private Sensor putSensor;
    private Sensor fetchSensor;
    private Sensor flushSensor;
    private Sensor e2eLatencySensor;
    private InternalProcessorContext context;
    private final String threadId;
    private String taskId;

    MeteredWindowStore(WindowStore<Bytes, byte[]> inner, long windowSizeMs, String metricsScope, Time time, Serde<K> keySerde, Serde<V> valueSerde) {
        super(inner);
        this.windowSizeMs = windowSizeMs;
        this.threadId = Thread.currentThread().getName();
        this.metricsScope = metricsScope;
        this.time = time;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    @Override
    @Deprecated
    public void init(ProcessorContext context, StateStore root) {
        this.context = context instanceof InternalProcessorContext ? (InternalProcessorContext)context : null;
        this.initStoreSerde(context);
        this.streamsMetrics = (StreamsMetricsImpl)context.metrics();
        this.taskId = context.taskId().toString();
        this.registerMetrics();
        Sensor restoreSensor = StateStoreMetrics.restoreSensor(this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
        StreamsMetricsImpl.maybeMeasureLatency(() -> super.init(context, root), this.time, restoreSensor);
    }

    @Override
    public void init(StateStoreContext context, StateStore root) {
        this.context = context instanceof InternalProcessorContext ? (InternalProcessorContext)context : null;
        this.initStoreSerde(context);
        this.streamsMetrics = (StreamsMetricsImpl)context.metrics();
        this.taskId = context.taskId().toString();
        this.registerMetrics();
        Sensor restoreSensor = StateStoreMetrics.restoreSensor(this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
        StreamsMetricsImpl.maybeMeasureLatency(() -> super.init(context, root), this.time, restoreSensor);
    }

    protected Serde<V> prepareValueSerde(Serde<V> valueSerde, SerdeGetter getter) {
        return WrappingNullableUtils.prepareValueSerde(valueSerde, getter);
    }

    private void registerMetrics() {
        this.putSensor = StateStoreMetrics.putSensor(this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
        this.fetchSensor = StateStoreMetrics.fetchSensor(this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
        this.flushSensor = StateStoreMetrics.flushSensor(this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
        this.e2eLatencySensor = StateStoreMetrics.e2ELatencySensor(this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
    }

    @Deprecated
    private void initStoreSerde(ProcessorContext context) {
        String storeName = this.name();
        String changelogTopic = ProcessorContextUtils.changelogFor(context, storeName);
        this.serdes = new StateSerdes<K, V>(changelogTopic != null ? changelogTopic : ProcessorStateManager.storeChangelogTopic(context.applicationId(), storeName), WrappingNullableUtils.prepareKeySerde(this.keySerde, new SerdeGetter(context)), this.prepareValueSerde(this.valueSerde, new SerdeGetter(context)));
    }

    private void initStoreSerde(StateStoreContext context) {
        String storeName = this.name();
        String changelogTopic = ProcessorContextUtils.changelogFor(context, storeName);
        this.serdes = new StateSerdes<K, V>(changelogTopic != null ? changelogTopic : ProcessorStateManager.storeChangelogTopic(context.applicationId(), storeName), WrappingNullableUtils.prepareKeySerde(this.keySerde, new SerdeGetter(context)), this.prepareValueSerde(this.valueSerde, new SerdeGetter(context)));
    }

    @Override
    public boolean setFlushListener(final CacheFlushListener<Windowed<K>, V> listener, boolean sendOldValues) {
        WindowStore wrapped = (WindowStore)this.wrapped();
        if (wrapped instanceof CachedStateStore) {
            return ((CachedStateStore)((Object)wrapped)).setFlushListener(new CacheFlushListener<byte[], byte[]>(){

                @Override
                public void apply(byte[] key, byte[] newValue, byte[] oldValue, long timestamp) {
                    listener.apply(WindowKeySchema.fromStoreKey(key, MeteredWindowStore.this.windowSizeMs, MeteredWindowStore.this.serdes.keyDeserializer(), MeteredWindowStore.this.serdes.topic()), newValue != null ? (Object)MeteredWindowStore.this.serdes.valueFrom(newValue) : null, oldValue != null ? (Object)MeteredWindowStore.this.serdes.valueFrom(oldValue) : null, timestamp);
                }

                @Override
                public void apply(Record<byte[], Change<byte[]>> record) {
                    listener.apply(record.withKey(WindowKeySchema.fromStoreKey(record.key(), MeteredWindowStore.this.windowSizeMs, MeteredWindowStore.this.serdes.keyDeserializer(), MeteredWindowStore.this.serdes.topic())).withValue(new Change<Object>((record.value().newValue != null ? (Object)MeteredWindowStore.this.serdes.valueFrom((byte[])record.value().newValue) : null), (record.value().oldValue != null ? (Object)MeteredWindowStore.this.serdes.valueFrom((byte[])record.value().oldValue) : null))));
                }
            }, sendOldValues);
        }
        return false;
    }

    @Override
    public void put(K key, V value, long windowStartTimestamp) {
        Objects.requireNonNull(key, "key cannot be null");
        try {
            StreamsMetricsImpl.maybeMeasureLatency(() -> ((WindowStore)this.wrapped()).put(this.keyBytes(key), this.serdes.rawValue(value), windowStartTimestamp), this.time, this.putSensor);
            this.maybeRecordE2ELatency();
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key, value);
            throw new ProcessorStateException(message, e);
        }
    }

    @Override
    public V fetch(K key, long timestamp) {
        Objects.requireNonNull(key, "key cannot be null");
        return (V)StreamsMetricsImpl.maybeMeasureLatency(() -> {
            byte[] result = (byte[])((WindowStore)this.wrapped()).fetch(this.keyBytes(key), timestamp);
            if (result == null) {
                return null;
            }
            return this.serdes.valueFrom(result);
        }, this.time, this.fetchSensor);
    }

    @Override
    public WindowStoreIterator<V> fetch(K key, long timeFrom, long timeTo) {
        Objects.requireNonNull(key, "key cannot be null");
        return new MeteredWindowStoreIterator<V>(((WindowStore)this.wrapped()).fetch(this.keyBytes(key), timeFrom, timeTo), this.fetchSensor, this.streamsMetrics, this.serdes, this.time);
    }

    @Override
    public WindowStoreIterator<V> backwardFetch(K key, long timeFrom, long timeTo) {
        Objects.requireNonNull(key, "key cannot be null");
        return new MeteredWindowStoreIterator<V>(((WindowStore)this.wrapped()).backwardFetch(this.keyBytes(key), timeFrom, timeTo), this.fetchSensor, this.streamsMetrics, this.serdes, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K keyFrom, K keyTo, long timeFrom, long timeTo) {
        Objects.requireNonNull(keyFrom, "keyFrom cannot be null");
        Objects.requireNonNull(keyTo, "keyTo cannot be null");
        return new MeteredWindowedKeyValueIterator<K, V>(((WindowStore)this.wrapped()).fetch(this.keyBytes(keyFrom), this.keyBytes(keyTo), timeFrom, timeTo), this.fetchSensor, this.streamsMetrics, this.serdes, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardFetch(K keyFrom, K keyTo, long timeFrom, long timeTo) {
        Objects.requireNonNull(keyFrom, "keyFrom cannot be null");
        Objects.requireNonNull(keyTo, "keyTo cannot be null");
        return new MeteredWindowedKeyValueIterator<K, V>(((WindowStore)this.wrapped()).backwardFetch(this.keyBytes(keyFrom), this.keyBytes(keyTo), timeFrom, timeTo), this.fetchSensor, this.streamsMetrics, this.serdes, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetchAll(long timeFrom, long timeTo) {
        return new MeteredWindowedKeyValueIterator<K, V>(((WindowStore)this.wrapped()).fetchAll(timeFrom, timeTo), this.fetchSensor, this.streamsMetrics, this.serdes, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardFetchAll(long timeFrom, long timeTo) {
        return new MeteredWindowedKeyValueIterator<K, V>(((WindowStore)this.wrapped()).backwardFetchAll(timeFrom, timeTo), this.fetchSensor, this.streamsMetrics, this.serdes, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> all() {
        return new MeteredWindowedKeyValueIterator<K, V>(((WindowStore)this.wrapped()).all(), this.fetchSensor, this.streamsMetrics, this.serdes, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardAll() {
        return new MeteredWindowedKeyValueIterator<K, V>(((WindowStore)this.wrapped()).backwardAll(), this.fetchSensor, this.streamsMetrics, this.serdes, this.time);
    }

    @Override
    public void flush() {
        StreamsMetricsImpl.maybeMeasureLatency(() -> super.flush(), this.time, this.flushSensor);
    }

    @Override
    public void close() {
        try {
            ((WindowStore)this.wrapped()).close();
        }
        finally {
            this.streamsMetrics.removeAllStoreLevelSensorsAndMetrics(this.taskId, this.name());
        }
    }

    private Bytes keyBytes(K key) {
        return Bytes.wrap(this.serdes.rawKey(key));
    }

    private void maybeRecordE2ELatency() {
        if (this.e2eLatencySensor.shouldRecord() && this.context != null) {
            long currentTime = this.time.milliseconds();
            long e2eLatency = currentTime - this.context.timestamp();
            this.e2eLatencySensor.record(e2eLatency, currentTime);
        }
    }
}

