/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.Segment;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.Segments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeOrderedKeySchema
implements SegmentedBytesStore.KeySchema {
    private static final Logger LOG = LoggerFactory.getLogger(TimeOrderedKeySchema.class);
    private static final int TIMESTAMP_SIZE = 8;
    private static final int SEQNUM_SIZE = 4;

    @Override
    public Bytes upperRange(Bytes key, long to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Bytes lowerRange(Bytes key, long from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Bytes toStoreBinaryKeyPrefix(Bytes key, long timestamp) {
        return TimeOrderedKeySchema.toStoreKeyBinaryPrefix(key, timestamp);
    }

    @Override
    public Bytes upperRangeFixedSize(Bytes key, long to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Bytes lowerRangeFixedSize(Bytes key, long from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long segmentTimestamp(Bytes key) {
        return TimeOrderedKeySchema.extractStoreTimestamp(key.get());
    }

    @Override
    public HasNextCondition hasNextCondition(Bytes binaryKeyFrom, Bytes binaryKeyTo, long from, long to) {
        if (binaryKeyFrom != null || binaryKeyTo != null) {
            throw new IllegalArgumentException("binaryKeyFrom/binaryKeyTo keys cannot be non-null. Key and time range queries are not supported.");
        }
        if (from != 0L && to != Long.MAX_VALUE) {
            throw new IllegalArgumentException("from/to time ranges should be 0 to Long.MAX_VALUE. Key and time range queries are not supported.");
        }
        return iterator -> iterator.hasNext();
    }

    @Override
    public <S extends Segment> List<S> segmentsToSearch(Segments<S> segments, long from, long to, boolean forward) {
        throw new UnsupportedOperationException();
    }

    public static Bytes toStoreKeyBinaryPrefix(Bytes key, long timestamp) {
        byte[] serializedKey = key.get();
        ByteBuffer buf = ByteBuffer.allocate(8 + serializedKey.length);
        buf.putLong(timestamp);
        buf.put(serializedKey);
        return Bytes.wrap(buf.array());
    }

    public static Bytes toStoreKeyBinary(Bytes key, long timestamp, int seqnum) {
        byte[] serializedKey = key.get();
        return TimeOrderedKeySchema.toStoreKeyBinary(serializedKey, timestamp, seqnum);
    }

    public static Bytes toStoreKeyBinary(Windowed<Bytes> timeKey, int seqnum) {
        byte[] bytes = timeKey.key().get();
        return TimeOrderedKeySchema.toStoreKeyBinary(bytes, timeKey.window().start(), seqnum);
    }

    public static <K> Bytes toStoreKeyBinary(Windowed<K> timeKey, int seqnum, StateSerdes<K, ?> serdes) {
        byte[] serializedKey = serdes.rawKey(timeKey.key());
        return TimeOrderedKeySchema.toStoreKeyBinary(serializedKey, timeKey.window().start(), seqnum);
    }

    static Bytes toStoreKeyBinary(byte[] serializedKey, long timestamp, int seqnum) {
        ByteBuffer buf = ByteBuffer.allocate(8 + serializedKey.length + 4);
        buf.putLong(timestamp);
        buf.put(serializedKey);
        buf.putInt(seqnum);
        return Bytes.wrap(buf.array());
    }

    static byte[] extractStoreKeyBytes(byte[] binaryKey) {
        byte[] bytes = new byte[binaryKey.length - 8 - 4];
        System.arraycopy(binaryKey, 8, bytes, 0, bytes.length);
        return bytes;
    }

    static long extractStoreTimestamp(byte[] binaryKey) {
        return ByteBuffer.wrap(binaryKey).getLong(0);
    }

    static int extractStoreSequence(byte[] binaryKey) {
        return ByteBuffer.wrap(binaryKey).getInt(binaryKey.length - 4);
    }

    static <K> Windowed<K> fromStoreKey(byte[] binaryKey, long windowSize, Deserializer<K> deserializer, String topic) {
        K key = deserializer.deserialize(topic, TimeOrderedKeySchema.extractStoreKeyBytes(binaryKey));
        Window window = TimeOrderedKeySchema.extractStoreWindow(binaryKey, windowSize);
        return new Windowed<K>(key, window);
    }

    static Windowed<Bytes> fromStoreBytesKey(byte[] binaryKey, long windowSize) {
        Bytes key = Bytes.wrap(TimeOrderedKeySchema.extractStoreKeyBytes(binaryKey));
        Window window = TimeOrderedKeySchema.extractStoreWindow(binaryKey, windowSize);
        return new Windowed<Bytes>(key, window);
    }

    static Window extractStoreWindow(byte[] binaryKey, long windowSize) {
        ByteBuffer buffer = ByteBuffer.wrap(binaryKey);
        long start = buffer.getLong(0);
        return TimeOrderedKeySchema.timeWindowForSize(start, windowSize);
    }

    private static TimeWindow timeWindowForSize(long startMs, long windowSize) {
        long endMs = startMs + windowSize;
        if (endMs < 0L) {
            LOG.warn("Warning: window end time was truncated to Long.MAX");
            endMs = Long.MAX_VALUE;
        }
        return new TimeWindow(startMs, endMs);
    }
}

