/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.mongo.Cmp;
import net.pincette.mongo.Expression;
import net.pincette.mongo.Features;
import net.pincette.mongo.Implementation;
import net.pincette.mongo.Match;
import net.pincette.mongo.Util;
import net.pincette.util.Collections;
import net.pincette.util.Pair;
import net.pincette.util.StreamUtil;

class Arrays {
    private static final String AS = "as";
    private static final String ASC = "asc";
    private static final String COND = "cond";
    private static final String DESC = "desc";
    private static final String DIRECTION = "direction";
    private static final String IN = "in";
    private static final String INITIAL_VALUE = "initialValue";
    private static final String INPUT = "input";
    private static final String PATHS = "paths";
    private static final String THIS = "this";
    private static final String VALUE = "$$value";

    private Arrays() {
    }

    static Implementation arrayElemAt(JsonValue value, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementationsNum(implementations, json, vars, 2).filter(values -> JsonUtil.isArray((JsonValue)((JsonValue)values.get(0))) && JsonUtil.isInt((JsonValue)((JsonValue)values.get(1))) && Arrays.withinRange(JsonUtil.asArray((JsonValue)((JsonValue)values.get(0))), JsonUtil.asInt((JsonValue)((JsonValue)values.get(1))))).map(values -> Arrays.arrayElemAt(JsonUtil.asArray((JsonValue)((JsonValue)values.get(0))), JsonUtil.asInt((JsonValue)((JsonValue)values.get(1))))).orElse(JsonValue.NULL);
    }

    private static JsonValue arrayElemAt(JsonArray array, int index) {
        return (JsonValue)array.get(index >= 0 ? index : array.size() + index);
    }

    static Implementation arrayToObject(JsonValue value, Features features) {
        Implementation implementation = Expression.implementation(value, features);
        return (json, vars) -> Optional.of((JsonValue)implementation.apply(json, vars)).filter(JsonUtil::isArray).map(JsonValue::asJsonArray).filter(array -> array.stream().allMatch(v -> Arrays.isKV(v) || Arrays.isObjectArray(v))).map(Arrays::arrayToObject).orElse(JsonValue.NULL);
    }

    private static JsonValue arrayToObject(JsonArray array) {
        return array.stream().reduce(JsonUtil.createObjectBuilder(), (b, v) -> Optional.of(v).filter(Arrays::isKV).map(JsonValue::asJsonObject).map(o -> b.add(o.getString("k"), o.getValue("/v"))).orElseGet(() -> Optional.of(v).map(JsonValue::asJsonArray).map(a -> b.add(Expression.getString((List<JsonValue>)a, 0), (JsonValue)a.get(1))).orElse((JsonObjectBuilder)b)), (b1, b2) -> b1).build();
    }

    private static int compare(JsonValue v1, JsonValue v2, List<String> paths) {
        BiFunction<JsonValue, String, JsonValue> value = (v, p) -> JsonUtil.getValue((JsonStructure)v.asJsonObject(), (String)JsonUtil.toJsonPointer((String)p)).orElse(JsonValue.NULL);
        return paths.stream().map(path -> Cmp.compare((JsonValue)value.apply(v1, (String)path), (JsonValue)value.apply(v2, (String)path))).filter(result -> result != 0).findFirst().orElse(0);
    }

    static Implementation concatArrays(JsonValue value, Features features) {
        return Expression.arraysOperator(value, Arrays::concatArrays, features);
    }

    private static JsonValue concatArrays(List<JsonArray> array) {
        return Util.toArray(array.stream().flatMap(Collection::stream));
    }

    static Implementation elemMatch(JsonValue value, Features features) {
        Implementation implementation = Arrays.isElemMatch(value) ? Expression.implementation((JsonValue)value.asJsonArray().get(0), features) : null;
        Map<String, Implementation> conditions = Arrays.elemMatchConditions(((JsonValue)value.asJsonArray().get(1)).asJsonObject(), features);
        return (json, vars) -> implementation != null && conditions != null ? Optional.of((JsonValue)implementation.apply(json, vars)).filter(JsonUtil::isArray).map(JsonValue::asJsonArray).flatMap(array -> Optional.of(Arrays.elemMatchPredicate(json, vars, conditions, features)).flatMap(predicate -> array.stream().filter(predicate).findFirst())).orElse(JsonValue.NULL) : JsonValue.NULL;
    }

    private static Map<String, Implementation> elemMatchConditions(JsonObject expression, Features features) {
        return expression.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Expression.implementation((JsonValue)e.getValue(), features)));
    }

    private static Predicate<JsonValue> elemMatchPredicate(JsonObject json, Map<String, JsonValue> variables, Map<String, Implementation> conditions, Features features) {
        return Match.elemMatchPredicate((JsonValue)conditions.entrySet().stream().reduce(JsonUtil.createObjectBuilder(), (b, e) -> b.add((String)e.getKey(), (JsonValue)((Implementation)e.getValue()).apply(json, variables)), (b1, b2) -> b1).build(), features);
    }

    static Implementation filter(JsonValue value, Features features) {
        return Arrays.mapper(value, (array, values) -> Util.toArray(StreamUtil.zip((Stream)array.stream(), values.stream()).filter(pair -> !Expression.isFalse((JsonValue)pair.second)).map(pair -> (JsonValue)pair.first)), features);
    }

    static Implementation first(JsonValue value, Features features) {
        return Arrays.arrayElemAt((JsonValue)JsonUtil.createArrayBuilder().add(value).add(0).build(), features);
    }

    static Implementation in(JsonValue value, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementationsNum(implementations, json, vars, 2).filter(values -> JsonUtil.isArray((JsonValue)((JsonValue)values.get(1)))).map(values -> ((JsonValue)values.get(1)).asJsonArray().contains(values.get(0))).map(JsonUtil::createValue).orElse(JsonValue.NULL);
    }

    static Implementation indexOfArray(JsonValue value, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementations(implementations, json, vars, fncs -> fncs.size() >= 2 && fncs.size() <= 4).filter(values -> !(!JsonUtil.isArray((JsonValue)((JsonValue)values.get(0))) || values.size() >= 3 && !JsonUtil.isNumber((JsonValue)((JsonValue)values.get(2))) || values.size() >= 4 && !JsonUtil.isNumber((JsonValue)((JsonValue)values.get(3))))).map(values -> Arrays.indexOfArray(((JsonValue)values.get(0)).asJsonArray(), (JsonValue)values.get(1), values.size() < 3 ? 0 : JsonUtil.asInt((JsonValue)((JsonValue)values.get(2))), values.size() < 4 ? values.size() - 1 : JsonUtil.asInt((JsonValue)((JsonValue)values.get(3))))).orElse(JsonValue.NULL);
    }

    private static JsonValue indexOfArray(JsonArray array, JsonValue value, int start, int end) {
        return StreamUtil.zip((Stream)array.stream(), (Stream)StreamUtil.rangeInclusive((int)0, (int)end)).filter(pair -> (Integer)pair.second >= start && ((JsonValue)pair.first).equals((Object)value)).findFirst().map(pair -> JsonUtil.createValue((Object)pair.second)).orElseGet(() -> JsonUtil.createValue((Object)-1));
    }

    static Implementation isArray(JsonValue value, Features features) {
        Implementation implementation = Expression.implementation(value, features);
        return (json, vars) -> Optional.of((JsonValue)implementation.apply(json, vars)).filter(JsonUtil::isArray).map(a -> JsonValue.TRUE).orElse(JsonValue.FALSE);
    }

    private static boolean isElemMatch(JsonValue value) {
        return JsonUtil.isArray((JsonValue)value) && value.asJsonArray().size() == 2 && JsonUtil.isObject((JsonValue)((JsonValue)value.asJsonArray().get(1)));
    }

    private static boolean isKV(JsonValue value) {
        return Optional.of(value).filter(JsonUtil::isObject).map(JsonValue::asJsonObject).filter(json -> json.keySet().size() == 2 && json.containsKey((Object)"k") && json.containsKey((Object)"v")).isPresent();
    }

    private static boolean isObjectArray(JsonValue value) {
        return Optional.of(value).filter(JsonUtil::isArray).map(JsonValue::asJsonArray).filter(a -> a.size() == 2 && JsonUtil.isString((JsonValue)((JsonValue)a.get(0)))).isPresent();
    }

    static Implementation last(JsonValue value, Features features) {
        return Arrays.arrayElemAt((JsonValue)JsonUtil.createArrayBuilder().add(value).add(-1).build(), features);
    }

    static Implementation mapOp(JsonValue value, Features features) {
        return Arrays.mapper(value, (array, values) -> Util.toArray(values.stream()), features);
    }

    private static Implementation mapper(JsonValue value, BiFunction<JsonArray, List<JsonValue>, JsonValue> combine, Features features) {
        JsonValue in = Expression.member(value, IN, v -> v).orElseGet(() -> Expression.member(value, COND, v -> v).orElse(null));
        Implementation input = Expression.memberFunction(value, INPUT, features);
        String variable = Expression.member(value, AS, v -> JsonUtil.asString((JsonValue)v).getString()).orElse(THIS);
        return (json, vars) -> input != null && in != null ? Optional.of((JsonValue)input.apply(json, vars)).filter(JsonUtil::isArray).map(JsonValue::asJsonArray).map(array -> (JsonValue)combine.apply((JsonArray)array, Arrays.mapper(array, "$$" + variable, in, features).stream().map(i -> (JsonValue)i.apply(json, vars)).collect(Collectors.toList()))).orElse(JsonValue.NULL) : JsonValue.NULL;
    }

    private static List<Implementation> mapper(JsonArray values, String variable, JsonValue expression, Features features) {
        return values.stream().map(v -> Expression.implementation(Expression.replaceVariables(expression, (Map<String, JsonValue>)Collections.map((Pair[])new Pair[]{Pair.pair((Object)variable, (Object)v)})), features)).collect(Collectors.toList());
    }

    static Implementation objectToArray(JsonValue value, Features features) {
        Implementation implementation = Expression.implementation(value, features);
        return (json, vars) -> Optional.of((JsonValue)implementation.apply(json, vars)).filter(JsonUtil::isObject).map(JsonValue::asJsonObject).map(Arrays::objectToArray).orElse(JsonValue.NULL);
    }

    private static JsonValue objectToArray(JsonObject json) {
        return json.entrySet().stream().reduce(JsonUtil.createArrayBuilder(), (b, e) -> b.add(JsonUtil.createObjectBuilder().add("k", (String)e.getKey()).add("v", (JsonValue)e.getValue())), (b1, b2) -> b1).build();
    }

    static Implementation range(JsonValue value, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementations(implementations, json, vars, fncs -> fncs.size() == 2 || fncs.size() == 3).filter(values -> JsonUtil.isInt((JsonValue)((JsonValue)values.get(0))) && JsonUtil.isInt((JsonValue)((JsonValue)values.get(1))) && (values.size() < 3 || JsonUtil.isInt((JsonValue)((JsonValue)values.get(2))))).map(Arrays::range).orElse(JsonValue.NULL);
    }

    private static JsonValue range(List<JsonValue> values) {
        int start = JsonUtil.asInt((JsonValue)values.get(0));
        int end = JsonUtil.asInt((JsonValue)values.get(1));
        int step = values.size() == 3 ? JsonUtil.asInt((JsonValue)values.get(2)) : 1;
        return start <= end && step < 0 || start >= end && step > 0 ? JsonUtil.emptyArray() : JsonUtil.createValue((Object)StreamUtil.rangeExclusive((int)start, (int)end, (int)Math.abs(step)));
    }

    static Implementation reduce(JsonValue value, Features features) {
        JsonValue in = Expression.member(value, IN, v -> v).orElse(null);
        Implementation initial = Expression.memberFunction(value, INITIAL_VALUE, features);
        Implementation input = Expression.memberFunction(value, INPUT, features);
        return (json, vars) -> input != null && initial != null && in != null ? Optional.of((JsonValue)input.apply(json, vars)).filter(JsonUtil::isArray).map(JsonValue::asJsonArray).map(array -> array.stream().reduce((JsonValue)initial.apply(json, vars), (result, v) -> (JsonValue)Arrays.reduce(in, result, v, features).apply(json, vars), (r1, r2) -> r1)).orElse(JsonValue.NULL) : JsonValue.NULL;
    }

    private static Implementation reduce(JsonValue expression, JsonValue result, JsonValue value, Features features) {
        return Expression.implementation(Expression.replaceVariables(Expression.replaceVariables(expression, (Map<String, JsonValue>)Collections.map((Pair[])new Pair[]{Pair.pair((Object)"$$this", (Object)value)})), (Map<String, JsonValue>)Collections.map((Pair[])new Pair[]{Pair.pair((Object)VALUE, (Object)result)})), features);
    }

    static Implementation reverseArray(JsonValue value, Features features) {
        Implementation implementation = Expression.implementation(value, features);
        return (json, vars) -> Optional.of((JsonValue)implementation.apply(json, vars)).filter(JsonUtil::isArray).map(JsonValue::asJsonArray).map(array -> Util.toArray(StreamUtil.stream((Iterator)Collections.reverse((List)array)))).orElse(JsonValue.NULL);
    }

    static Implementation size(JsonValue value, Features features) {
        Implementation implementation = Expression.implementation(value, features);
        return (json, vars) -> Optional.of((JsonValue)implementation.apply(json, vars)).filter(JsonUtil::isArray).map(JsonValue::asJsonArray).map(List::size).map(JsonUtil::createValue).orElse(JsonValue.NULL);
    }

    static Implementation slice(JsonValue value, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementations(implementations, json, vars, fncs -> fncs.size() == 2 || fncs.size() == 3).filter(values -> JsonUtil.isArray((JsonValue)((JsonValue)values.get(0))) && JsonUtil.isInt((JsonValue)((JsonValue)values.get(1))) && (values.size() < 3 || JsonUtil.isInt((JsonValue)((JsonValue)values.get(2))) && JsonUtil.asInt((JsonValue)((JsonValue)values.get(2))) >= 0)).map(values -> Arrays.slice(((JsonValue)values.get(0)).asJsonArray(), Arrays.slicePosition(values), Math.abs(JsonUtil.asInt((JsonValue)((JsonValue)values.get(values.size() - 1)))))).orElse(JsonValue.NULL);
    }

    private static JsonValue slice(JsonArray array, int position, int n) {
        return Util.toArray(StreamUtil.zip((Stream)array.stream(), (Stream)StreamUtil.rangeExclusive((int)0, (int)array.size())).filter(pair -> (Integer)pair.second >= position && (Integer)pair.second < position + n).map(pair -> (JsonValue)pair.first));
    }

    private static int slicePosition(List<JsonValue> values) {
        int n = JsonUtil.asInt((JsonValue)values.get(values.size() - 1));
        IntSupplier defaultPosition = () -> n >= 0 ? 0 : Integer.max(0, JsonUtil.asArray((JsonValue)((JsonValue)values.get(0))).size() + n);
        IntSupplier setPosition = () -> Optional.of(JsonUtil.asInt((JsonValue)((JsonValue)values.get(1)))).filter(p -> p >= 0).orElseGet(() -> Integer.max(0, JsonUtil.asArray((JsonValue)((JsonValue)values.get(0))).size() + JsonUtil.asInt((JsonValue)((JsonValue)values.get(1)))));
        return values.size() == 2 ? defaultPosition.getAsInt() : setPosition.getAsInt();
    }

    static Implementation sort(JsonValue value, Features features) {
        Optional<JsonObject> object = Optional.of(value).filter(JsonUtil::isObject).map(JsonValue::asJsonObject);
        String direction = object.map(json -> json.getString(DIRECTION, null)).filter(dir -> dir.equals(ASC) || dir.equals(DESC)).orElse(ASC);
        List paths = object.map(json -> JsonUtil.getStrings((JsonObject)json, (String)PATHS).collect(Collectors.toList())).orElse(null);
        Implementation input = Expression.memberFunction(value, INPUT, features);
        return (json, vars) -> input != null ? Optional.of((JsonValue)input.apply(json, vars)).filter(JsonUtil::isArray).map(JsonValue::asJsonArray).map(array -> Arrays.sort(array, paths, direction)).orElse(JsonValue.NULL) : JsonValue.NULL;
    }

    private static JsonValue sort(JsonArray array, List<String> paths, String direction) {
        return array.stream().filter(v -> paths == null || paths.isEmpty() || JsonUtil.isObject((JsonValue)v)).sorted((v1, v2) -> (paths != null && !paths.isEmpty() ? Arrays.compare(v1, v2, paths) : Cmp.compare(v1, v2)) * (direction.equals(ASC) ? 1 : -1)).reduce(JsonUtil.createArrayBuilder(), JsonArrayBuilder::add, (b1, b2) -> b1).build();
    }

    private static boolean withinRange(JsonArray array, int index) {
        return index >= 0 && index < array.size() || index < 0 && array.size() + index >= 0;
    }
}

