/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.util.Util;
import org.bson.BsonArray;
import org.bson.BsonBinaryWriter;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonNumber;
import org.bson.BsonObjectId;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.conversions.Bson;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.bson.types.ObjectId;

public class BsonUtil {
    private static final String ID = "_id";

    private BsonUtil() {
    }

    public static JsonValue fromBson(BsonValue bson) {
        switch (bson.getBsonType()) {
            case ARRAY: {
                return BsonUtil.fromBson(bson.asArray());
            }
            case BOOLEAN: {
                return bson.asBoolean().getValue() ? JsonValue.TRUE : JsonValue.FALSE;
            }
            case DATE_TIME: {
                return BsonUtil.fromBson(bson.asDateTime());
            }
            case DOCUMENT: {
                return BsonUtil.fromBson(bson.asDocument());
            }
            case DOUBLE: {
                return BsonUtil.fromBson(bson.asDouble());
            }
            case INT32: {
                return BsonUtil.fromBson(bson.asInt32());
            }
            case INT64: {
                return BsonUtil.fromBson(bson.asInt64());
            }
            case NULL: {
                return JsonValue.NULL;
            }
            case OBJECT_ID: {
                return BsonUtil.fromBson(bson.asObjectId());
            }
            case REGULAR_EXPRESSION: {
                return BsonUtil.fromBson(bson.asRegularExpression());
            }
            case STRING: {
                return BsonUtil.fromBson(bson.asString());
            }
            case TIMESTAMP: {
                return BsonUtil.fromBson(bson.asTimestamp());
            }
        }
        return null;
    }

    public static JsonArray fromBson(BsonArray array) {
        return array.stream().map(BsonUtil::fromBson).reduce(JsonUtil.createArrayBuilder(), JsonArrayBuilder::add, (b1, b2) -> b1).build();
    }

    public static JsonObject fromBson(BsonDocument bson) {
        return bson.entrySet().stream().reduce(JsonUtil.createObjectBuilder(), (b, e) -> b.add((String)e.getKey(), BsonUtil.fromBson((BsonValue)e.getValue())), (b1, b2) -> b1).build();
    }

    public static JsonNumber fromBson(BsonInt32 bson) {
        return JsonUtil.asNumber((JsonValue)JsonUtil.createValue((Object)bson.getValue()));
    }

    public static JsonNumber fromBson(BsonInt64 bson) {
        return JsonUtil.asNumber((JsonValue)JsonUtil.createValue((Object)bson.getValue()));
    }

    public static JsonNumber fromBson(BsonDouble bson) {
        return JsonUtil.asNumber((JsonValue)JsonUtil.createValue((Object)bson.getValue()));
    }

    public static JsonString fromBson(BsonDateTime bson) {
        return JsonUtil.asString((JsonValue)JsonUtil.createValue((Object)Instant.ofEpochMilli(bson.getValue()).toString()));
    }

    public static JsonString fromBson(BsonObjectId bson) {
        return JsonUtil.asString((JsonValue)JsonUtil.createValue((Object)bson.getValue().toHexString()));
    }

    public static JsonObject fromBson(BsonRegularExpression bson) {
        return JsonUtil.createObjectBuilder().add("$regex", bson.getPattern()).add("$options", bson.getOptions()).build();
    }

    public static JsonString fromBson(BsonString bson) {
        return JsonUtil.asString((JsonValue)JsonUtil.createValue((Object)bson.getValue()));
    }

    public static JsonString fromBson(BsonTimestamp bson) {
        return JsonUtil.asString((JsonValue)JsonUtil.createValue((Object)Instant.ofEpochSecond(bson.getTime()).toString()));
    }

    public static BsonValue fromJson(JsonValue json) {
        return BsonUtil.fromJson(json, false);
    }

    private static BsonValue fromJson(JsonValue json, boolean asTimestamp) {
        switch (json.getValueType()) {
            case ARRAY: {
                return BsonUtil.fromJson(json.asJsonArray(), asTimestamp);
            }
            case FALSE: {
                return BsonBoolean.FALSE;
            }
            case NULL: {
                return BsonNull.VALUE;
            }
            case NUMBER: {
                return BsonUtil.fromJson(JsonUtil.asNumber((JsonValue)json));
            }
            case OBJECT: {
                return BsonUtil.fromJson(json.asJsonObject(), asTimestamp);
            }
            case STRING: {
                return asTimestamp ? BsonUtil.fromJsonNew(JsonUtil.asString((JsonValue)json)) : BsonUtil.fromJson(JsonUtil.asString((JsonValue)json));
            }
            case TRUE: {
                return BsonBoolean.TRUE;
            }
        }
        return null;
    }

    public static BsonArray fromJson(JsonArray array) {
        return BsonUtil.fromJson(array, false);
    }

    private static BsonArray fromJson(JsonArray array, boolean asTimestamp) {
        return new BsonArray(array.stream().map(v -> BsonUtil.fromJson(v, asTimestamp)).collect(Collectors.toList()));
    }

    public static BsonDocument fromJson(JsonObject json) {
        return BsonUtil.fromJson(json, false);
    }

    private static BsonDocument fromJson(JsonObject json, boolean asTimestamp) {
        return json.entrySet().stream().reduce(new BsonDocument(), (d, e) -> d.append((String)e.getKey(), BsonUtil.isObjectId((String)e.getKey(), (JsonValue)e.getValue()) ? BsonUtil.fromJsonObjectId((JsonValue)e.getValue()) : BsonUtil.fromJson((JsonValue)e.getValue(), asTimestamp)), (d1, d2) -> d1);
    }

    public static BsonNumber fromJson(JsonNumber json) {
        return json.isIntegral() ? new BsonInt64(json.longValue()) : new BsonDouble(json.doubleValue());
    }

    public static BsonString fromJson(JsonString json) {
        return new BsonString(json.getString());
    }

    public static BsonArray fromJsonNew(JsonArray array) {
        return BsonUtil.fromJson(array, true);
    }

    public static BsonDocument fromJsonNew(JsonObject json) {
        return BsonUtil.fromJson(json, true);
    }

    public static BsonValue fromJsonNew(JsonValue json) {
        return BsonUtil.fromJson(json, true);
    }

    public static BsonValue fromJsonNew(JsonString json) {
        return Optional.of(json.getString()).flatMap(s -> Util.tryToGetSilent(() -> Instant.parse(s))).map(Instant::toEpochMilli).map(BsonDateTime::new).map(BsonValue.class::cast).orElseGet(() -> new BsonString(json.getString()));
    }

    private static BsonValue fromJsonObjectId(JsonValue json) {
        return new BsonObjectId(new ObjectId(JsonUtil.string((JsonValue)json)));
    }

    private static boolean isHex(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (BsonUtil.isHex(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean isObjectId(String key, JsonValue value) {
        return key.equals(ID) && JsonUtil.stringValue((JsonValue)value).filter(s -> s.length() == 24).filter(BsonUtil::isHex).isPresent();
    }

    public static BsonDocument toBsonDocument(Bson bson) {
        return bson.toBsonDocument();
    }

    public static byte[] toBytes(BsonDocument document) {
        BasicOutputBuffer out = new BasicOutputBuffer();
        new BsonDocumentCodec().encode((BsonWriter)new BsonBinaryWriter((BsonOutput)out), document, EncoderContext.builder().build());
        return out.toByteArray();
    }

    public static Document toDocument(BsonDocument document) {
        return new Document(document.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }
}

