/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonPatch;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.mongo.BsonUtil;
import net.pincette.mongo.Collection;
import net.pincette.mongo.Patch;
import net.pincette.rs.Chain;
import net.pincette.rs.Util;
import net.pincette.util.Collections;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class JsonClient {
    private static final List<Bson> COLLECTION_CHANGES = Collections.list((Object[])new Bson[]{Aggregates.match((Bson)Filters.in((String)"operationType", (Iterable)Collections.list((Object[])new String[]{"insert", "replace", "update"})))});
    private static final String ID = "_id";

    private JsonClient() {
    }

    public static CompletionStage<List<JsonObject>> aggregate(MongoCollection<Document> collection, List<? extends Bson> pipeline) {
        return JsonClient.aggregate(collection, pipeline, null);
    }

    public static CompletionStage<List<JsonObject>> aggregate(MongoCollection<Document> collection, JsonArray pipeline) {
        return JsonClient.aggregate(collection, JsonClient.fromJsonArray(pipeline), null);
    }

    public static CompletionStage<List<JsonObject>> aggregate(MongoCollection<Document> collection, ClientSession session, List<? extends Bson> pipeline) {
        return JsonClient.aggregate(collection, session, pipeline, null);
    }

    public static CompletionStage<List<JsonObject>> aggregate(MongoCollection<Document> collection, ClientSession session, JsonArray pipeline) {
        return JsonClient.aggregate(collection, session, JsonClient.fromJsonArray(pipeline), null);
    }

    public static CompletionStage<List<JsonObject>> aggregate(MongoCollection<Document> collection, List<? extends Bson> pipeline, UnaryOperator<AggregatePublisher<BsonDocument>> setParameters) {
        return Collection.aggregate(collection, pipeline, BsonDocument.class, setParameters).thenApply(JsonClient::toJson);
    }

    public static CompletionStage<List<JsonObject>> aggregate(MongoCollection<Document> collection, JsonArray pipeline, UnaryOperator<AggregatePublisher<BsonDocument>> setParameters) {
        return JsonClient.aggregate(collection, JsonClient.fromJsonArray(pipeline), setParameters);
    }

    public static CompletionStage<List<JsonObject>> aggregate(MongoCollection<Document> collection, ClientSession session, List<? extends Bson> pipeline, UnaryOperator<AggregatePublisher<BsonDocument>> setParameters) {
        return Collection.aggregate(collection, session, pipeline, BsonDocument.class, setParameters).thenApply(JsonClient::toJson);
    }

    public static CompletionStage<List<JsonObject>> aggregate(MongoCollection<Document> collection, ClientSession session, JsonArray pipeline, UnaryOperator<AggregatePublisher<BsonDocument>> setParameters) {
        return JsonClient.aggregate(collection, session, JsonClient.fromJsonArray(pipeline), setParameters);
    }

    public static Flow.Publisher<JsonObject> aggregationPublisher(MongoCollection<Document> collection, List<? extends Bson> pipeline) {
        return JsonClient.aggregationPublisher(collection, pipeline, null);
    }

    public static Flow.Publisher<JsonObject> aggregationPublisher(MongoCollection<Document> collection, JsonArray pipeline) {
        return JsonClient.aggregationPublisher(collection, JsonClient.fromJsonArray(pipeline), null);
    }

    public static Flow.Publisher<JsonObject> aggregationPublisher(MongoCollection<Document> collection, List<? extends Bson> pipeline, UnaryOperator<AggregatePublisher<BsonDocument>> setParameters) {
        return JsonClient.aggregationPublisher(() -> collection.aggregate(pipeline, BsonDocument.class), setParameters);
    }

    public static Flow.Publisher<JsonObject> aggregationPublisher(MongoCollection<Document> collection, JsonArray pipeline, UnaryOperator<AggregatePublisher<BsonDocument>> setParameters) {
        return JsonClient.aggregationPublisher(collection, JsonClient.fromJsonArray(pipeline), setParameters);
    }

    public static Flow.Publisher<JsonObject> aggregationPublisher(MongoCollection<Document> collection, ClientSession session, List<? extends Bson> pipeline, UnaryOperator<AggregatePublisher<BsonDocument>> setParameters) {
        return JsonClient.aggregationPublisher(() -> collection.aggregate(session, pipeline, BsonDocument.class), setParameters);
    }

    public static Flow.Publisher<JsonObject> aggregationPublisher(MongoCollection<Document> collection, ClientSession session, JsonArray pipeline, UnaryOperator<AggregatePublisher<BsonDocument>> setParameters) {
        return JsonClient.aggregationPublisher(collection, session, JsonClient.fromJsonArray(pipeline), setParameters);
    }

    private static Flow.Publisher<JsonObject> aggregationPublisher(Supplier<AggregatePublisher<BsonDocument>> operation, UnaryOperator<AggregatePublisher<BsonDocument>> setParameters) {
        return Optional.of(operation.get()).map(a -> setParameters != null ? (AggregatePublisher)setParameters.apply((AggregatePublisher<BsonDocument>)a) : a).map(FlowAdapters::toFlowPublisher).map(JsonClient::toJson).orElseGet(Util::empty);
    }

    private static JsonObject changedDocument(ChangeStreamDocument<Document> change) {
        return Optional.ofNullable((Document)change.getFullDocument()).map(doc -> BsonUtil.fromBson(BsonUtil.toBsonDocument((Bson)change.getFullDocument()))).orElse(null);
    }

    public static CompletionStage<List<JsonObject>> find(MongoCollection<Document> collection) {
        return JsonClient.find(collection, (Bson)null, null);
    }

    public static CompletionStage<List<JsonObject>> find(MongoCollection<Document> collection, Bson filter) {
        return JsonClient.find(collection, filter, null);
    }

    public static CompletionStage<List<JsonObject>> find(MongoCollection<Document> collection, JsonObject filter) {
        return JsonClient.find(collection, (Bson)(filter != null ? BsonUtil.fromJson(filter) : null), null);
    }

    public static CompletionStage<List<JsonObject>> find(MongoCollection<Document> collection, ClientSession session) {
        return JsonClient.find(collection, session, (Bson)null, null);
    }

    public static CompletionStage<List<JsonObject>> find(MongoCollection<Document> collection, ClientSession session, Bson filter) {
        return JsonClient.find(collection, session, filter, null);
    }

    public static CompletionStage<List<JsonObject>> find(MongoCollection<Document> collection, ClientSession session, JsonObject filter) {
        return JsonClient.find(collection, session, (Bson)(filter != null ? BsonUtil.fromJson(filter) : null), null);
    }

    public static CompletionStage<List<JsonObject>> find(MongoCollection<Document> collection, UnaryOperator<FindPublisher<BsonDocument>> setParameters) {
        return JsonClient.find(collection, (Bson)null, setParameters);
    }

    public static CompletionStage<List<JsonObject>> find(MongoCollection<Document> collection, Bson filter, UnaryOperator<FindPublisher<BsonDocument>> setParameters) {
        return (filter != null ? Collection.find(collection, filter, BsonDocument.class, setParameters) : Collection.find(collection, BsonDocument.class, setParameters)).thenApply(JsonClient::toJson);
    }

    public static CompletionStage<List<JsonObject>> find(MongoCollection<Document> collection, JsonObject filter, UnaryOperator<FindPublisher<BsonDocument>> setParameters) {
        return JsonClient.find(collection, (Bson)(filter != null ? BsonUtil.fromJson(filter) : null), setParameters);
    }

    public static CompletionStage<List<JsonObject>> find(MongoCollection<Document> collection, ClientSession session, Bson filter, UnaryOperator<FindPublisher<BsonDocument>> setParameters) {
        return (filter != null ? Collection.find(collection, session, filter, BsonDocument.class, setParameters) : Collection.find(collection, session, BsonDocument.class, setParameters)).thenApply(JsonClient::toJson);
    }

    public static CompletionStage<List<JsonObject>> find(MongoCollection<Document> collection, ClientSession session, JsonObject filter, UnaryOperator<FindPublisher<BsonDocument>> setParameters) {
        return JsonClient.find(collection, session, (Bson)(filter != null ? BsonUtil.fromJson(filter) : null), setParameters);
    }

    public static Flow.Publisher<JsonObject> findPublisher(MongoCollection<Document> collection) {
        return JsonClient.findPublisher(collection, (Bson)null, null);
    }

    public static Flow.Publisher<JsonObject> findPublisher(MongoCollection<Document> collection, Bson filter) {
        return JsonClient.findPublisher(collection, filter, null);
    }

    public static Flow.Publisher<JsonObject> findPublisher(MongoCollection<Document> collection, JsonObject filter) {
        return JsonClient.findPublisher(collection, (Bson)(filter != null ? BsonUtil.fromJson(filter) : null), null);
    }

    public static Flow.Publisher<JsonObject> findPublisher(MongoCollection<Document> collection, ClientSession session, UnaryOperator<FindPublisher<BsonDocument>> setParameters) {
        return JsonClient.findPublisher(collection, session, (Bson)null, setParameters);
    }

    public static Flow.Publisher<JsonObject> findPublisher(MongoCollection<Document> collection, ClientSession session) {
        return JsonClient.findPublisher(collection, session, (Bson)null, null);
    }

    public static Flow.Publisher<JsonObject> findPublisher(MongoCollection<Document> collection, ClientSession session, Bson filter) {
        return JsonClient.findPublisher(collection, session, filter, null);
    }

    public static Flow.Publisher<JsonObject> findPublisher(MongoCollection<Document> collection, UnaryOperator<FindPublisher<BsonDocument>> setParameters) {
        return JsonClient.findPublisher(collection, (Bson)null, setParameters);
    }

    public static Flow.Publisher<JsonObject> findPublisher(MongoCollection<Document> collection, Bson filter, UnaryOperator<FindPublisher<BsonDocument>> setParameters) {
        return JsonClient.findPublisher(filter != null ? () -> collection.find(filter, BsonDocument.class) : () -> collection.find(BsonDocument.class), setParameters);
    }

    public static Flow.Publisher<JsonObject> findPublisher(MongoCollection<Document> collection, JsonObject filter, UnaryOperator<FindPublisher<BsonDocument>> setParameters) {
        return JsonClient.findPublisher(collection, (Bson)(filter != null ? BsonUtil.fromJson(filter) : null), setParameters);
    }

    public static Flow.Publisher<JsonObject> findPublisher(MongoCollection<Document> collection, ClientSession session, Bson filter, UnaryOperator<FindPublisher<BsonDocument>> setParameters) {
        return JsonClient.findPublisher(filter != null ? () -> collection.find(session, filter, BsonDocument.class) : () -> collection.find(session, BsonDocument.class), setParameters);
    }

    public static Flow.Publisher<JsonObject> findPublisher(MongoCollection<Document> collection, ClientSession session, JsonObject filter, UnaryOperator<FindPublisher<BsonDocument>> setParameters) {
        return JsonClient.findPublisher(collection, session, (Bson)(filter != null ? BsonUtil.fromJson(filter) : null), setParameters);
    }

    private static Flow.Publisher<JsonObject> findPublisher(Supplier<FindPublisher<BsonDocument>> operation, UnaryOperator<FindPublisher<BsonDocument>> setParameters) {
        return Optional.of(operation.get()).map(a -> setParameters != null ? (FindPublisher)setParameters.apply((FindPublisher<BsonDocument>)a) : a).map(FlowAdapters::toFlowPublisher).map(JsonClient::toJson).orElseGet(Util::empty);
    }

    public static CompletionStage<Optional<JsonObject>> findOne(MongoCollection<Document> collection, Bson filter) {
        return Collection.findOne(collection, filter, BsonDocument.class, null).thenApply(result -> result.map(BsonUtil::fromBson));
    }

    public static CompletionStage<Optional<JsonObject>> findOne(MongoCollection<Document> collection, JsonObject filter) {
        return JsonClient.findOne(collection, (Bson)BsonUtil.fromJson(filter));
    }

    public static CompletionStage<Optional<JsonObject>> findOne(MongoCollection<Document> collection, ClientSession session, Bson filter) {
        return Collection.findOne(collection, session, filter, BsonDocument.class, null).thenApply(result -> result.map(BsonUtil::fromBson));
    }

    public static CompletionStage<Optional<JsonObject>> findOne(MongoCollection<Document> collection, ClientSession session, JsonObject filter) {
        return JsonClient.findOne(collection, session, (Bson)BsonUtil.fromJson(filter));
    }

    static List<Bson> fromJsonArray(JsonArray array) {
        return JsonClient.fromJsonStream(array.stream());
    }

    static List<Bson> fromJsonStream(Stream<? extends JsonValue> stream) {
        return stream.map(JsonValue::asJsonObject).map(BsonUtil::fromJson).collect(Collectors.toList());
    }

    public static CompletionStage<Boolean> insert(MongoCollection<Document> collection, JsonObject json) {
        return JsonClient.insert(collection, json, null);
    }

    public static CompletionStage<Boolean> insert(MongoCollection<Document> collection, JsonObject json, ClientSession session) {
        Document document = BsonUtil.toDocument(BsonUtil.fromJson(json));
        return (session != null ? Collection.insertOne(collection, session, document) : Collection.insertOne(collection, document)).thenApply(InsertOneResult::wasAcknowledged);
    }

    public static Stream<JsonObject> patch(JsonObject source, JsonObject target) {
        return JsonClient.patch(JsonUtil.createDiff((JsonStructure)source, (JsonStructure)target));
    }

    public static Stream<JsonObject> patch(JsonPatch patch) {
        return patch.toJsonArray().stream().filter(JsonUtil::isObject).map(JsonValue::asJsonObject);
    }

    private static List<JsonObject> toJson(List<BsonDocument> list) {
        return list.stream().map(BsonUtil::fromBson).collect(Collectors.toList());
    }

    private static Flow.Publisher<JsonObject> toJson(Flow.Publisher<BsonDocument> pub) {
        return Chain.with(pub).map(BsonUtil::fromBson).get();
    }

    public static CompletionStage<Boolean> update(MongoCollection<Document> collection, JsonObject json, String id) {
        return JsonClient.update(collection, json, id, null);
    }

    public static CompletionStage<Boolean> update(MongoCollection<Document> collection, JsonObject json) {
        return JsonClient.update(collection, json, (ClientSession)null);
    }

    public static CompletionStage<Boolean> update(MongoCollection<Document> collection, JsonObject json, String id, ClientSession session) {
        return JsonClient.update(collection, json, JsonUtil.createValue((Object)id), session);
    }

    public static CompletionStage<Boolean> update(MongoCollection<Document> collection, JsonObject json, ClientSession session) {
        return JsonClient.update(collection, json, (JsonValue)json.get((Object)ID), session);
    }

    public static CompletionStage<Boolean> update(MongoCollection<Document> collection, JsonObject json, JsonValue id, ClientSession session) {
        Document document = BsonUtil.toDocument(BsonUtil.fromJson(json));
        Bson filter = Filters.eq((String)ID, (Object)JsonUtil.toNative((JsonValue)id));
        ReplaceOptions options = new ReplaceOptions().upsert(true);
        return (session != null ? Collection.replaceOne(collection, session, filter, document, options) : Collection.replaceOne(collection, filter, document, options)).thenApply(UpdateResult::wasAcknowledged);
    }

    public static CompletionStage<Boolean> update(MongoCollection<Document> collection, JsonObject source, JsonObject target) {
        return Optional.of(JsonClient.updateOperators(source, target)).filter(ops -> !ops.isEmpty()).map(ops -> Collection.exec(collection, c -> c.bulkWrite(ops, new BulkWriteOptions().ordered(true))).thenApply(BulkWriteResult::wasAcknowledged)).orElseGet(() -> CompletableFuture.completedFuture(true));
    }

    private static List<UpdateOneModel<Document>> updateOperators(JsonObject source, JsonObject target) {
        return Patch.updateOperators(source, JsonClient.patch(source, target)).map(op -> new UpdateOneModel(Filters.eq((String)ID, (Object)BsonUtil.fromJson((JsonValue)source.get((Object)ID))), (Bson)BsonUtil.fromJson(op))).collect(Collectors.toList());
    }

    public static Flow.Publisher<JsonObject> watch(MongoCollection<Document> collection) {
        return Chain.with((Flow.Publisher)FlowAdapters.toFlowPublisher((Publisher)collection.watch(COLLECTION_CHANGES))).map(JsonClient::changedDocument).get();
    }
}

