/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import com.mongodb.TransactionOptions;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.MongoClient;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Function;
import net.pincette.rs.Util;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class Session {
    private Session() {
    }

    public static CompletionStage<Void> abortTransaction(ClientSession session) {
        return Util.emptyAsync((Flow.Publisher)FlowAdapters.toFlowPublisher((Publisher)session.abortTransaction()));
    }

    public static CompletionStage<Void> commitTransaction(ClientSession session) {
        return Util.emptyAsync((Flow.Publisher)FlowAdapters.toFlowPublisher((Publisher)session.commitTransaction()));
    }

    public static CompletionStage<ClientSession> create(MongoClient client) {
        return Util.asValueAsync((Flow.Publisher)FlowAdapters.toFlowPublisher((Publisher)client.startSession()));
    }

    public static <T> CompletionStage<T> inTransaction(Function<ClientSession, CompletionStage<T>> fn, ClientSession session) {
        return Session.inTransaction(fn, session, null);
    }

    public static <T> CompletionStage<T> inTransaction(Function<ClientSession, CompletionStage<T>> fn, ClientSession session, TransactionOptions options) {
        if (options != null) {
            session.startTransaction(options);
        } else {
            session.startTransaction();
        }
        return fn.apply(session).thenComposeAsync(result -> result != null ? Session.commitTransaction(session).thenApply(r -> result) : Session.abortTransaction(session).thenApply(r -> null)).exceptionally(e -> {
            Session.abortTransaction(session).toCompletableFuture().join();
            net.pincette.util.Util.rethrow((Throwable)e);
            return null;
        });
    }
}

