/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.json.JsonObject;
import javax.json.JsonReader;
import net.pincette.json.JsonUtil;
import net.pincette.mongo.Validator;
import net.pincette.util.Cases;
import net.pincette.util.Util;

class SourceResolver {
    private static final String RESOURCE = "resource:";
    private final Map<String, JsonObject> loaded = new HashMap<String, JsonObject>();

    SourceResolver() {
    }

    private static boolean isDirectory(String context) {
        return SourceResolver.isKind(context, File::isDirectory);
    }

    private static boolean isFile(String context) {
        return SourceResolver.isKind(context, File::isFile);
    }

    private static boolean isKind(String context, Predicate<File> test) {
        return Optional.ofNullable(context).filter(c -> test.test(new File((String)c))).isPresent();
    }

    private static boolean isResource(String ref) {
        return Optional.ofNullable(ref).filter(r -> r.startsWith(RESOURCE)).isPresent();
    }

    private static String resolveResource(String resource, String baseResource) {
        String path = baseResource.substring(RESOURCE.length());
        return RESOURCE + Util.canonicalPath((String)((String)(path.endsWith("/") ? path : Util.getParent((String)path, (String)"/") + "/") + resource), (String)"/");
    }

    private static Optional<String> resolveSource(String source, String context) {
        return Cases.withValue((Object)source).or(SourceResolver::isResource, s -> s).or(s -> SourceResolver.isResource(context) && !s.startsWith("/"), s -> SourceResolver.resolveResource(s, context)).or(s -> SourceResolver.isDirectory(context), s -> new File(context, (String)s).getAbsolutePath()).or(SourceResolver::isFile, s -> new File((String)s).getAbsolutePath()).get();
    }

    private static String resourcePath(String ref) {
        return ref.substring(RESOURCE.length());
    }

    private JsonObject load(InputStream in) {
        return Util.tryToGetWithRethrow(() -> JsonUtil.createReader((InputStream)in), JsonReader::readObject).orElse(null);
    }

    private JsonObject load(File file) {
        return this.load((InputStream)Util.tryToGetRethrow(() -> new FileInputStream(file)).orElse(null));
    }

    private JsonObject load(String resource) {
        return this.load(SourceResolver.class.getResourceAsStream(resource));
    }

    Optional<Validator.Resolved> resolve(String source, String context) {
        return SourceResolver.resolveSource(source, context).map(s -> new Validator.Resolved(this.loaded.computeIfAbsent((String)s, k -> SourceResolver.isResource(k) ? this.load(SourceResolver.resourcePath(k)) : this.load(new File((String)k))), (String)s));
    }
}

