/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.mongo.Expression;
import net.pincette.mongo.Features;
import net.pincette.mongo.Implementation;
import net.pincette.mongo.Match;
import net.pincette.mongo.Util;
import net.pincette.util.StreamUtil;

class Strings {
    private static final String CAPTURES = "captures";
    private static final String CHARS = "chars";
    private static final String FIND = "find";
    private static final String IDX = "idx";
    private static final String INPUT = "input";
    private static final String MATCH = "match";
    private static final String OPTIONS = "options";
    private static final String REGEX = "regex";
    private static final String REPLACEMENT = "replacement";

    private Strings() {
    }

    static Implementation base64Decode(JsonValue value, Features features) {
        Base64.Decoder decoder = Base64.getDecoder();
        return Strings.string(value, s -> JsonUtil.createValue((Object)new String(decoder.decode(s.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8)), features);
    }

    static Implementation base64Encode(JsonValue value, Features features) {
        Base64.Encoder encoder = Base64.getEncoder();
        return Strings.string(value, s -> JsonUtil.createValue((Object)encoder.encodeToString(s.getBytes(StandardCharsets.UTF_8))), features);
    }

    private static JsonObject capture(Matcher matcher) {
        return JsonUtil.createObjectBuilder().add(MATCH, matcher.group()).add(IDX, matcher.start()).add(CAPTURES, Util.toArray(Strings.groups(matcher).map(JsonUtil::createValue))).build();
    }

    private static JsonValue captureAll(Matcher matcher) {
        return Util.toArray(StreamUtil.takeWhile((Object)matcher, m -> m, Matcher::find).map(Strings::capture));
    }

    static Implementation concat(JsonValue value, Features features) {
        return Expression.stringsOperator(value, Strings::concat, features);
    }

    private static JsonValue concat(List<String> strings) {
        return JsonUtil.createValue((Object)String.join((CharSequence)"", strings));
    }

    private static Stream<String> groups(Matcher matcher) {
        return matcher.groupCount() > 0 ? StreamUtil.rangeInclusive((int)1, (int)matcher.groupCount()).map(matcher::group) : Stream.empty();
    }

    static Implementation jsonToString(JsonValue value, Features features) {
        Implementation implementation = Expression.implementation(value, features);
        return (json, vars) -> JsonUtil.createValue((Object)JsonUtil.string((JsonValue)((JsonValue)implementation.apply(json, vars))));
    }

    static Implementation indexOfCP(JsonValue value, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementations(implementations, json, vars, fncs -> fncs.size() >= 2 && fncs.size() <= 4).filter(values -> !(!JsonUtil.isString((JsonValue)((JsonValue)values.get(0))) || !JsonUtil.isString((JsonValue)((JsonValue)values.get(1))) || values.size() >= 3 && !Strings.isPositive((JsonValue)values.get(2)) || values.size() >= 4 && !Strings.isPositive((JsonValue)values.get(3)))).map(values -> Strings.indexOfCP(Expression.getString(values, 0), Expression.getString(values, 1), values.size() < 3 ? 0 : JsonUtil.asInt((JsonValue)((JsonValue)values.get(2))), values.size() < 4 ? Expression.getString(values, 0).length() : JsonUtil.asInt((JsonValue)((JsonValue)values.get(3))) + 1)).orElse(JsonValue.NULL);
    }

    private static JsonValue indexOfCP(String s, String sub, int start, int end) {
        return JsonUtil.createValue((Object)(end < start || end > s.length() || start >= s.length() ? -1 : s.substring(0, end).indexOf(sub, start)));
    }

    private static boolean isPositive(JsonValue value) {
        return JsonUtil.isNumber((JsonValue)value) && JsonUtil.asInt((JsonValue)value) >= 0;
    }

    static Implementation ltrim(JsonValue value, Features features) {
        return Strings.trim(value, true, false, features);
    }

    private static Implementation regex(JsonValue value, Function<Matcher, JsonValue> capture, Features features) {
        ArrayList<Implementation> implementations = new ArrayList<Implementation>();
        implementations.add(Expression.memberFunction(value, INPUT, features));
        implementations.add(Expression.memberFunction(value, REGEX, features));
        implementations.add(Expression.memberFunction(value, OPTIONS, features));
        return (json, vars) -> Expression.applyImplementations(implementations, json, vars, fncs -> fncs.get(0) != null && fncs.get(1) != null).filter(values -> JsonUtil.isString((JsonValue)((JsonValue)values.get(0))) && JsonUtil.isString((JsonValue)((JsonValue)values.get(1))) && (values.get(2) == null || JsonUtil.isString((JsonValue)((JsonValue)values.get(2))))).map(values -> (JsonValue)capture.apply(Match.compileRegex(Expression.getString(values, 1), values.get(2) == null ? null : Expression.getString(values, 2)).matcher(Expression.getString(values, 0)))).orElse(JsonValue.NULL);
    }

    static Implementation regexFind(JsonValue value, Features features) {
        return Strings.regex(value, matcher -> matcher.find() ? Strings.capture(matcher) : JsonValue.NULL, features);
    }

    static Implementation regexFindAll(JsonValue value, Features features) {
        return Strings.regex(value, Strings::captureAll, features);
    }

    static Implementation regexMatch(JsonValue value, Features features) {
        return Strings.regex(value, matcher -> JsonUtil.createValue((Object)matcher.find()), features);
    }

    private static Implementation replace(JsonValue value, boolean all, Features features) {
        ArrayList<Implementation> implementations = new ArrayList<Implementation>();
        implementations.add(Expression.memberFunction(value, INPUT, features));
        implementations.add(Expression.memberFunction(value, FIND, features));
        implementations.add(Expression.memberFunction(value, REPLACEMENT, features));
        return (json, vars) -> Expression.applyImplementations(implementations, json, vars, fncs -> fncs.get(0) != null && fncs.get(1) != null && fncs.get(2) != null).filter(values -> JsonUtil.isString((JsonValue)((JsonValue)values.get(0))) && JsonUtil.isString((JsonValue)((JsonValue)values.get(1))) && JsonUtil.isString((JsonValue)((JsonValue)values.get(2)))).map(values -> JsonUtil.createValue((Object)(all ? Expression.getString(values, 0).replace(Expression.getString(values, 1), Expression.getString(values, 2)) : Expression.getString(values, 0).replaceFirst(Pattern.quote(Expression.getString(values, 1)), Matcher.quoteReplacement(Expression.getString(values, 2)))))).orElse(JsonValue.NULL);
    }

    static Implementation replaceAll(JsonValue value, Features features) {
        return Strings.replace(value, true, features);
    }

    static Implementation replaceOne(JsonValue value, Features features) {
        return Strings.replace(value, false, features);
    }

    static Implementation rtrim(JsonValue value, Features features) {
        return Strings.trim(value, false, true, features);
    }

    private static boolean shouldTrim(char c, String chars) {
        return chars != null && chars.indexOf(c) != -1 || chars == null && Character.isWhitespace(c);
    }

    static Implementation split(JsonValue value, Features features) {
        return Strings.stringTwo(value, Strings::split, features);
    }

    private static JsonValue split(String s, String delimiter) {
        return Util.toArray(Arrays.stream(s.split(Pattern.quote(delimiter))).map(JsonUtil::createValue));
    }

    static Implementation strLenCP(JsonValue value, Features features) {
        return Strings.string(value, s -> JsonUtil.createValue((Object)s.length()), features);
    }

    static Implementation strcasecmp(JsonValue value, Features features) {
        return Strings.stringTwo(value, (s1, s2) -> JsonUtil.createValue((Object)Util.normalize(s1.compareToIgnoreCase((String)s2))), features);
    }

    private static Implementation string(JsonValue value, Function<String, JsonValue> op, Features features) {
        Implementation implementation = Expression.implementation(value, features);
        return (json, vars) -> Optional.of((JsonValue)implementation.apply(json, vars)).filter(JsonUtil::isString).map(JsonUtil::asString).map(JsonString::getString).map(op).orElse(JsonValue.NULL);
    }

    private static Implementation stringOrNull(JsonValue value, Function<String, JsonValue> op, Features features) {
        Implementation implementation = Expression.implementation(value, features);
        return (json, vars) -> Optional.of((JsonValue)implementation.apply(json, vars)).filter(v -> JsonValue.NULL.equals(v) || JsonUtil.isString((JsonValue)v)).map(v -> JsonValue.NULL.equals((Object)value) ? JsonUtil.createValue((Object)"") : (JsonValue)op.apply(JsonUtil.asString((JsonValue)v).getString())).orElse(JsonValue.NULL);
    }

    static Implementation stringToJson(JsonValue value, Features features) {
        return Strings.string(value, s -> JsonUtil.from((String)s).map(JsonValue.class::cast).orElse(JsonValue.NULL), features);
    }

    private static Implementation stringTwo(JsonValue value, BiFunction<String, String, JsonValue> op, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementationsNum(implementations, json, vars, 2).filter(values -> JsonUtil.isString((JsonValue)((JsonValue)values.get(0))) && JsonUtil.isString((JsonValue)((JsonValue)values.get(1)))).map(values -> (JsonValue)op.apply(Expression.getString(values, 0), Expression.getString(values, 1))).orElse(JsonValue.NULL);
    }

    static Implementation substrCP(JsonValue value, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementationsNum(implementations, json, vars, 3).filter(values -> (JsonValue.NULL.equals(values.get(0)) || JsonUtil.isString((JsonValue)((JsonValue)values.get(0)))) && JsonUtil.isNumber((JsonValue)((JsonValue)values.get(1))) && JsonUtil.isNumber((JsonValue)((JsonValue)values.get(2)))).map(values -> JsonValue.NULL.equals(values.get(0)) ? JsonUtil.createValue((Object)"") : Strings.substrCP(Expression.getString(values, 0), Expression.getInteger(values, 1), Expression.getInteger(values, 2))).orElse(JsonValue.NULL);
    }

    private static JsonValue substrCP(String s, int index, int count) {
        return JsonUtil.createValue((Object)s.substring(index, Integer.min(s.length(), index + count)));
    }

    static Implementation toLower(JsonValue value, Features features) {
        return Strings.stringOrNull(value, s -> JsonUtil.createValue((Object)s.toLowerCase()), features);
    }

    static Implementation toUpper(JsonValue value, Features features) {
        return Strings.stringOrNull(value, s -> JsonUtil.createValue((Object)s.toUpperCase()), features);
    }

    static Implementation trim(JsonValue value, Features features) {
        return Strings.trim(value, true, true, features);
    }

    private static Implementation trim(JsonValue value, boolean start, boolean end, Features features) {
        ArrayList<Implementation> implementations = new ArrayList<Implementation>();
        implementations.add(Expression.memberFunction(value, INPUT, features));
        implementations.add(Expression.memberFunction(value, CHARS, features));
        return (json, vars) -> Expression.applyImplementations(implementations, json, vars, fncs -> fncs.get(0) != null).filter(values -> JsonUtil.isString((JsonValue)((JsonValue)values.get(0))) && (values.get(1) == null || JsonUtil.isString((JsonValue)((JsonValue)values.get(1))))).map(values -> JsonUtil.createValue((Object)Strings.trim(Expression.getString(values, 0), values.get(1) != null ? Expression.getString(values, 1) : null, start, end))).orElse(JsonValue.NULL);
    }

    private static String trim(String s, String chars, boolean start, boolean end) {
        return s.substring(start ? Strings.trimStart(s, chars) : 0, end ? Strings.trimEnd(s, chars) : s.length());
    }

    private static int trimEnd(String s, String chars) {
        int i;
        for (i = s.length() - 1; i >= 0 && Strings.shouldTrim(s.charAt(i), chars); --i) {
        }
        return i + 1;
    }

    private static int trimStart(String s, String chars) {
        int i;
        for (i = 0; i < s.length() && Strings.shouldTrim(s.charAt(i), chars); ++i) {
        }
        return i;
    }

    static Implementation uriDecode(JsonValue value, Features features) {
        return Strings.string(value, s -> JsonUtil.createValue((Object)URLDecoder.decode(s, StandardCharsets.UTF_8)), features);
    }

    static Implementation uriEncode(JsonValue value, Features features) {
        return Strings.string(value, s -> JsonUtil.createValue((Object)URLEncoder.encode(s, StandardCharsets.UTF_8)), features);
    }
}

