/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.util.Optional;
import javax.json.JsonNumber;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.mongo.Expression;
import net.pincette.mongo.Features;
import net.pincette.mongo.Implementation;

class Trigonometry {
    private Trigonometry() {
    }

    static Implementation acos(JsonValue value, Features features) {
        return Trigonometry.toDouble(Expression.math(value, Math::acos, features));
    }

    static Implementation acosh(JsonValue value, Features features) {
        return Trigonometry.toDouble(Expression.math(value, v -> Math.log(v + Math.sqrt(Math.pow(v, 2.0) - 1.0)), features));
    }

    static Implementation asin(JsonValue value, Features features) {
        return Trigonometry.toDouble(Expression.math(value, Math::asin, features));
    }

    static Implementation asinh(JsonValue value, Features features) {
        return Trigonometry.toDouble(Expression.math(value, v -> Math.log(v + Math.sqrt(Math.pow(v, 2.0) + 1.0)), features));
    }

    static Implementation atan(JsonValue value, Features features) {
        return Trigonometry.toDouble(Expression.math(value, Math::atan, features));
    }

    static Implementation atanh(JsonValue value, Features features) {
        return Trigonometry.toDouble(Expression.math(value, v -> 0.5 * Math.log((1.0 + v) / (1.0 - v)), features));
    }

    static Implementation atan2(JsonValue value, Features features) {
        return Trigonometry.toDouble(Expression.mathTwo(value, Math::atan2, false, features));
    }

    static Implementation cos(JsonValue value, Features features) {
        return Trigonometry.toDouble(Expression.math(value, Math::cos, features));
    }

    static Implementation degreesToRadians(JsonValue value, Features features) {
        return Trigonometry.toDouble(Expression.math(value, Math::toRadians, features));
    }

    static Implementation radiansToDegrees(JsonValue value, Features features) {
        return Trigonometry.toDouble(Expression.math(value, Math::toDegrees, features));
    }

    static Implementation sin(JsonValue value, Features features) {
        return Trigonometry.toDouble(Expression.math(value, Math::sin, features));
    }

    static Implementation tan(JsonValue value, Features features) {
        return Trigonometry.toDouble(Expression.math(value, Math::tan, features));
    }

    private static Implementation toDouble(Implementation implementation) {
        return (json, vars) -> Optional.of((JsonValue)implementation.apply(json, vars)).filter(JsonUtil::isNumber).map(JsonUtil::asNumber).map(JsonNumber::doubleValue).map(JsonUtil::createValue).orElse(JsonValue.NULL);
    }
}

