/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.mongo.Cmp;
import net.pincette.util.Pair;

public class Util {
    private static final String DOLLAR = "_dollar_";
    private static final String DOT = "_dot_";
    static final Logger LOGGER = Logger.getLogger("net.pincette.mongo.expressions");
    private static final String SLASH = "_slash_";
    private static final String TRACE = "$trace";

    private Util() {
    }

    public static int compare(JsonValue v1, JsonValue v2) {
        return Util.normalize(Optional.of(Util.typeValue(v1) - Util.typeValue(v2)).filter(result -> result != 0).orElseGet(() -> Cmp.compare(v1, v2)));
    }

    public static String escapeFieldName(String name) {
        return name.replace(".", DOT).replace("/", SLASH).replace("$", DOLLAR);
    }

    public static JsonObject fromMongoDB(JsonObject json) {
        return JsonUtil.transformFieldNames((JsonObject)json, Util::unescapeFieldName).build();
    }

    static Optional<String> key(JsonObject expression) {
        return Optional.of(expression.keySet()).filter(keys -> keys.size() == 1).map(keys -> (String)keys.iterator().next());
    }

    static int normalize(int result) {
        return Integer.min(1, Math.abs(result)) * (result < 0 ? -1 : 1);
    }

    static JsonValue toArray(Stream<JsonValue> values) {
        return values.reduce(JsonUtil.createArrayBuilder(), JsonArrayBuilder::add, (b1, b2) -> b1).build();
    }

    public static JsonObject toMongoDB(JsonObject json) {
        return JsonUtil.transformFieldNames((JsonObject)json, Util::escapeFieldName).build();
    }

    private static int typeValue(JsonValue value) {
        if (value.equals((Object)JsonValue.NULL)) {
            return 2;
        }
        if (JsonUtil.isNumber((JsonValue)value)) {
            return 3;
        }
        if (JsonUtil.isString((JsonValue)value) && !JsonUtil.isDate((JsonValue)value) && !JsonUtil.isInstant((JsonValue)value)) {
            return 4;
        }
        if (JsonUtil.isObject((JsonValue)value)) {
            return 5;
        }
        if (JsonUtil.isArray((JsonValue)value)) {
            return 6;
        }
        if (value.equals((Object)JsonValue.TRUE) || value.equals((Object)JsonValue.FALSE)) {
            return 9;
        }
        if (JsonUtil.isDate((JsonValue)value)) {
            return 10;
        }
        if (JsonUtil.isInstant((JsonValue)value)) {
            return 11;
        }
        return Integer.MAX_VALUE;
    }

    public static String unescapeFieldName(String name) {
        return name.replace(DOT, ".").replace(SLASH, "/").replace(DOLLAR, "$");
    }

    static Pair<JsonValue, Boolean> unwrapTrace(JsonValue expression) {
        return JsonUtil.isObject((JsonValue)expression) ? Util.key(expression.asJsonObject()).filter(key -> key.equals(TRACE)).map(key -> Pair.pair((Object)expression.asJsonObject().getValue("/" + key), (Object)true)).orElseGet(() -> Pair.pair((Object)expression, (Object)false)) : Pair.pair((Object)expression, (Object)false);
    }

    static Pair<JsonObject, Boolean> unwrapTrace(JsonObject expression) {
        Pair<JsonValue, Boolean> unwrapped = Util.unwrapTrace((JsonValue)expression);
        return Pair.pair((Object)((JsonValue)unwrapped.first).asJsonObject(), (Object)((Boolean)unwrapped.second));
    }
}

