/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.json.Transform;
import net.pincette.mongo.Features;
import net.pincette.mongo.Match;
import net.pincette.mongo.SourceResolver;
import net.pincette.util.Builder;
import net.pincette.util.Collections;
import net.pincette.util.Or;
import net.pincette.util.Pair;
import net.pincette.util.StreamUtil;
import net.pincette.util.Util;

public class Validator {
    private static final String CODE = "$code";
    private static final String COMMENT = "$comment";
    private static final String CONDITIONS = "conditions";
    private static final String DESCRIPTION = "description";
    private static final String ERROR_CODE = "code";
    private static final String ERROR_LOCATION = "location";
    private static final String EXISTS = "$exists";
    private static final String INCLUDE = "include";
    private static final String LOCATION = "$location";
    private static final String MACROS = "macros";
    private static final String REF = "ref";
    private static final String TITLE = "title";
    private static final Set<String> REMOVE = Collections.set((Object[])new String[]{"$comment", "description", "title"});
    private static final Transform.Transformer REMOVER = new Transform.Transformer(entry -> Util.getLastSegment((String)entry.path, (String)".").map(REMOVE::contains).orElse(false), entry -> Optional.empty());
    private final Map<JsonObject, Condition> conditionCache = new HashMap<JsonObject, Condition>();
    private final Features features;
    private Resolver resolver;

    public Validator() {
        this(null);
    }

    public Validator(Features features) {
        this(features, null);
    }

    public Validator(Features features, Resolver resolver) {
        this.features = features;
        this.setResolver(resolver != null ? resolver : new SourceResolver()::resolve);
    }

    private static Transform.Transformer arrayExpander(JsonObject macros) {
        return new Transform.Transformer(entry -> JsonUtil.isArray((JsonValue)entry.value), entry -> Optional.of(new Transform.JsonEntry(entry.path, (JsonValue)Validator.expandArray(entry.value.asJsonArray(), macros))));
    }

    private static JsonArrayBuilder combineConditions(JsonObject json, Stream<JsonValue> included) {
        return Stream.concat(included, Optional.ofNullable(json.getJsonArray(CONDITIONS)).map(Collection::stream).orElseGet(Stream::empty)).reduce(JsonUtil.createArrayBuilder(), JsonArrayBuilder::add, (b1, b2) -> b1);
    }

    private static JsonObject combineMacros(JsonObject json, JsonObject includedMacros) {
        return JsonUtil.add((JsonObject)includedMacros, (JsonObject)Optional.ofNullable(json.getJsonObject(MACROS)).map(macros -> !includedMacros.isEmpty() ? Transform.transform((JsonObject)macros, (Transform.Transformer)Validator.expanders(includedMacros)) : macros).orElseGet(JsonUtil::emptyObject));
    }

    private static Condition condition(JsonObject condition, String code, Features features) {
        String field = Validator.getField(condition);
        String conditionPath = Optional.ofNullable(field).map(JsonUtil::toJsonPointer).orElse("");
        boolean isExists = field != null && Validator.isExists((JsonValue)condition.get((Object)field));
        Predicate<JsonObject> test = Match.predicate(Validator.strip(condition), features);
        return (json, path) -> Optional.of(Validator.testObject(json, path, conditionPath)).map(j -> !conditionPath.equals("") && !Validator.parentExists((JsonValue)json, path) || conditionPath.equals("") && !JsonUtil.getValue((JsonStructure)json, (String)path).isPresent() || !conditionPath.equals("") && !isExists && !JsonUtil.getValue((JsonStructure)j, (String)conditionPath).isPresent() || test.test(Validator.testObject(json, path, conditionPath))).orElse(false) != false ? Stream.empty() : Stream.of(Validator.createError(path, code));
    }

    private static JsonObject createError(String path, String code) {
        return ((JsonObjectBuilder)Builder.create(JsonUtil::createObjectBuilder).update(b -> b.add(ERROR_LOCATION, path)).updateIf(() -> Optional.ofNullable(code), (b, c) -> b.add(ERROR_CODE, c)).build()).build();
    }

    private static JsonValue expand(JsonValue value, JsonObject macros) {
        return Validator.getMacroRef(value).flatMap(ref -> JsonUtil.getValue((JsonStructure)macros, (String)("/" + ref))).orElse(value);
    }

    private static JsonArray expandArray(JsonArray array, JsonObject macros) {
        return array.stream().map(value -> Validator.isMacroRef(value) ? Validator.expand(value, macros) : value).reduce(JsonUtil.createArrayBuilder(), JsonArrayBuilder::add, (b1, b2) -> b1).build();
    }

    private static Transform.Transformer expander(JsonObject macros) {
        return new Transform.Transformer(entry -> Validator.isMacroRef(entry.value), entry -> Optional.of(new Transform.JsonEntry(entry.path, Validator.expand(entry.value, macros))));
    }

    private static Transform.Transformer expanders(JsonObject macros) {
        return !macros.isEmpty() ? Validator.arrayExpander(macros).thenApply(Validator.expander(macros)) : Transform.nopTransformer();
    }

    private static String getField(JsonObject condition) {
        return condition.keySet().stream().filter(k -> !k.startsWith("$")).findFirst().orElse(null);
    }

    private static Optional<String> getMacroRef(JsonValue value) {
        return JsonUtil.stringValue((JsonValue)value).filter(s -> s.startsWith("_") && s.endsWith("_")).map(s -> s.substring(1, s.length() - 1));
    }

    private static String getPath(JsonObject condition, String parentPath) {
        return parentPath + Or.tryWith(() -> Validator.getField(condition)).or(() -> condition.getString(LOCATION, null)).get().map(JsonUtil::toJsonPointer).orElse("");
    }

    private static Optional<String> getRef(JsonValue value) {
        return JsonUtil.objectValue((JsonValue)value).filter(json -> Validator.hasOnlyThisKey(json, REF)).map(json -> Optional.ofNullable(json.getString(REF, null))).orElseGet(() -> Validator.getRefInArray(value));
    }

    private static Optional<String> getRefInArray(JsonValue value) {
        return JsonUtil.arrayValue((JsonValue)value).filter(a -> a.size() == 1).map(a -> (JsonValue)a.get(0)).flatMap(Validator::getRef);
    }

    private static boolean hasOnlyThisKey(JsonObject json, String key) {
        return Optional.of(json.keySet()).map(keys -> keys.size() == 1 && ((String)keys.iterator().next()).equals(key)).orElse(false);
    }

    private static JsonObject include(JsonObject json, Resolver resolver, String context) {
        Pair<Stream<JsonValue>, JsonObject> included = Validator.loadIncluded(json, resolver, context);
        return JsonUtil.createObjectBuilder((JsonObject)json).remove(INCLUDE).remove(MACROS).add(CONDITIONS, Validator.combineConditions(json, (Stream)included.first)).add(MACROS, (JsonValue)Validator.combineMacros(json, (JsonObject)included.second)).build();
    }

    private static boolean isConditions(JsonValue value) {
        return JsonUtil.isObject((JsonValue)value) && value.asJsonObject().containsKey((Object)CONDITIONS);
    }

    private static boolean isExists(JsonValue expression) {
        return Optional.of(expression).filter(JsonUtil::isObject).map(JsonValue::asJsonObject).filter(json -> json.containsKey((Object)EXISTS)).isPresent();
    }

    private static boolean isMacroRef(JsonValue value) {
        return Validator.getMacroRef(value).isPresent();
    }

    private static boolean isRef(JsonValue value) {
        return Validator.getRef(value).isPresent();
    }

    private static Pair<Stream<JsonValue>, JsonObject> loadIncluded(JsonObject json, Resolver resolver, String context) {
        return JsonUtil.getStrings((JsonObject)json, (String)INCLUDE).map(s -> (Optional)resolver.apply(s, context)).filter(Optional::isPresent).map(Optional::get).map(resolved -> Validator.resolve(resolved.specification, resolver, resolved.source)).map(included -> Pair.pair((Object)included.getJsonArray(CONDITIONS).stream(), (Object)Validator.macros(included))).reduce(Pair.pair(Stream.empty(), (Object)JsonUtil.emptyObject()), (r, p) -> Pair.pair(Stream.concat((Stream)r.first, (Stream)p.first), (Object)JsonUtil.add((JsonObject)((JsonObject)r.second), (JsonObject)((JsonObject)p.second))), (r1, r2) -> r1);
    }

    private static JsonObject macros(JsonObject specification) {
        return Optional.ofNullable(specification.getJsonObject(MACROS)).orElseGet(JsonUtil::emptyObject);
    }

    private static boolean parentExists(JsonValue json, String path) {
        String parent = Util.getParent((String)path, (String)"/");
        return parent.equals("/") || !JsonUtil.isObject((JsonValue)json) || JsonUtil.getValue((JsonStructure)json.asJsonObject(), (String)parent).isPresent();
    }

    private static Optional<String> parentPath(String path, String conditionPath) {
        return Optional.of(path.lastIndexOf(conditionPath)).filter(i -> i != -1).map(i -> path.substring(0, (int)i));
    }

    private static Transform.Transformer refResolver(Resolver resolver, String context) {
        return new Transform.Transformer(entry -> Validator.isRef(entry.value), entry -> Validator.getRef(entry.value).flatMap(ref -> (Optional)resolver.apply(ref, context)).map(resolved -> Validator.resolve(resolved.specification, resolver, resolved.source)).map(resolved -> JsonUtil.isArray((JsonValue)entry.value) ? JsonUtil.createArrayBuilder().add((JsonValue)resolved).build() : resolved).map(resolved -> new Transform.JsonEntry(entry.path, (JsonValue)resolved)));
    }

    public static JsonObject resolve(JsonObject specification, Resolver resolver, String context) {
        JsonObject json = Validator.include(specification, resolver, context);
        return Transform.transform((JsonObject)json, (Transform.Transformer)Validator.expanders(Validator.macros(json)).thenApply(Validator.refResolver(resolver, context)).thenApply(REMOVER));
    }

    private static JsonObject strip(JsonObject condition) {
        return JsonUtil.createObjectBuilder((JsonObject)condition).remove(LOCATION).remove(CODE).build();
    }

    private static JsonObject testObject(JsonObject json, String path, String conditionPath) {
        return Validator.parentPath(path, conditionPath).filter(p -> !p.equals("")).flatMap(p -> JsonUtil.getObject((JsonStructure)json, (String)p)).orElse(json);
    }

    private Condition condition(JsonObject condition) {
        Condition c = (Condition)Collections.computeIfAbsent(this.conditionCache, (Object)condition, k -> this.generateCondition((JsonObject)k, this.features));
        return (json, path) -> (Stream)c.apply(json, Validator.getPath(condition, path));
    }

    private Condition conditions(String field, JsonValue value) {
        return Validator.isConditions(value) ? this.conditionsObject(value.asJsonObject()) : this.conditionArray(field, value.asJsonArray());
    }

    private Condition conditionArray(String field, JsonArray array) {
        Condition conditions = this.conditionsObject(((JsonValue)array.get(0)).asJsonObject());
        return (json, path) -> JsonUtil.getArray((JsonStructure)json, (String)JsonUtil.toJsonPointer((String)field)).map(values -> StreamUtil.zip((Stream)values.stream(), (Stream)StreamUtil.rangeExclusive((int)0, (int)values.size())).flatMap(pair -> JsonUtil.isObject((JsonValue)((JsonValue)pair.first)) ? (Stream)conditions.apply(json, path + "/" + pair.second) : Stream.empty())).orElseGet(Stream::empty);
    }

    private Condition conditionsObject(JsonObject conditions) {
        List c = JsonUtil.getObjects((JsonObject)conditions, (String)CONDITIONS).map(this::condition).collect(Collectors.toList());
        return (json, path) -> c.stream().flatMap(condition -> (Stream)condition.apply(json, path));
    }

    private Condition generateCondition(JsonObject condition, Features features) {
        return Optional.ofNullable(Validator.getField(condition)).flatMap(field -> JsonUtil.getValue((JsonStructure)condition, (String)JsonUtil.toJsonPointer((String)field)).map(value -> Pair.pair((Object)field, (Object)value))).filter(pair -> Validator.isConditions((JsonValue)pair.second) || JsonUtil.isArray((JsonValue)((JsonValue)pair.second))).map(pair -> this.conditions((String)pair.first, (JsonValue)pair.second)).orElseGet(() -> Validator.condition(condition, condition.getString(CODE, null), features));
    }

    public JsonObject load(String source) {
        return this.load(source, (String)null);
    }

    public JsonObject load(String source, File baseDirectory) {
        return this.load(source, (String)Optional.ofNullable(baseDirectory).map(File::getAbsolutePath).orElse(null));
    }

    public JsonObject load(String source, String context) {
        return ((Optional)this.resolver.apply(source, context)).map(resolved -> Validator.resolve(resolved.specification, this.resolver, resolved.source)).orElse(null);
    }

    public JsonObject resolve(JsonObject specification) {
        return this.resolve(specification, (String)null);
    }

    public JsonObject resolve(JsonObject specification, File baseDirectory) {
        return this.resolve(specification, (String)Optional.ofNullable(baseDirectory).map(File::getAbsolutePath).orElse(null));
    }

    public JsonObject resolve(JsonObject specification, String context) {
        return Validator.resolve(specification, this.resolver, context);
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public Function<JsonObject, JsonArray> validator(String source) {
        return this.validator(this.load(source));
    }

    public Function<JsonObject, JsonArray> validator(JsonObject specification) {
        Condition conditions = this.conditionsObject(this.resolve(specification));
        return json -> ((Stream)conditions.apply(json, "")).reduce(JsonUtil.createArrayBuilder(), JsonArrayBuilder::add, (b1, b2) -> b1).build();
    }

    public static interface Resolver
    extends BiFunction<String, String, Optional<Resolved>> {
    }

    private static interface Condition
    extends BiFunction<JsonObject, String, Stream<JsonValue>> {
    }

    public static class Resolved {
        final String source;
        final JsonObject specification;

        public Resolved(JsonObject specification, String source) {
            this.specification = specification;
            this.source = source;
        }
    }
}

