/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.mongo.Expression;
import net.pincette.mongo.Features;
import net.pincette.mongo.Implementation;
import net.pincette.mongo.Util;
import net.pincette.util.Pair;
import net.pincette.util.StreamUtil;

class Zip {
    private static final String DEFAULTS = "defaults";
    private static final String INPUTS = "inputs";
    private static final String USE_LONGEST_LENGTH = "useLongestLength";

    private Zip() {
    }

    private static List<JsonValue> defaults(JsonValue defaults, int end) {
        return Optional.of(defaults).filter(JsonUtil::isArray).map(JsonValue::asJsonArray).map(defs -> Stream.concat(defs.stream(), Zip.defaultsNull(Integer.max(end - defs.size(), 0)))).orElseGet(() -> Zip.defaultsNull(end)).collect(Collectors.toList());
    }

    private static Stream<JsonValue> defaultsNull(int size) {
        return StreamUtil.zip((Stream)StreamUtil.rangeExclusive((int)0, (int)size), Stream.generate(() -> JsonValue.NULL)).map(pair -> (JsonValue)pair.second);
    }

    private static Pair<Integer, Integer> shortestLongest(List<JsonValue> values) {
        return values.stream().map(JsonValue::asJsonArray).reduce(Pair.pair((Object)Integer.MAX_VALUE, (Object)0), (p, a) -> Pair.pair((Object)Math.min(a.size(), (Integer)p.first), (Object)Integer.max(a.size(), (Integer)p.second)), (p1, p2) -> p1);
    }

    private static JsonValue value(List<JsonValue> values, int index, List<JsonValue> defaults, int shortest) {
        return Util.toArray(StreamUtil.rangeExclusive((int)0, (int)values.size()).map(i -> Optional.of(((JsonValue)values.get((int)i)).asJsonArray()).filter(array -> index < array.size()).map(array -> (JsonValue)array.get(index)).orElseGet(() -> (JsonValue)defaults.get(index - shortest))));
    }

    static Implementation zip(JsonValue value, Features features) {
        Implementation defaults = Expression.memberFunction(value, DEFAULTS, features);
        List<Implementation> implementations = Expression.memberFunctions(value, INPUTS, features);
        boolean useLongest = Expression.member(value, USE_LONGEST_LENGTH, v -> !Expression.isFalse(v)).orElse(false);
        return (json, vars) -> Expression.applyImplementations(implementations, json, vars).filter(values -> values.stream().allMatch(JsonUtil::isArray)).map(values -> Pair.pair((Object)values, Zip.shortestLongest(values))).map(pair -> Zip.zip((List)pair.first, useLongest ? (Integer)((Pair)pair.second).second : (Integer)((Pair)pair.second).first, (Integer)((Pair)pair.second).first, Zip.defaults(Optional.ofNullable(defaults).map(d -> (JsonValue)d.apply(json, vars)).orElseGet(JsonUtil::emptyArray), (Integer)((Pair)pair.second).second))).orElse(JsonValue.NULL);
    }

    private static JsonValue zip(List<JsonValue> values, int end, int shortest, List<JsonValue> defaults) {
        return Util.toArray(StreamUtil.rangeExclusive((int)0, (int)end).map(i -> Zip.value(values, i, defaults, shortest)));
    }
}

