/*
 * Decompiled with CFR 0.152.
 */
package net.plyse.google.api.place.model;

import net.plyse.google.api.place.exception.MissingParameterException;
import net.plyse.google.api.place.model.LatLngLiteral;
import net.plyse.google.api.place.model.Request;
import net.plyse.google.api.place.util.Utility;

public class TextSearchRequest
implements Request {
    private static final String OUTPUT = "json";
    private static final String BASE_URL = "https://maps.googleapis.com/maps/api/place/textsearch/json";
    private String query;
    private String language;
    private LatLngLiteral location;
    private int maxPrice = -1;
    private int minPrice = -1;
    private Boolean openNow;
    private String pageToken;
    private int radius = -1;
    private String region;
    private String type;

    @Override
    public String getUrl() {
        if (this.query == null || this.query.isEmpty()) {
            throw new MissingParameterException("A query is always needed for a text search.");
        }
        StringBuilder stringBuilder = new StringBuilder(BASE_URL).append("?query=").append(this.query).append("&key=").append(Utility.getApiKey()).append("&");
        if (this.language != null) {
            stringBuilder.append("language=").append(this.language).append("&");
        }
        if (this.location != null) {
            stringBuilder.append("location=").append(this.location.getLat()).append("%2C").append(this.location.getLng()).append("&");
        }
        if (this.maxPrice != -1) {
            stringBuilder.append("maxprice=").append(this.maxPrice).append("&");
        }
        if (this.minPrice != -1) {
            stringBuilder.append("minprice=").append(this.minPrice).append("&");
        }
        if (this.openNow != null) {
            stringBuilder.append("opennow=").append(this.openNow).append("&");
        }
        if (this.pageToken != null) {
            stringBuilder.append("pagetoken=").append(this.pageToken).append("&");
        }
        if (this.radius != -1) {
            stringBuilder.append("radius=").append(this.radius).append("&");
        }
        if (this.region != null) {
            stringBuilder.append("region=").append(this.region).append("&");
        }
        if (this.type != null) {
            stringBuilder.append("type=").append(this.type).append("&");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public TextSearchRequest(String query, String language, LatLngLiteral location, int maxPrice, int minPrice, Boolean openNow, String pageToken, int radius, String region, String type) {
        this.query = query;
        this.language = language;
        this.location = location;
        this.maxPrice = maxPrice;
        this.minPrice = minPrice;
        this.openNow = openNow;
        this.pageToken = pageToken;
        this.radius = radius;
        this.region = region;
        this.type = type;
    }

    public TextSearchRequest() {
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setLocation(LatLngLiteral location) {
        this.location = location;
    }

    public void setMaxPrice(int maxPrice) {
        this.maxPrice = maxPrice;
    }

    public void setMinPrice(int minPrice) {
        this.minPrice = minPrice;
    }

    public void setOpenNow(Boolean openNow) {
        this.openNow = openNow;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getQuery() {
        return this.query;
    }

    public String getLanguage() {
        return this.language;
    }

    public LatLngLiteral getLocation() {
        return this.location;
    }

    public int getMaxPrice() {
        return this.maxPrice;
    }

    public int getMinPrice() {
        return this.minPrice;
    }

    public Boolean getOpenNow() {
        return this.openNow;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public int getRadius() {
        return this.radius;
    }

    public String getRegion() {
        return this.region;
    }

    public String getType() {
        return this.type;
    }
}

