package net.polyv.common.v1.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

import com.alibaba.fastjson.JSON;

import lombok.extern.slf4j.Slf4j;
import net.polyv.common.v1.constant.Constant;
import net.polyv.common.v1.entity.AccountInfo;

/**
 * @author: thomas
 **/
@Slf4j
public class FileUtil {
    /**
     * 私有构造方法，防止类的实例化，因为工具类不需要实例化。
     */
    private FileUtil() {
    
    }
    
    /**
     * 读取文件内容
     * @param filepath 文件绝对路径
     * @return
     */
    public static String readFile(String filepath) throws IOException {
        Path path = Paths.get(filepath);
        byte[] data = Files.readAllBytes(path);
        return new String(data, Constant.UTF8_CHARSET);
    }
    
    
    /**
     * 从文件读取JSON初始化配置，JSON格式如下：liveConfig:直播配置，vodConfig：点播配置
     * {"liveConfig":{"appId":"xxx","userId":"xxx","appSecret":"xxx"},"vodConfig":{"userId":"xxx",
     * "writeToken":"xxxxxxe","readToken":"xxxxxx","secretKey":"xxxx"}}
     */
    public static AccountInfo readConfigFromFile(String path) {
        if (StringUtils.isBlank(path)) {
            path = "/data/password/password.txt";
        }
        String accountInfo = null;
        try {
            accountInfo = FileUtil.readFile(path);
        } catch (IOException e) {
            log.error("读取文件错误，文件路径 {}", path, e);
            return null;
        }
        if (StringUtils.isNotBlank(accountInfo)) {
            return JSON.parseObject(accountInfo, AccountInfo.class);
        } else {
            log.error("文件内容为空，文件路径 {}", path);
            return null;
        }
    }
    
    /**
     * 把二进制写入文件
     * @param bytes
     * @param filepath
     * @throws IOException
     */
    public static void writeFile(byte[] bytes, String filepath) throws IOException {
        Path path = Paths.get(filepath);
        Files.write(path,bytes);
    }
    
    /**
     * 根据文件路径获取文件后缀
     * @param filename 文件路径，如：C:\demo\text.mp4
     * @return 文件后缀，如：mp4
     */
    public static String getExtension(String filename) {
        if (filename == null) {
            return "";
        } else {
            int extensionPos = filename.lastIndexOf(46);
            if (extensionPos < 0) {
                return "";
            }
            return filename.substring(extensionPos + 1);
        }
    }
    
}