/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.java2d;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import org.postgis.PGbox2d;
import org.postgis.PGbox3d;
import org.postgis.java2d.PGShapeGeometry;
import org.postgresql.Driver;
import org.postgresql.PGConnection;

public class Java2DWrapper
extends Driver {
    private static final String POSTGRES_PROTOCOL = "jdbc:postgresql:";
    public static final String POSTGIS_PROTOCOL = "jdbc:postgis_j2d:";
    public static final String REVISION = "$Revision$";

    public Connection connect(String url, Properties info) throws SQLException {
        url = Java2DWrapper.mangleURL(url);
        Connection result = super.connect(url, info);
        Java2DWrapper.addGISTypes((PGConnection)result);
        return result;
    }

    public static void addGISTypes(PGConnection pgconn) throws SQLException {
        pgconn.addDataType("geometry", PGShapeGeometry.class);
        pgconn.addDataType("box3d", PGbox3d.class);
        pgconn.addDataType("box2d", PGbox2d.class);
    }

    public static String mangleURL(String url) throws SQLException {
        if (url.startsWith(POSTGIS_PROTOCOL)) {
            return POSTGRES_PROTOCOL + url.substring(POSTGIS_PROTOCOL.length());
        }
        throw new SQLException("Unknown protocol or subprotocol in url " + url);
    }

    public boolean acceptsURL(String url) {
        try {
            url = Java2DWrapper.mangleURL(url);
        }
        catch (SQLException e) {
            return false;
        }
        return super.acceptsURL(url);
    }

    public int getMajorVersion() {
        return super.getMajorVersion();
    }

    public int getMinorVersion() {
        return super.getMinorVersion();
    }

    public static String getVersion() {
        return "Java2DWrapper $Revision$, wrapping " + Driver.getVersion();
    }

    public Logger getParentLogger() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        try {
            DriverManager.registerDriver((java.sql.Driver)((Object)new Java2DWrapper()));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

