/*
 * Decompiled with CFR 0.152.
 */
package net.postgis.jdbc.jts;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import net.postgis.jdbc.jts.JtsGeometry;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;

public class JTSShape
implements Shape {
    static GeometryFactory fac = new GeometryFactory();
    Geometry geom;
    static final LinearRing[] NOSHELLS = new LinearRing[0];

    public JTSShape(Geometry _geom) {
        this.geom = _geom;
    }

    public JTSShape(JtsGeometry _geom) {
        this(_geom.getGeometry());
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean contains(double x, double y) {
        Coordinate c = new Coordinate(x, y);
        Point p = fac.createPoint(c);
        return this.geom.contains((Geometry)p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        Polygon p = this.createRect(x, y, w, h);
        return this.geom.contains((Geometry)p);
    }

    protected Polygon createRect(double x, double y, double w, double h) {
        Coordinate[] coords = new Coordinate[]{new Coordinate(x, y), new Coordinate(x + w, y), new Coordinate(x + w, y + h), new Coordinate(x, y + h), new Coordinate(x, y)};
        PackedCoordinateSequence.Double shell = new PackedCoordinateSequence.Double(coords, 2);
        Polygon p = fac.createPolygon(fac.createLinearRing((CoordinateSequence)shell), NOSHELLS);
        return p;
    }

    @Override
    public Rectangle2D getBounds2D() {
        Envelope env = this.geom.getEnvelopeInternal();
        return new Rectangle2D.Double(env.getMinX(), env.getMaxX(), env.getWidth(), env.getHeight());
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return JTSShape.getPathIterator(this.geom, at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        Polygon p = this.createRect(x, y, w, h);
        return this.geom.intersects((Geometry)p);
    }

    public static GeometryPathIterator getPathIterator(Geometry geometry, AffineTransform _at) {
        if (geometry instanceof Point) {
            return new PointPathIterator((Point)geometry, _at);
        }
        if (geometry instanceof LineString) {
            return new LineStringPathIterator((LineString)geometry, _at);
        }
        if (geometry instanceof Polygon) {
            return new PolygonPathIterator((Polygon)geometry, _at);
        }
        return new GeometryCollectionPathIterator((GeometryCollection)geometry, _at);
    }

    public static class GeometryCollectionPathIterator
    extends GeometryPathIterator {
        final GeometryCollection coll;
        GeometryPathIterator current;

        public GeometryCollectionPathIterator(GeometryCollection _coll, AffineTransform _at) {
            super(_at);
            this.coll = _coll;
            this.current = JTSShape.getPathIterator(this.coll.getGeometryN(this.index), _at);
        }

        @Override
        public boolean isDone() {
            return this.index > this.coll.getNumGeometries();
        }

        @Override
        public void next() {
            this.current.next();
            if (this.current.isDone()) {
                ++this.index;
                if (this.index < this.coll.getNumGeometries()) {
                    this.current = JTSShape.getPathIterator(this.coll.getGeometryN(this.index), this.at);
                }
            }
        }

        @Override
        public int currentSegment(float[] coords) {
            return this.current.currentSegment(coords);
        }

        @Override
        public int currentSegment(double[] coords) {
            return this.current.currentSegment(coords);
        }
    }

    public static class PolygonPathIterator
    extends LineStringPathIterator {
        final Polygon pg;
        int outerindex = -1;

        public PolygonPathIterator(Polygon _pg, AffineTransform _at) {
            super((LineString)_pg.getExteriorRing(), _at);
            this.pg = _pg;
            this.index = -1;
        }

        @Override
        public boolean isDone() {
            return this.outerindex >= this.pg.getNumInteriorRing();
        }

        @Override
        public void next() {
            super.next();
            if (super.isDone()) {
                ++this.outerindex;
                if (this.outerindex < this.pg.getNumInteriorRing()) {
                    super.reInit(this.pg.getInteriorRingN(this.outerindex).getCoordinateSequence());
                }
            }
        }
    }

    public static class LineStringPathIterator
    extends GeometryPathIterator {
        CoordinateSequence cs;
        final boolean isRing;

        public LineStringPathIterator(LineString ls, AffineTransform _at) {
            super(_at);
            this.cs = ls.getCoordinateSequence();
            this.isRing = ls instanceof LinearRing;
        }

        protected void reInit(CoordinateSequence _cs) {
            this.cs = _cs;
            this.index = 0;
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.index == 0) {
                coords[0] = (float)this.cs.getOrdinate(this.index, 0);
                coords[1] = (float)this.cs.getOrdinate(this.index, 1);
                this.at.transform(coords, 0, coords, 0, 1);
                return 0;
            }
            if (this.index < this.cs.size()) {
                coords[0] = (float)this.cs.getOrdinate(this.index, 0);
                coords[1] = (float)this.cs.getOrdinate(this.index, 1);
                this.at.transform(coords, 0, coords, 0, 1);
                return 1;
            }
            if (this.isRing && this.index == this.cs.size()) {
                return 4;
            }
            throw new IllegalStateException();
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.index == 0) {
                coords[0] = this.cs.getOrdinate(this.index, 0);
                coords[1] = this.cs.getOrdinate(this.index, 1);
                this.at.transform(coords, 0, coords, 0, 1);
                return 0;
            }
            if (this.index < this.cs.size()) {
                coords[0] = this.cs.getOrdinate(this.index, 0);
                coords[1] = this.cs.getOrdinate(this.index, 1);
                this.at.transform(coords, 0, coords, 0, 1);
                return 1;
            }
            if (this.isRing && this.index == this.cs.size()) {
                return 4;
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean isDone() {
            return this.isRing ? this.index > this.cs.size() : this.index >= this.cs.size();
        }
    }

    public static class PointPathIterator
    extends GeometryPathIterator {
        final Point p;

        public PointPathIterator(Point _p, AffineTransform _at) {
            super(_at);
            this.p = _p;
        }

        @Override
        public int currentSegment(float[] coords) {
            switch (this.index) {
                case 0: {
                    coords[0] = (float)this.p.getX();
                    coords[1] = (float)this.p.getY();
                    this.at.transform(coords, 0, coords, 0, 1);
                    return 0;
                }
                case 1: {
                    return 4;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public int currentSegment(double[] coords) {
            switch (this.index) {
                case 0: {
                    coords[0] = this.p.getX();
                    coords[1] = this.p.getY();
                    this.at.transform(coords, 0, coords, 0, 1);
                    return 0;
                }
                case 1: {
                    return 4;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean isDone() {
            return this.index > 1;
        }
    }

    public static abstract class GeometryPathIterator
    implements PathIterator {
        protected final AffineTransform at;
        protected int index = 0;

        GeometryPathIterator(AffineTransform _at) {
            this.at = _at;
        }

        @Override
        public final int getWindingRule() {
            return 0;
        }

        @Override
        public void next() {
            ++this.index;
        }
    }
}

