/*
 * Decompiled with CFR 0.152.
 */
package net.postgis.jdbc.jts;

import net.postgis.jdbc.geometry.binary.ByteGetter;
import net.postgis.jdbc.geometry.binary.ValueGetter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;

public class JtsBinaryParser {
    private JtsSpatialContextFactory jtsFactory = new JtsSpatialContextFactory();

    public static ValueGetter valueGetterForEndian(ByteGetter bytes) {
        if (bytes.get(0) == 0) {
            return new ValueGetter.XDR(bytes);
        }
        if (bytes.get(0) == 1) {
            return new ValueGetter.NDR(bytes);
        }
        throw new IllegalArgumentException("Unknown Endian type:" + bytes.get(0));
    }

    public Geometry parse(String value) {
        ByteGetter.StringByteGetter bytes = new ByteGetter.StringByteGetter(value);
        return this.parseGeometry(JtsBinaryParser.valueGetterForEndian((ByteGetter)bytes));
    }

    public Geometry parse(byte[] value) {
        ByteGetter.BinaryByteGetter bytes = new ByteGetter.BinaryByteGetter(value);
        return this.parseGeometry(JtsBinaryParser.valueGetterForEndian((ByteGetter)bytes));
    }

    protected Geometry parseGeometry(ValueGetter data) {
        return this.parseGeometry(data, 0, false);
    }

    protected Geometry parseGeometry(ValueGetter data, int srid, boolean inheritSrid) {
        MultiPoint result;
        boolean haveS;
        byte endian = data.getByte();
        if (endian != data.endian) {
            throw new IllegalArgumentException("Endian inconsistency!");
        }
        int typeword = data.getInt();
        int realtype = typeword & 0x1FFFFFFF;
        boolean haveZ = (typeword & Integer.MIN_VALUE) != 0;
        boolean haveM = (typeword & 0x40000000) != 0;
        boolean bl = haveS = (typeword & 0x20000000) != 0;
        if (haveS) {
            int newsrid = net.postgis.jdbc.geometry.Geometry.parseSRID((int)data.getInt());
            if (inheritSrid && newsrid != srid) {
                throw new IllegalArgumentException("Inconsistent srids in complex geometry: " + srid + ", " + newsrid);
            }
            srid = newsrid;
        } else if (!inheritSrid) {
            srid = 0;
        }
        switch (realtype) {
            case 1: {
                result = this.parsePoint(data, haveZ, haveM);
                break;
            }
            case 2: {
                result = this.parseLineString(data, haveZ, haveM);
                break;
            }
            case 3: {
                result = this.parsePolygon(data, haveZ, haveM, srid);
                break;
            }
            case 4: {
                result = this.parseMultiPoint(data, srid);
                break;
            }
            case 5: {
                result = this.parseMultiLineString(data, srid);
                break;
            }
            case 6: {
                result = this.parseMultiPolygon(data, srid);
                break;
            }
            case 7: {
                result = this.parseCollection(data, srid);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type!");
            }
        }
        result.setSRID(srid);
        return result;
    }

    private Point parsePoint(ValueGetter data, boolean haveZ, boolean haveM) {
        Point result;
        double X = data.getDouble();
        double Y = data.getDouble();
        if (haveZ) {
            double Z = data.getDouble();
            result = this.jtsFactory.getGeometryFactory().createPoint(new Coordinate(X, Y, Z));
        } else {
            result = this.jtsFactory.getGeometryFactory().createPoint(new Coordinate(X, Y));
        }
        if (haveM) {
            data.getDouble();
        }
        return result;
    }

    private void parseGeometryArray(ValueGetter data, Geometry[] container, int srid) {
        for (int i = 0; i < container.length; ++i) {
            container[i] = this.parseGeometry(data, srid, true);
        }
    }

    private CoordinateSequence parseCS(ValueGetter data, boolean haveZ, boolean haveM) {
        int count = data.getInt();
        int dims = haveZ ? 3 : 2;
        PackedCoordinateSequence.Double cs = new PackedCoordinateSequence.Double(count, dims, 0);
        for (int i = 0; i < count; ++i) {
            for (int d = 0; d < dims; ++d) {
                cs.setOrdinate(i, d, data.getDouble());
            }
            if (!haveM) continue;
            data.getDouble();
        }
        return cs;
    }

    private MultiPoint parseMultiPoint(ValueGetter data, int srid) {
        Point[] points = new Point[data.getInt()];
        this.parseGeometryArray(data, (Geometry[])points, srid);
        return this.jtsFactory.getGeometryFactory().createMultiPoint(points);
    }

    private LineString parseLineString(ValueGetter data, boolean haveZ, boolean haveM) {
        return this.jtsFactory.getGeometryFactory().createLineString(this.parseCS(data, haveZ, haveM));
    }

    private LinearRing parseLinearRing(ValueGetter data, boolean haveZ, boolean haveM) {
        return this.jtsFactory.getGeometryFactory().createLinearRing(this.parseCS(data, haveZ, haveM));
    }

    private Polygon parsePolygon(ValueGetter data, boolean haveZ, boolean haveM, int srid) {
        int count = data.getInt();
        if (count == 0) {
            return this.jtsFactory.getGeometryFactory().createPolygon();
        }
        LinearRing shell = this.parseLinearRing(data, haveZ, haveM);
        shell.setSRID(srid);
        int holeCount = count - 1;
        LinearRing[] rings = new LinearRing[holeCount];
        for (int i = 0; i < holeCount; ++i) {
            rings[i] = this.parseLinearRing(data, haveZ, haveM);
            rings[i].setSRID(srid);
        }
        return this.jtsFactory.getGeometryFactory().createPolygon(shell, rings);
    }

    private MultiLineString parseMultiLineString(ValueGetter data, int srid) {
        int count = data.getInt();
        LineString[] strings = new LineString[count];
        this.parseGeometryArray(data, (Geometry[])strings, srid);
        return this.jtsFactory.getGeometryFactory().createMultiLineString(strings);
    }

    private MultiPolygon parseMultiPolygon(ValueGetter data, int srid) {
        int count = data.getInt();
        Polygon[] polys = new Polygon[count];
        this.parseGeometryArray(data, (Geometry[])polys, srid);
        return this.jtsFactory.getGeometryFactory().createMultiPolygon(polys);
    }

    private GeometryCollection parseCollection(ValueGetter data, int srid) {
        int count = data.getInt();
        Geometry[] geoms = new Geometry[count];
        this.parseGeometryArray(data, geoms, srid);
        return this.jtsFactory.getGeometryFactory().createGeometryCollection(geoms);
    }
}

