/*
 * Decompiled with CFR 0.152.
 */
package net.postgis.jdbc.jts;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import net.postgis.jdbc.PGbox2d;
import net.postgis.jdbc.PGbox3d;
import net.postgis.jdbc.jts.JtsGeometry;
import org.postgresql.Driver;
import org.postgresql.PGConnection;

public class JtsGisWrapper
extends Driver {
    private static final String POSTGRES_PROTOCOL = "jdbc:postgresql:";
    private static final String POSTGIS_PROTOCOL = "jdbc:postgresql_JTS:";
    public static final String REVISION = "$Revision$";

    public Connection connect(String url, Properties info) throws SQLException {
        url = JtsGisWrapper.mangleURL(url);
        Connection result = super.connect(url, info);
        JtsGisWrapper.addGISTypes((PGConnection)result);
        return result;
    }

    public static void addGISTypes(PGConnection pgconn) throws SQLException {
        pgconn.addDataType("geometry", JtsGeometry.class);
        pgconn.addDataType("box3d", PGbox3d.class);
        pgconn.addDataType("box2d", PGbox2d.class);
    }

    public static String mangleURL(String url) {
        return url.startsWith(POSTGIS_PROTOCOL) ? POSTGRES_PROTOCOL + url.substring(POSTGIS_PROTOCOL.length()) : null;
    }

    public boolean acceptsURL(String url) {
        return (url = JtsGisWrapper.mangleURL(url)) != null && super.acceptsURL(url);
    }

    public int getMajorVersion() {
        return super.getMajorVersion();
    }

    public int getMinorVersion() {
        return super.getMinorVersion();
    }

    public static String getVersion() {
        return "JtsGisWrapper $Revision$, wrapping " + Driver.getVersion();
    }

    static {
        try {
            DriverManager.registerDriver((java.sql.Driver)((Object)new JtsGisWrapper()));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

