/*
 * Decompiled with CFR 0.152.
 */
package net.postgis.jdbc.jts;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.postgis.jdbc.jts.JtsGeometry;
import org.postgresql.Driver;
import org.postgresql.PGConnection;

public class JtsWrapper
extends Driver {
    protected static final Logger logger = Logger.getLogger("net.postgis.jdbc.DriverWrapper");
    private static final String POSTGRES_PROTOCOL = "jdbc:postgresql:";
    private static final String POSTGIS_PROTOCOL = "jdbc:postgres_jts:";
    public static final String REVISION = "$Revision$";

    public Connection connect(String url, Properties info) throws SQLException {
        url = JtsWrapper.mangleURL(url);
        Connection result = super.connect(url, info);
        JtsWrapper.addGISTypes((PGConnection)result);
        return result;
    }

    public static void addGISTypes(PGConnection pgconn) throws SQLException {
        pgconn.addDataType("geometry", JtsGeometry.class);
    }

    public static String mangleURL(String url) {
        return url.startsWith(POSTGIS_PROTOCOL) ? POSTGRES_PROTOCOL + url.substring(POSTGIS_PROTOCOL.length()) : null;
    }

    public boolean acceptsURL(String url) {
        return (url = JtsWrapper.mangleURL(url)) != null && super.acceptsURL(url);
    }

    public int getMajorVersion() {
        return super.getMajorVersion();
    }

    public int getMinorVersion() {
        return super.getMinorVersion();
    }

    public static String getVersion() {
        return "JtsGisWrapper $Revision$, wrapping " + Driver.getVersion();
    }

    static {
        try {
            DriverManager.registerDriver((java.sql.Driver)((Object)new JtsWrapper()));
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, "Error registering PostgreSQL Jts Wrapper Driver", e);
        }
    }
}

