/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.postgis.PGbox2d;
import org.postgis.PGbox3d;
import org.postgis.PGgeometry;
import org.postgis.PGgeometryLW;
import org.postgresql.Driver;
import org.postgresql.PGConnection;

public class DriverWrapper
extends Driver {
    protected static final Logger logger = Logger.getLogger("org.postgis.DriverWrapper");
    public static final String POSTGRES_PROTOCOL = "jdbc:postgresql:";
    public static final String POSTGIS_PROTOCOL = "jdbc:postgresql_postGIS:";
    public static final String REVISION = "$Revision$";
    protected static TypesAdder ta72 = null;
    protected static TypesAdder ta74 = null;
    protected static TypesAdder ta80 = null;
    protected TypesAdder typesAdder = DriverWrapper.getTypesAdder(this);

    public DriverWrapper() throws SQLException {
        if (super.getMajorVersion() > 8 || super.getMinorVersion() > 1) {
            logger.fine(((Object)((Object)this)).getClass().getName() + " loaded TypesAdder: " + this.typesAdder.getClass().getName());
        }
    }

    protected static TypesAdder getTypesAdder(Driver d) throws SQLException {
        if (d.getMajorVersion() == 7) {
            if (d.getMinorVersion() >= 3) {
                if (ta74 == null) {
                    ta74 = DriverWrapper.loadTypesAdder("74");
                }
                return ta74;
            }
            if (ta72 == null) {
                ta72 = DriverWrapper.loadTypesAdder("72");
            }
            return ta72;
        }
        if (ta80 == null) {
            ta80 = DriverWrapper.loadTypesAdder("80");
        }
        return ta80;
    }

    private static TypesAdder loadTypesAdder(String version) throws SQLException {
        try {
            Class<?> klass = Class.forName("org.postgis.DriverWrapper$TypesAdder" + version);
            return (TypesAdder)klass.newInstance();
        }
        catch (Exception e) {
            throw new SQLException("Cannot create TypesAdder instance! " + e.getMessage());
        }
    }

    public Connection connect(String url, Properties info) throws SQLException {
        url = this.mangleURL(url);
        Connection result = super.connect(url, info);
        this.typesAdder.addGT(result, this.useLW(result));
        return result;
    }

    protected boolean useLW(Connection result) {
        if (result == null) {
            throw new IllegalArgumentException("null is no valid parameter");
        }
        return false;
    }

    public boolean acceptsURL(String url) {
        try {
            url = this.mangleURL(url);
        }
        catch (SQLException e) {
            return false;
        }
        return super.acceptsURL(url);
    }

    public static String getVersion() {
        return "PostGisWrapper $Revision$, wrapping " + Driver.getVersion();
    }

    public static void addGISTypes(PGConnection pgconn) throws SQLException {
        DriverWrapper.loadTypesAdder("74").addGT((Connection)pgconn, false);
    }

    public static void addGISTypes80(PGConnection pgconn) throws SQLException {
        DriverWrapper.loadTypesAdder("80").addGT((Connection)pgconn, false);
    }

    public static void addGISTypes72(PGConnection pgconn) throws SQLException {
        DriverWrapper.loadTypesAdder("72").addGT((Connection)pgconn, false);
    }

    protected String mangleURL(String url) throws SQLException {
        String myProgo = this.getProtoString();
        if (url.startsWith(myProgo)) {
            return POSTGRES_PROTOCOL + url.substring(myProgo.length());
        }
        throw new SQLException("Unknown protocol or subprotocol in url " + url);
    }

    protected String getProtoString() {
        return POSTGIS_PROTOCOL;
    }

    public Logger getParentLogger() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        try {
            DriverManager.registerDriver((java.sql.Driver)((Object)new DriverWrapper()));
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, "Error registering PostGIS Wrapper Driver", e);
        }
    }

    protected static class TypesAdder80
    extends TypesAdder {
        protected TypesAdder80() {
        }

        @Override
        public void addGeometries(Connection conn) throws SQLException {
            PGConnection pgconn = (PGConnection)conn;
            pgconn.addDataType("geometry", PGgeometry.class);
            pgconn.addDataType("public.geometry", PGgeometry.class);
            pgconn.addDataType("\"public\".\"geometry\"", PGgeometry.class);
        }

        @Override
        public void addBoxen(Connection conn) throws SQLException {
            PGConnection pgconn = (PGConnection)conn;
            pgconn.addDataType("box3d", PGbox3d.class);
            pgconn.addDataType("box2d", PGbox2d.class);
        }

        @Override
        public void addBinaryGeometries(Connection conn) throws SQLException {
            PGConnection pgconn = (PGConnection)conn;
            pgconn.addDataType("geometry", PGgeometryLW.class);
        }
    }

    protected static class TypesAdder72
    extends TypesAdder {
        protected TypesAdder72() {
        }

        @Override
        public void addGeometries(Connection conn) throws SQLException {
            PGConnection pgconn = (PGConnection)conn;
            pgconn.addDataType("geometry", PGgeometry.class);
            pgconn.addDataType("public.geometry", PGgeometry.class);
            pgconn.addDataType("\"public\".\"geometry\"", PGgeometry.class);
        }

        @Override
        public void addBoxen(Connection conn) throws SQLException {
            PGConnection pgconn = (PGConnection)conn;
            pgconn.addDataType("box3d", PGbox3d.class);
            pgconn.addDataType("box2d", PGbox2d.class);
        }

        @Override
        public void addBinaryGeometries(Connection conn) throws SQLException {
            PGConnection pgconn = (PGConnection)conn;
            pgconn.addDataType("geometry", PGgeometryLW.class);
        }
    }

    protected static final class TypesAdder74
    extends TypesAdder {
        protected TypesAdder74() {
        }

        @Override
        public void addGeometries(Connection conn) throws SQLException {
            PGConnection pgconn = (PGConnection)conn;
            pgconn.addDataType("geometry", PGgeometry.class);
            pgconn.addDataType("public.geometry", PGgeometry.class);
            pgconn.addDataType("\"public\".\"geometry\"", PGgeometry.class);
        }

        @Override
        public void addBoxen(Connection conn) throws SQLException {
            PGConnection pgconn = (PGConnection)conn;
            pgconn.addDataType("box3d", PGbox3d.class);
            pgconn.addDataType("box2d", PGbox2d.class);
        }

        @Override
        public void addBinaryGeometries(Connection conn) throws SQLException {
            PGConnection pgconn = (PGConnection)conn;
            pgconn.addDataType("geometry", PGgeometryLW.class);
        }
    }

    protected static abstract class TypesAdder {
        protected TypesAdder() {
        }

        public final void addGT(Connection conn, boolean lw) throws SQLException {
            if (lw) {
                this.addBinaryGeometries(conn);
            } else {
                this.addGeometries(conn);
            }
            this.addBoxen(conn);
        }

        public abstract void addGeometries(Connection var1) throws SQLException;

        public abstract void addBoxen(Connection var1) throws SQLException;

        public abstract void addBinaryGeometries(Connection var1) throws SQLException;
    }
}

