/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.cli;

import java.io.File;
import net.praqma.cli.CLI;
import net.praqma.util.execute.AbnormalProcessTerminationException;
import net.praqma.util.execute.CmdResult;
import net.praqma.util.execute.CommandLine;
import net.praqma.util.option.Option;
import net.praqma.util.option.Options;

public class Run
extends CLI {
    public static void main(String[] args) throws Exception {
        Run s = new Run();
        s.perform(args);
    }

    public void perform(String[] args) throws Exception {
        Options o = new Options("1.0");
        Option ocommand = new Option("command", "c", true, -1, "The command to be executed");
        Option opath = new Option("path", "p", false, -1, "The path where the command is executed");
        Option omerge = new Option("merge", "m", false, 0, "If set error out is merged with standard out");
        o.setOption(ocommand);
        o.setOption(opath);
        o.setOption(omerge);
        o.setDefaultOptions();
        o.setSyntax("Run -c dir");
        o.setDescription("Execute a command through Java");
        o.parse(args);
        try {
            o.checkOptions();
        }
        catch (Exception e) {
            System.err.println("Incorrect option: " + e.getMessage());
            o.display();
            System.exit(1);
        }
        CommandLine cli = CommandLine.getInstance();
        if (o.isVerbose()) {
            System.out.println("Command: " + ocommand.getString(true));
            if (opath.isUsed()) {
                System.out.println("Path: " + opath.getString(true));
            }
        }
        try {
            CmdResult r = cli.run(ocommand.getString(true), opath.isUsed() ? new File(opath.getString(true)) : null, omerge.isUsed());
            System.out.println(r.stdoutBuffer);
        }
        catch (AbnormalProcessTerminationException e) {
            System.out.println(e.getMessage());
        }
    }
}

