/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import net.praqma.logging.PraqmaticLogFormatter;
import net.praqma.logging.PraqmaticLogHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingUtil {
    private LoggingUtil() {
    }

    public static void changeLoggerFormat() {
        LoggingUtil.changeLoggerFormat(Logger.getLogger(""), new PraqmaticLogFormatter());
    }

    public static void changeLoggerFormat(Formatter formatter) {
        LoggingUtil.changeLoggerFormat(Logger.getLogger(""), formatter);
    }

    public static void changeLoggerFormat(Logger logger, Formatter formatter) {
        for (Handler h : logger.getHandlers()) {
            h.setFormatter(formatter);
        }
    }

    public static void addOutput(OutputStream output, Formatter formatter) {
        LoggingUtil.addOutput(Logger.getLogger(""), output, formatter);
    }

    public static void addOutput(Logger logger, OutputStream output, Formatter formatter) {
        StreamHandler handler = new StreamHandler(output, formatter);
        logger.addHandler(handler);
    }

    public static void changeLoggerLevel(Level level) {
        LoggingUtil.changeLoggerLevel(Logger.getLogger(""), level);
    }

    public static void changeLoggerLevel(Logger logger, Level level) {
        logger.setLevel(level);
        for (Handler h : logger.getHandlers()) {
            h.setLevel(level);
        }
    }

    public static void setPraqmaticHandler(Level level, String ... names) {
        LoggingUtil.setPraqmaticHandler(level, Arrays.asList(names));
    }

    public static void setPraqmaticHandler(Level level, List<String> names) {
        LoggingUtil.setPraqmaticHandler(level, names, "{3,date,HH:mm:ss} [{1}]{5} {6}.{7}, {19}: {4} \n{8}");
    }

    public static void setPraqmaticHandler(Level level, List<String> names, String format) {
        LoggingUtil.removeRootHandlers();
        PraqmaticLogHandler h = new PraqmaticLogHandler(System.out, new PraqmaticLogFormatter(format));
        h.addTargets(level, names);
        h.setLevel(Level.ALL);
    }

    public static void setPraqmaticHandler(Level level, List<String> names, File outputFile) throws FileNotFoundException {
        LoggingUtil.removeRootHandlers();
        FileOutputStream out = new FileOutputStream(outputFile);
        PraqmaticLogHandler h = new PraqmaticLogHandler(out, new PraqmaticLogFormatter());
        h.addTargets(level, names);
        h.setLevel(Level.ALL);
    }

    public static void removeRootHandlers() {
        LoggingUtil.removeHandlers(Logger.getLogger(""));
    }

    public static void removeHandlers(Logger logger) {
        for (Handler h : logger.getHandlers()) {
            logger.removeHandler(h);
            h.close();
        }
    }

    public static void setHandler(Handler handler) {
        LoggingUtil.setHandler(Logger.getLogger(""), handler);
    }

    public static void setHandler(Logger logger, Handler handler) {
        logger.addHandler(handler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LoggerNameFilter
    implements Filter {
        private List<String> names = new LinkedList<String>();

        public LoggerNameFilter() {
        }

        public LoggerNameFilter(Collection<String> c) {
            this.names.addAll(c);
        }

        public LoggerNameFilter add(String name) {
            this.names.add(name);
            return this;
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            System.out.println("YAY");
            return this.names.contains(record.getLoggerName());
        }

        public String toString() {
            return "Names " + this.names;
        }
    }
}

