/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.logging;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import net.praqma.logging.LoggerTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PraqmaticLogHandler
extends StreamHandler {
    private int threadId;
    private Set<LoggerTarget> targets = new HashSet<LoggerTarget>();
    private OutputStream out;

    public PraqmaticLogHandler(OutputStream fos, Formatter formatter) {
        super(fos, formatter);
        this.out = fos;
        this.threadId = (int)Thread.currentThread().getId();
        this.out = new PrintStream(fos, true);
    }

    public OutputStream getOut() {
        return this.out;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public void addTarget(LoggerTarget target) {
        this.targets.add(target);
        Logger logger = LogManager.getLogManager().getLogger(target.getName());
        if (logger != null) {
            logger.setLevel(Level.ALL);
            logger.setUseParentHandlers(false);
            logger.addHandler(this);
        } else {
            Logger nlogger = Logger.getLogger(target.getName());
            nlogger.setLevel(Level.ALL);
            nlogger.setUseParentHandlers(false);
            nlogger.addHandler(this);
        }
    }

    public void addTargets(List<LoggerTarget> targets) {
        for (LoggerTarget t : targets) {
            this.addTarget(t);
        }
    }

    public void addTargets(Level level, List<String> targets) {
        for (String t : targets) {
            this.addTarget(new LoggerTarget(t, level));
        }
    }

    public void removeTargets() {
        for (LoggerTarget t : this.targets) {
            Logger logger = LogManager.getLogManager().getLogger(t.getName());
            if (logger != null) {
                logger.removeHandler(this);
                continue;
            }
            Logger nlogger = Logger.getLogger(t.getName());
            nlogger.removeHandler(this);
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        if ((long)this.threadId == Thread.currentThread().getId() && this.checkTargets(logRecord)) {
            super.publish(logRecord);
        }
    }

    private boolean checkTargets(LogRecord lr) {
        for (LoggerTarget target : this.targets) {
            if (!this.checkTarget(target, lr)) continue;
            return true;
        }
        return false;
    }

    private boolean checkTarget(LoggerTarget target, LogRecord lr) {
        if (lr.getLevel().intValue() < target.getLogLevel()) {
            return false;
        }
        if (target.getName() == null || !lr.getLoggerName().startsWith(target.getName())) {
            return false;
        }
        String rest = lr.getLoggerName().substring(target.getName().length());
        return rest.length() == 0 || rest.startsWith(".");
    }
}

