/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExceptionUtils {
    public static void print(Throwable e, PrintStream out, boolean stack) {
        if (e.getCause() != null) {
            out.println(e.getMessage());
            ExceptionUtils.print(e.getCause(), out, stack);
        } else if (stack) {
            e.printStackTrace(out);
        } else {
            out.println(e.getMessage());
        }
    }

    public static Throwable unpackBottom(Class<? extends Throwable> end, Throwable throwable) {
        Throwable current;
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        while (throwable != null) {
            throwables.add(throwable);
            throwable = throwable.getCause();
        }
        ListIterator it = throwables.listIterator(throwables.size());
        Throwable previous = null;
        while (it.hasPrevious() && (!(current = (Throwable)it.previous()).getClass().isAssignableFrom(end) || previous == null)) {
            previous = current;
        }
        return previous;
    }

    public static Throwable unpackFrom(Class<? extends Throwable> from, Throwable throwable) {
        Throwable origin = throwable;
        while (throwable != null) {
            if (throwable.getClass().isAssignableFrom(from)) {
                Throwable child = throwable.getCause();
                if (child != null) {
                    return child;
                }
                return throwable;
            }
            throwable = throwable.getCause();
        }
        return origin;
    }

    public static Throwable unpack(Class<? extends Throwable> parentClass, Throwable throwable) {
        if (!throwable.getClass().isAssignableFrom(parentClass)) {
            return throwable;
        }
        Throwable cause = throwable.getCause();
        if (cause == null) {
            return throwable;
        }
        return ExceptionUtils.unpack(parentClass, cause);
    }

    public static Throwable getCause(Class<? extends Throwable> target, Throwable throwable) {
        while (throwable != null) {
            if (throwable.getClass().isAssignableFrom(target)) {
                return throwable;
            }
            throwable = throwable.getCause();
        }
        return null;
    }
}

