/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.util;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageUtils {
    public static List<Class<?>> getClasses(String packageName, String regexFilter) throws Exception {
        Pattern regex = null;
        if (regexFilter != null) {
            regex = Pattern.compile(regexFilter);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<String> dirs = new ArrayList<String>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(resource.getFile());
        }
        TreeSet<String> classes = new TreeSet<String>();
        for (String directory : dirs) {
            classes.addAll(PackageUtils.findClasses(directory, packageName, regex));
        }
        ArrayList classList = new ArrayList();
        for (String clazz : classes) {
            classList.add(Class.forName(clazz));
        }
        return classList;
    }

    public static TreeSet<String> findClasses(String path, String packageName, Pattern regex) throws Exception {
        File[] files;
        File dir;
        TreeSet<String> classes = new TreeSet<String>();
        if (path.startsWith("file:") && path.contains("!")) {
            ZipEntry entry;
            String[] split = path.split("!");
            URL jar = new URL(split[0]);
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            while ((entry = zip.getNextEntry()) != null) {
                String className;
                if (!entry.getName().endsWith(".class") || !(className = entry.getName().replaceAll("[$].*", "").replaceAll("[.]class", "").replace('/', '.')).startsWith(packageName) || regex != null && !regex.matcher(className).matches()) continue;
                classes.add(className);
            }
        }
        if (!(dir = new File(path)).exists()) {
            return classes;
        }
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(PackageUtils.findClasses(file.getAbsolutePath(), packageName + "." + file.getName(), regex));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = packageName + '.' + file.getName().substring(0, file.getName().length() - 6);
            if (regex != null && !regex.matcher(className).matches()) continue;
            classes.add(className);
        }
        return classes;
    }
}

