/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.util;

import java.util.LinkedList;
import java.util.List;

public class StopWatch {
    private static final String SEP = System.getProperty("line.separator");
    public static final long PRECISION_SECOND = 1L;
    public static final long PRECISION_MILLI = 1000L;
    public static final long PRECISION_MICRO = 1000000L;
    public static final long PRECISION_NANO = 1000000000L;
    private List<Task> tasks = new LinkedList<Task>();
    private Task currentTask;
    private long initial = System.nanoTime();
    private long startTime = 0L;
    private long endTime = 0L;
    private long totalTime = 0L;
    private static final int MAX_TITLE_LENGTH = 32;
    private static final int MAX_PERCENTAGE_LENGTH = 10;
    private static final int MAX_TIME_LENGTH = 10;

    public void start() {
        this.start("N/A");
    }

    public void start(String title) {
        this.startTime = System.nanoTime();
        this.currentTask = new Task(title);
    }

    long getStartTime() {
        return this.startTime;
    }

    long getEndTime() {
        return this.endTime;
    }

    public void stop() {
        if (this.currentTask != null) {
            this.endTime = System.nanoTime();
            this.currentTask.nano = this.endTime - this.startTime;
            this.totalTime += this.currentTask.nano;
        } else {
            throw new IllegalStateException("No current tasks. Stop watch could have been stopped twice?");
        }
        this.tasks.add(this.currentTask);
        this.currentTask = null;
    }

    public long getTime() {
        this.endTime = System.nanoTime();
        return this.endTime - this.startTime + this.totalTime;
    }

    public long getCurrentTime() {
        return this.endTime - this.startTime;
    }

    public String print(long precision) {
        StringBuilder sb = new StringBuilder();
        long now = System.nanoTime();
        long full = now - this.initial;
        System.out.println("NOW: " + now + ", INITIAL: " + this.initial + " = " + (now - this.initial) / 1000000000L);
        if (this.tasks.size() > 0) {
            long total = 0L;
            for (Task t : this.tasks) {
                total += t.nano;
            }
            sb.append(" Title                           %          Seconds" + SEP);
            sb.append("-" + this.repeat(52, 0, "-") + SEP);
            for (Task t : this.tasks) {
                Double p = (double)Math.round((double)t.nano / (double)total * 10000.0) / 100.0;
                sb.append(" " + t.title + this.spaces(32, t.title.length()) + p + "%" + this.spaces(10, (p + "").length()) + StopWatch.toSeconds(t.nano, precision) + SEP);
            }
            sb.append("-" + this.repeat(52, 0, "-") + SEP);
        }
        sb.append("Total time. Overall:" + StopWatch.toSeconds(full, precision) + "s. Aggregated: " + StopWatch.toSeconds(this.totalTime, precision));
        return sb.toString();
    }

    private String spaces(int max, int length) {
        return this.repeat(max, length, " ");
    }

    private String repeat(int max, int length, String chr) {
        return new String(new char[max - length]).replace("\u0000", chr);
    }

    public void reset() {
        this.initial = System.nanoTime();
        this.startTime = 0L;
        this.endTime = 0L;
        this.totalTime = 0L;
        this.tasks = new LinkedList<Task>();
    }

    public double getSeconds() {
        return (double)this.totalTime / 1.0E9;
    }

    public static double toSeconds(long time, long precision) {
        return (double)Math.round((double)time / 1.0E9 * (double)precision) / (double)precision;
    }

    public String toString() {
        return this.startTime + " -> " + this.endTime + " = " + (this.endTime - this.startTime);
    }

    private class Task {
        long nano;
        String title;

        public Task(String title) {
            this.title = title;
        }
    }
}

