/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.util.debug;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import net.praqma.util.debug.LoggerSetting;
import net.praqma.util.debug.appenders.Appender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logger {
    private static final int levelMaxlength = 8;
    private static final String filesep = System.getProperty("file.separator");
    public static final String linesep = System.getProperty("line.separator");
    private static Logger instance = null;
    private static SimpleDateFormat datetimeformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat timeformat = new SimpleDateFormat("HH:mm:ss");
    private static SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd");
    private static List<Appender> appenders = new CopyOnWriteArrayList<Appender>();
    private static boolean enabled = true;
    private static LogLevel minLogLevel = LogLevel.DEBUG;

    private Logger() {
    }

    public static Logger getLogger() {
        if (instance == null) {
            instance = new Logger();
        }
        return instance;
    }

    public static void addAppender(Appender appender) {
        appenders.add(appender);
    }

    public static void removeAppender(Appender appender) {
        if (appender != null) {
            appenders.remove(appender);
            appender.getOut().close();
        }
    }

    public static void enable() {
        enabled = true;
    }

    public static void disable() {
        enabled = false;
    }

    public static void setMinLogLevel(LogLevel level) {
        minLogLevel = level;
    }

    public static LogLevel getMinLogLevel() {
        return minLogLevel;
    }

    public String objectToString(Object t) {
        if (t instanceof Throwable) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ((Throwable)t).printStackTrace(pw);
            return ((Object)sw).toString();
        }
        return String.valueOf(t);
    }

    public void log(Object message) {
        this.log(message, LogLevel.INFO, null, 3);
    }

    public void log(Object message, String tag) {
        this.log(message, LogLevel.INFO, tag, 3);
    }

    public void debug(Object message) {
        this.log(message, LogLevel.DEBUG, null, 3);
    }

    public void debug(Object message, String tag) {
        this.log(message, LogLevel.DEBUG, tag, 3);
    }

    public void verbose(Object message) {
        this.log(message, LogLevel.VERBOSE, null, 3);
    }

    public void verbose(Object message, String tag) {
        this.log(message, LogLevel.VERBOSE, tag, 3);
    }

    public void info(Object message) {
        this.log(message, LogLevel.INFO, null, 3);
    }

    public void info(Object message, String tag) {
        this.log(message, LogLevel.INFO, tag, 3);
    }

    public void warning(Object message) {
        this.log(message, LogLevel.WARNING, null, 3);
    }

    public void warning(Object message, String tag) {
        this.log(message, LogLevel.WARNING, tag, 3);
    }

    public void error(Object message) {
        this.log(message, LogLevel.ERROR, null, 3);
    }

    public void error(Object message, String tag) {
        this.log(message, LogLevel.ERROR, tag, 3);
    }

    public void fatal(Object message) {
        this.log(message, LogLevel.FATAL, null, 3);
    }

    public void fatal(Object message, String tag) {
        this.log(message, LogLevel.FATAL, tag, 3);
    }

    public void log(Object message, LogLevel level) {
        this.log(message, level, null, 3);
    }

    public void log(Object message, LogLevel level, String tag) {
        this.log(message, level, tag, 3);
    }

    private String parseTemplate(Map<String, String> keywords, String template) {
        Set<String> keys = keywords.keySet();
        for (String key : keys) {
            try {
                template = template.replaceAll(key, keywords.get(key));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return template;
    }

    public void redirect(InputStream input) {
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        String line = "";
        try {
            while ((line = in.readLine()) != null) {
                this.writeAppenders(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Set<String> getSubscriptions() {
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        for (Appender a : appenders) {
            all.addAll(a.getSubscriptions());
        }
        return all;
    }

    public static LoggerSetting getLoggerSettings(LogLevel level) {
        LoggerSetting settings = new LoggerSetting();
        settings.setSubscriptions(Logger.getSubscriptions());
        settings.setMinimumLevel(level);
        return settings;
    }

    public static int getNumberOfAppenders() {
        return appenders.size();
    }

    private void writeAppenders(String message) {
        for (Appender a : appenders) {
            a.getOut().write(message + linesep);
            a.getOut().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void log(Object message, LogLevel level, String tag, int depth) {
        if (enabled && level.compareTo(minLogLevel) >= 0) {
            Date now = new Date();
            HashMap<String, String> keywords = new HashMap<String, String>();
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            keywords.put("%class", stack[depth].getClassName());
            keywords.put("%threadid", "[" + Thread.currentThread().getId() + "]");
            keywords.put("%threadname", Thread.currentThread().getName());
            keywords.put("%thread", "[(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + "]");
            keywords.put("%method", stack[depth].getMethodName());
            String subscribable = stack[depth].getClassName() + "." + stack[depth].getMethodName();
            keywords.put("%stack", Matcher.quoteReplacement(stack[depth].getClassName() + "::" + stack[depth].getMethodName() + "," + stack[depth].getLineNumber()));
            try {
                keywords.put("%caller", Matcher.quoteReplacement(stack[depth + 1].getClassName() + "::" + stack[depth + 1].getMethodName() + "," + stack[depth + 1].getLineNumber()));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            keywords.put("%line", stack[depth].getLineNumber() + "");
            keywords.put("%datetime", datetimeformat.format(now));
            keywords.put("%date", dateformat.format(now));
            keywords.put("%time", timeformat.format(now));
            if (level != null) {
                keywords.put("%level", level.toString());
                keywords.put("%space", new String(new char[8 - level.toString().length()]).replace("\u0000", " "));
            }
            keywords.put("%message", Matcher.quoteReplacement(this.objectToString(message)));
            keywords.put("%newline", "\n");
            if (tag != null) {
                keywords.put("%tag", tag);
            } else {
                keywords.put("%tag", "");
            }
            for (Appender a : appenders) {
                if (!a.isEnabled() || a.getMinimumLevel().ordinal() > level.ordinal() || a.getTag() != null && (tag == null || !tag.equals(a.getTag()))) continue;
                if (a.getTag() != null) {
                    System.out.println(a.getTag() + "=" + tag);
                }
                if (!a.isSubscribeAll() && !a.isSubscribed(subscribable) || a.getThreadId() != null && !a.getThreadId().equals(Logger.getThreadId(Thread.currentThread()))) continue;
                String finalmsg = this.parseTemplate(keywords, a.getTemplate());
                if (!a.onBeforeLogging()) continue;
                PrintWriter printWriter = a.getOut();
                synchronized (printWriter) {
                    a.getOut().write(finalmsg);
                    a.getOut().flush();
                }
            }
        }
    }

    public static String getThreadId(Thread t) {
        return t.getId() + "::" + t.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LogLevel {
        DEBUG,
        VERBOSE,
        INFO,
        WARNING,
        ERROR,
        FATAL;

    }
}

