/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.util.debug;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.praqma.util.structure.Printer;

public class PraqmaLogger {
    private static PraqmaLogger plogger = null;
    private static FileWriter fw = null;
    private static PrintWriter out = null;
    private static String path = "./";
    private static SimpleDateFormat format = null;
    private static SimpleDateFormat logformat = null;
    private static Calendar nowDate = null;
    private static File file = null;
    private static boolean enabled = true;
    private static boolean traceEnabled = false;
    private static final String filesep = System.getProperty("file.separator");
    private static final String linesep = System.getProperty("line.separator");
    private static ArrayList<String> trace = null;
    private static boolean append = false;
    private static final int typemaxlength = 8;
    private static final int methodmaxlength = 55;
    private static final boolean indent = false;
    private boolean toStdOut = false;
    private static List<String> exclude = new ArrayList<String>();
    private static List<String> include = new ArrayList<String>();
    private boolean all = false;

    private PraqmaLogger(boolean append, boolean homePath) {
        PraqmaLogger.append = append;
        nowDate = Calendar.getInstance();
        format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        logformat = new SimpleDateFormat("yyyyMMdd");
        trace = new ArrayList();
        if (homePath) {
            this.setPathHomeLogs();
        } else {
            PraqmaLogger.newDate(nowDate);
        }
        if (System.getProperty("tostdout") != null) {
            this.toStdOut = true;
        }
        PraqmaLogger.addSubscriptions();
    }

    public static Logger getLogger(boolean append, boolean homePath) {
        if (plogger == null) {
            plogger = new PraqmaLogger(append, homePath);
        }
        return new Logger(plogger);
    }

    public static Logger getLogger(boolean append) {
        if (plogger == null) {
            plogger = new PraqmaLogger(append, true);
        }
        return new Logger(plogger);
    }

    public static Logger getLogger() {
        if (plogger == null) {
            plogger = new PraqmaLogger(true, true);
        }
        return new Logger(plogger);
    }

    public static Logger getLogger(Logger l) {
        if (plogger == null) {
            plogger = new PraqmaLogger(true, true);
        }
        l.setLogger(plogger);
        return l;
    }

    public static boolean isIncluded(String name) {
        for (String s : include) {
            if (!name.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private static void addSubscriptions() {
        String includes = System.getenv("include_global_classes");
        if (includes != null) {
            String[] is;
            for (String i : is = includes.split(",")) {
                PraqmaLogger.subscribe(i);
            }
        }
    }

    public static void subscribe(String s) {
        if (!PraqmaLogger.isIncluded(s)) {
            include.add(s);
        }
    }

    public void setPath(String path) {
        PraqmaLogger.path = path;
        PraqmaLogger.newDate(nowDate);
    }

    public boolean setPathHomeLogs() {
        String path = System.getProperty("user.home") + filesep + "logs" + filesep;
        File file = new File(path);
        if (!file.exists()) {
            boolean created = false;
            try {
                created = file.mkdir();
            }
            catch (Exception e) {
                created = false;
            }
            if (!created) {
                return false;
            }
        }
        PraqmaLogger.path = path;
        PraqmaLogger.newDate(nowDate);
        return true;
    }

    private static Calendar getDate(Calendar c) {
        Calendar c2 = Calendar.getInstance();
        c2.clear();
        c2.set(c.get(1), c.get(2), c.get(5));
        return c2;
    }

    private static void newDate(Calendar n) {
        nowDate = n;
        if (fw != null) {
            try {
                fw.close();
                out.close();
            }
            catch (IOException e) {
                System.err.println("Could not close file writer and/or buffered writer.");
            }
        }
        try {
            file = new File(path + "debug_" + logformat.format(nowDate.getTime()) + ".log");
            fw = new FileWriter(file, append);
        }
        catch (IOException e) {
            try {
                file = new File("debug_" + logformat.format(nowDate.getTime()) + ".log");
                fw = new FileWriter(file, append);
            }
            catch (IOException e1) {
                System.err.println("Failed to use current working directory. Quitting!");
                System.exit(1);
            }
        }
        out = new PrintWriter(fw);
    }

    public String getPath() {
        return file.getAbsolutePath();
    }

    public String objectToString(Object t) {
        if (t instanceof Throwable) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ((Throwable)t).printStackTrace(pw);
            return ((Object)sw).toString();
        }
        return String.valueOf(t);
    }

    private String _log(Object msg, String type, Logger l, int size) {
        if (!l.enabled) {
            return null;
        }
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        String name = stack[size].getClassName();
        String myMsg = null;
        if (l.isIncluded(name) || PraqmaLogger.isIncluded(name) || l.all || this.all || this.toStdOut) {
            Calendar now = Calendar.getInstance();
            if (PraqmaLogger.getDate(now).after(PraqmaLogger.getDate(nowDate))) {
                PraqmaLogger.newDate(now);
            }
            if (type != null) {
                if (type.length() > 8) {
                    type = type.substring(0, 8);
                }
                String stackMsg = stack[size].getClassName() + "::" + stack[size].getMethodName() + "," + stack[size].getLineNumber();
                String msg_ = format.format(now.getTime()) + " [" + type + "] " + new String(new char[8 - type.length()]).replace("\u0000", " ") + stackMsg;
                myMsg = msg_ + ": " + this.objectToString(msg) + linesep;
            } else {
                myMsg = this.objectToString(msg) + linesep;
            }
            if (this.toStdOut) {
                System.out.print(myMsg);
            } else {
                out.write(myMsg);
                out.flush();
                if (l.getLocalLog() != null) {
                    l.getLocalLog().write(myMsg);
                    l.getLocalLog().flush();
                }
            }
        }
        return myMsg;
    }

    public static class Logger
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public List<String> exclude = new ArrayList<String>();
        public List<String> include = new ArrayList<String>();
        public boolean all = false;
        public boolean enabled = true;
        private transient PraqmaLogger logger = null;
        transient FileWriter fw = null;
        transient PrintWriter pwout = null;

        Logger(PraqmaLogger logger) {
            this.logger = logger;
            this.addSubscriptions();
        }

        public Logger() {
        }

        public void setLocalLog(File log) {
            try {
                this.fw = new FileWriter(log, true);
            }
            catch (Exception e1) {
                return;
            }
            this.pwout = new PrintWriter(this.fw);
        }

        public PrintWriter getLocalLog() {
            return this.pwout;
        }

        void setLogger(PraqmaLogger pl) {
            this.logger = pl;
        }

        public void subscribe(String s) {
            if (!this.isIncluded(s)) {
                this.include.add(s);
            }
        }

        public void subscribeAll() {
            this.all = true;
        }

        public void unsubscribeAll() {
            this.all = false;
            this.include.clear();
        }

        private void addSubscriptions() {
            String includes = System.getenv("include_classes");
            if (includes != null) {
                String[] is;
                for (String i : is = includes.split(",")) {
                    this.subscribe(i);
                }
            }
        }

        public boolean isExcluded(String name) {
            for (String s : this.exclude) {
                if (!name.startsWith(s)) continue;
                return true;
            }
            return false;
        }

        public boolean isIncluded(String name) {
            for (String s : this.include) {
                if (!name.startsWith(s)) continue;
                return true;
            }
            return false;
        }

        public void disable() {
            this.enabled = false;
        }

        public void enable() {
            this.enabled = true;
        }

        public void enableTrace() {
            traceEnabled = true;
        }

        public String getPath() {
            return this.logger.getPath();
        }

        public String toString() {
            return Printer.listPrinterToString(this.include);
        }

        public void print(Object msg) {
            System.out.println(msg);
        }

        public String log(Object msg) {
            return this.logger._log(msg, "info", this, 4);
        }

        public String debug(Object msg) {
            return this.logger._log(msg, "debug", this, 4);
        }

        public String info(Object msg) {
            return this.logger._log(msg, "info", this, 4);
        }

        public String warning(Object msg) {
            return this.logger._log(msg, "warning", this, 4);
        }

        public String exceptionWarning(Object msg) {
            return this.logger._log(msg, "warning", this, 5);
        }

        public String error(Object msg) {
            return this.logger._log(msg, "error", this, 4);
        }

        public String log(Object msg, String type) {
            return this.logger._log(msg, type, this, 4);
        }

        public String empty(Object msg) {
            return this.logger._log(msg, null, this, 4);
        }

        public void trace_function() {
        }
    }
}

