/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.util.debug.appenders;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashSet;
import java.util.Set;
import net.praqma.util.debug.Logger;
import net.praqma.util.debug.LoggerSetting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Appender {
    private Logger.LogLevel minimumLevel = Logger.LogLevel.INFO;
    protected PrintWriter out;
    private Set<String> subscriptions = new LinkedHashSet<String>();
    private boolean enabled = true;
    private boolean subscribeAll = true;
    private String threadId = null;
    protected String template = "%datetime %level %space %thread%stack %message%newline";
    private String tag;
    private Logger logger = Logger.getLogger();

    public Appender() {
    }

    public Appender(PrintWriter out) {
        this.setOut(out);
    }

    public Appender(PrintWriter out, Logger.LogLevel level) {
        this.setOut(out);
        this.minimumLevel = level;
    }

    public <T> void subscribe(Class<T> tclass) {
        if (!this.subscriptions.contains(tclass.getCanonicalName())) {
            this.subscriptions.add(tclass.getCanonicalName());
            this.subscribeAll = false;
        }
    }

    public void subscribe(String tclass) {
        if (!this.subscriptions.contains(tclass)) {
            this.subscriptions.add(tclass);
            this.subscribeAll = false;
        }
    }

    public void setSubscriptions(Set<String> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public void setSettings(LoggerSetting settings) {
        this.logger.debug("Setting, " + (Object)((Object)settings.getMinimumLevel()) + ": " + settings.getSubscriptions());
        this.minimumLevel = settings.getMinimumLevel();
        this.setSubscriptions(settings.getSubscriptions());
    }

    public boolean onBeforeLogging() {
        return true;
    }

    public Set<String> getSubscriptions() {
        return this.subscriptions;
    }

    public boolean isSubscribed(String str) {
        for (String s : this.subscriptions) {
            if (!s.startsWith(str)) continue;
            return true;
        }
        return false;
    }

    public Logger.LogLevel getMinimumLevel() {
        return this.minimumLevel;
    }

    public void setMinimumLevel(Logger.LogLevel minimumLevel) {
        this.minimumLevel = minimumLevel;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isSubscribeAll() {
        return this.subscribeAll;
    }

    public void setSubscribeAll(boolean subscribeAll) {
        this.subscribeAll = subscribeAll;
    }

    public PrintWriter getOut() {
        return this.out;
    }

    public void setOut(PrintWriter out) {
        this.out = out;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void lockToCurrentThread() {
        String tid;
        this.threadId = tid = Logger.getThreadId(Thread.currentThread());
    }

    public String getThreadId() {
        return this.threadId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(InputStream input) {
        if (!this.enabled) return;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            String line = "";
            try {
                while ((line = in.readLine()) != null) {
                    PrintWriter printWriter = this.getOut();
                    synchronized (printWriter) {
                        this.getOut().write(line + Logger.linesep);
                        this.getOut().flush();
                    }
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

