/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.util.debug.appenders;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import net.praqma.util.debug.appenders.Appender;

public class RollingFileAppender
extends Appender {
    public FileWriter fw;
    private File file;
    private File currentFile;
    private Calendar current;
    private SimpleDateFormat fileformat = new SimpleDateFormat("yyyyMMdd");

    public RollingFileAppender(File file) {
        this.file = file;
        this.current = Calendar.getInstance();
        this.current.setTimeInMillis(this.current.getTimeInMillis() - this.current.getTimeInMillis() % 86400L);
        this.initialize(this.current);
    }

    private void initialize(Calendar now) {
        now.setTimeInMillis(now.getTimeInMillis() - now.getTimeInMillis() % 86400L);
        if (now.after(this.current)) {
            File path = this.file.getParentFile();
            String f = this.file.getName();
            if (f.contains(".")) {
                String[] fs = f.split(".", 2);
                this.currentFile = new File(path, fs[0] + this.fileformat.format(now) + "." + fs[1]);
            } else {
                this.currentFile = new File(path, f + this.fileformat.format(now));
            }
        }
        try {
            this.fw = new FileWriter(this.currentFile, true);
        }
        catch (IOException e) {
            System.err.println("Could not create logger.!");
        }
        this.out = new PrintWriter(this.fw);
    }

    public boolean onBeforeLogging() {
        this.initialize(Calendar.getInstance());
        return true;
    }
}

