/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.util.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.praqma.util.debug.PraqmaLogger;

public class BuildNumberStamper {
    private File src = null;
    private File dst = null;
    private final Pattern rx_major_pattern = Pattern.compile("(\\s*)\".*\"(\\s*;*\\s*[\\/#]{2,2}\\s*buildnumber\\.major.*$)");
    private final Pattern rx_minor_pattern = Pattern.compile("(\\s*)\".*\"(\\s*;*\\s*[\\/#]{2,2}\\s*buildnumber\\.minor.*$)");
    private final Pattern rx_patch_pattern = Pattern.compile("(\\s*)\".*\"(\\s*;*\\s*[\\/#]{2,2}\\s*buildnumber\\.patch.*$)");
    private final Pattern rx_sequence_pattern = Pattern.compile("(\\s*)\".*\"(\\s*;*\\s*[\\/#]{2,2}\\s*buildnumber\\.sequence.*$)");
    private final Pattern rx_sequence_4lvl = Pattern.compile("(\\s*)\".*\"(\\s*;*\\s*[\\/#]{2,2}\\s*buildnumber\\.fourlevel.*$)");
    private final Pattern rx_alt_major_pattern = Pattern.compile("(\\s*)\\d+(\\s*;*\\s*[\\/#]{2,2}\\s*buildnumber\\.major.*$)");
    private final Pattern rx_alt_minor_pattern = Pattern.compile("(\\s*)\\d+(\\s*;*\\s*[\\/#]{2,2}\\s*buildnumber\\.minor.*$)");
    private final Pattern rx_alt_patch_pattern = Pattern.compile("(\\s*)\\d+(\\s*;*\\s*[\\/#]{2,2}\\s*buildnumber\\.patch.*$)");
    private final Pattern rx_alt_sequence_pattern = Pattern.compile("(\\s*)\\d+(\\s*;*\\s*[\\/#]{2,2}\\s*buildnumber\\.sequence.*$)");
    private final Pattern rx_maven_sequence_4lvl = Pattern.compile("^(\\s*)<version>.*</version>(\\s*)$");
    private static final PraqmaLogger.Logger logger = PraqmaLogger.getLogger();
    private static final String linesep = System.getProperty("line.separator");

    public BuildNumberStamper(File src) throws IOException {
        this.src = src;
        this.dst = File.createTempFile("praqma_", ".tmp");
    }

    public int stampIntoCode(String flvl) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.src), "UTF8"));
        FileWriter writer = new FileWriter(this.dst);
        String s = "";
        int number = 0;
        while ((s = reader.readLine()) != null) {
            if (flvl != null) {
                Matcher mm;
                Matcher m = this.rx_sequence_4lvl.matcher(s);
                if (m.find()) {
                    s = m.replaceFirst("$1\"" + flvl + "\"$2");
                    ++number;
                    logger.debug("flvl used");
                }
                if ((mm = this.rx_maven_sequence_4lvl.matcher(s)).find()) {
                    s = mm.replaceFirst("$1<version>" + flvl + "</version>$2");
                    ++number;
                    logger.debug("Maven flvl used");
                }
            }
            writer.write(s + linesep);
        }
        writer.close();
        reader.close();
        BuildNumberStamper.copyFile(this.dst, this.src);
        return number == 0 ? 0 : 1;
    }

    public int stampIntoCode(String major, String minor, String patch, String sequence) throws IOException {
        return this.stampIntoCode(major, minor, patch, sequence, "_");
    }

    public int stampIntoCode(String major, String minor, String patch, String sequence, String delimiter) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this.src));
        FileWriter writer = new FileWriter(this.dst);
        String s = "";
        String flvl = null;
        if (major != null && minor != null && patch != null && sequence != null) {
            flvl = major + delimiter + minor + delimiter + patch + delimiter + sequence;
            logger.debug("flvl=" + flvl);
        } else {
            logger.debug("flvl not set");
        }
        int number = 0;
        while ((s = reader.readLine()) != null) {
            Matcher m;
            if (major != null) {
                m = this.rx_major_pattern.matcher(s);
                if (m.find()) {
                    s = m.replaceFirst("$1\"" + major + "\"$2");
                    ++number;
                }
                if ((m = this.rx_alt_major_pattern.matcher(s)).find()) {
                    s = m.replaceFirst("$1" + major + "$2");
                    ++number;
                }
            }
            if (minor != null) {
                m = this.rx_minor_pattern.matcher(s);
                if (m.find()) {
                    s = m.replaceFirst("$1\"" + minor + "\"$2");
                    ++number;
                }
                if ((m = this.rx_alt_minor_pattern.matcher(s)).find()) {
                    s = m.replaceFirst("$1" + minor + "$2");
                    ++number;
                }
            }
            if (patch != null) {
                m = this.rx_patch_pattern.matcher(s);
                if (m.find()) {
                    s = m.replaceFirst("$1\"" + patch + "\"$2");
                    ++number;
                }
                if ((m = this.rx_alt_patch_pattern.matcher(s)).find()) {
                    s = m.replaceFirst("$1" + patch + "$2");
                    ++number;
                }
            }
            if (sequence != null) {
                m = this.rx_sequence_pattern.matcher(s);
                if (m.find()) {
                    s = m.replaceFirst("$1\"" + sequence + "\"$2");
                    ++number;
                }
                if ((m = this.rx_alt_sequence_pattern.matcher(s)).find()) {
                    s = m.replaceFirst("$1" + sequence + "$2");
                    ++number;
                }
            }
            if (flvl != null) {
                Matcher mm;
                m = this.rx_sequence_4lvl.matcher(s);
                if (m.find()) {
                    s = m.replaceFirst("$1\"" + flvl + "\"$2");
                    ++number;
                    logger.debug("flvl used");
                }
                if ((mm = this.rx_maven_sequence_4lvl.matcher(s)).find()) {
                    s = mm.replaceFirst("$1<version>" + flvl + "</version>$2");
                    ++number;
                    logger.debug("Maven flvl used");
                }
            }
            writer.write(s + linesep);
        }
        writer.close();
        reader.close();
        BuildNumberStamper.copyFile(this.dst, this.src);
        return number == 0 ? 0 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }
}

