/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.util.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IO {
    public static boolean deleteDirectory(File directory) {
        if (directory.isDirectory()) {
            String[] elements = directory.list();
            for (int i = 0; i < elements.length; ++i) {
                boolean success = IO.deleteDirectory(new File(directory, elements[i]));
                if (success) continue;
                return false;
            }
        }
        return directory.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String streamToString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> streamToStrings(InputStream is) throws IOException {
        if (is != null) {
            ArrayList<String> lines = new ArrayList<String>();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String line = "";
                while ((line = reader.readLine()) != null) {
                    lines.add(line);
                }
            }
            finally {
                is.close();
            }
            return lines;
        }
        return null;
    }
}

