/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.util.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.praqma.util.StopWatch;
import net.praqma.util.debug.Logger;
import net.praqma.util.debug.appenders.StreamAppender;
import net.praqma.util.execute.CommandLine;

public class Net {
    private static Logger logger = Logger.getLogger();
    private static final Pattern rx_nix_gateway = Pattern.compile("^(0\\.0\\.0\\.0|default)\\s+(\\S+)\\s+.*$");
    private static final Pattern rx_ms_gateway = Pattern.compile("^(Default Gateway:)\\s+(\\S+)\\s*$");
    private static final Pattern rx_ms_ping = Pattern.compile("^.*Average = (\\d+).*$", 32);
    private static final Pattern rx_nix_ping = Pattern.compile("^.*[\\d\\.]+/([\\d\\.]+)/[\\d\\.]+/[\\d\\.]+ ms.*$", 32);

    public static String getDefaultGateway() throws IOException {
        try {
            List<String> list = CommandLine.getInstance().run((String)"netstat -rn").stdoutList;
            logger.debug("Out: " + list);
            switch (CommandLine.getInstance().getOS()) {
                case UNIX: {
                    for (String l : list) {
                        Matcher m = rx_nix_gateway.matcher(l);
                        if (!m.find()) continue;
                        return m.group(2);
                    }
                    break;
                }
                case WINDOWS: {
                    for (String l : list) {
                        Matcher m = rx_ms_gateway.matcher(l);
                        if (!m.find()) continue;
                        return m.group(2);
                    }
                    break;
                }
            }
            throw new IOException("Not in the list");
        }
        catch (Exception e) {
            throw new IOException("Unable to get default gateway: " + e.getMessage());
        }
    }

    public static void main(String[] args) throws IOException {
        StreamAppender app = new StreamAppender(System.out);
        app.setMinimumLevel(Logger.LogLevel.DEBUG);
        app.setTemplate("[%level] %space%message%newline");
        Logger.addAppender(app);
        String host = Net.getDefaultGateway();
        logger.info("Host: " + host);
        logger.info("PING: " + Net.ping(host, 10000));
    }

    public static double ping(String host, int timeout) throws IOException {
        try {
            StopWatch sw = new StopWatch();
            sw.start();
            String out = "";
            Matcher m = null;
            switch (CommandLine.getInstance().getOS()) {
                case WINDOWS: {
                    out = CommandLine.getInstance().run((String)new StringBuilder().append((String)"ping -n 1 -w ").append((int)timeout).append((String)" ").append((String)host).toString()).stdoutBuffer.toString();
                    m = rx_ms_ping.matcher(out);
                    if (!m.find()) break;
                    return Double.parseDouble(m.group(1));
                }
                case UNIX: {
                    out = CommandLine.getInstance().run((String)new StringBuilder().append((String)"ping -c 1 -w ").append((int)timeout).append((String)" ").append((String)host).toString()).stdoutBuffer.toString();
                    m = rx_nix_ping.matcher(out);
                    break;
                }
            }
            if (m.find()) {
                return Double.parseDouble(m.group(1));
            }
            throw new IOException("End of loop");
        }
        catch (Exception e) {
            throw new IOException("Unable to ping " + host + ": " + e.getMessage());
        }
    }

    public static double getPing(String host) {
        StopWatch sw = new StopWatch();
        sw.start();
        try {
            InetAddress address = InetAddress.getByName(host);
            System.out.println("Name: " + address.getHostName());
            System.out.println("Addr: " + address.getHostAddress());
            System.out.println("Reach: " + address.isReachable(3000));
        }
        catch (UnknownHostException e) {
            System.err.println("Unable to lookup web.mit.edu");
        }
        catch (IOException e) {
            System.err.println("Unable to reach web.mit.edu");
        }
        sw.stop();
        return sw.getSeconds();
    }
}

